/*
 * Decompiled with CFR 0.152.
 */
package com.watchrabbit.commons.clock;

import com.watchrabbit.commons.callback.VoidCallable;
import com.watchrabbit.commons.exception.SystemException;
import java.util.concurrent.TimeUnit;

public class Stopwatch {
    private VoidCallable callable;
    private Long nanosStart;
    private Long nanosEnd;
    private boolean ended;

    public static Stopwatch create(VoidCallable callable) {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.callable = callable;
        return stopwatch;
    }

    public static Stopwatch createStarted(VoidCallable callable) {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.callable = callable;
        stopwatch.start();
        return stopwatch;
    }

    public Stopwatch start() {
        this.nanosStart = System.nanoTime();
        this.callable.call();
        this.ended = true;
        this.nanosEnd = System.nanoTime();
        return this;
    }

    public long getExecutionTime(TimeUnit timeUnit) {
        if (!this.ended) {
            throw new SystemException("Can't return execution time if Stopwatch wasn't started");
        }
        return timeUnit.convert(this.nanosEnd - this.nanosStart, TimeUnit.NANOSECONDS);
    }
}

