/*
 * Decompiled with CFR 0.152.
 */
package com.watchrabbit.commons.clock;

import com.watchrabbit.commons.callback.UncheckedCallable;
import com.watchrabbit.commons.clock.Clock;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;

public final class SystemClock
implements Clock {
    private UncheckedCallable<Date> dateCallable = Date::new;
    private UncheckedCallable<Instant> instantCallable = Instant::now;
    private UncheckedCallable<Calendar> calendarCallable = Calendar::getInstance;

    private SystemClock() {
    }

    public static SystemClock getInstance() {
        return new SystemClock();
    }

    @Override
    public Date getDate() {
        return this.dateCallable.call();
    }

    public SystemClock withDateProducer(UncheckedCallable<Date> producer) {
        this.dateCallable = producer;
        return this;
    }

    @Override
    public long getTimestamp() {
        return this.dateCallable.call().getTime();
    }

    @Override
    public Instant getInstant() {
        return this.instantCallable.call();
    }

    public SystemClock withInstantProducer(UncheckedCallable<Instant> producer) {
        this.instantCallable = producer;
        return this;
    }

    @Override
    public Calendar getCalendar() {
        return this.calendarCallable.call();
    }

    public SystemClock withCalendarProducer(UncheckedCallable<Calendar> producer) {
        this.calendarCallable = producer;
        return this;
    }
}

