/*
 * Decompiled with CFR 0.152.
 */
package com.watchrabbit.commons.exception;

import com.watchrabbit.commons.callback.CheckedConsumer;
import com.watchrabbit.commons.callback.CheckedPredicate;
import com.watchrabbit.commons.exception.SystemException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Throwables {
    private static final Logger LOGGER = LoggerFactory.getLogger(Throwables.class);

    public static <T> Consumer<T> propagateFromConsumer(CheckedConsumer<T> consumer) throws SystemException {
        return Throwables.propagate(consumer, SystemException::new);
    }

    public static <T, E extends RuntimeException> Consumer<T> propagate(CheckedConsumer<T> consumer, ExceptionWrapper<E> wrapper) throws E {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception e) {
                throw (RuntimeException)wrapper.wrap(e);
            }
        };
    }

    public static <T> Predicate<T> propagateFromPredicate(CheckedPredicate<T> predicate) throws SystemException {
        return Throwables.propagate(predicate, SystemException::new);
    }

    public static <T, E extends RuntimeException> Predicate<T> propagate(CheckedPredicate<T> predicate, ExceptionWrapper<E> wrapper) throws E {
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (Exception e) {
                throw (RuntimeException)wrapper.wrap(e);
            }
        };
    }

    public static <T> Predicate<T> suppress(boolean defaultValue, CheckedPredicate<T> predicate) {
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (Exception ex) {
                LOGGER.info("Supressed exception, returning default value", (Throwable)ex);
                return defaultValue;
            }
        };
    }

    public static <T> Consumer<T> suppress(CheckedConsumer<T> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception ex) {
                LOGGER.info("Supressed exception", (Throwable)ex);
            }
        };
    }

    @FunctionalInterface
    public static interface ExceptionWrapper<E> {
        public E wrap(Exception var1);
    }
}

