/*
 * Decompiled with CFR 0.152.
 */
package com.watchrabbit.commons.sleep;

import com.watchrabbit.commons.exception.SystemException;
import com.watchrabbit.commons.exception.Throwables;
import com.watchrabbit.commons.sleep.SleepBuilder;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class Sleep {
    public static void sleep(long timeout, TimeUnit unit) throws SystemException {
        Throwables.suppress(sleepTimeout -> Thread.sleep(sleepTimeout)).accept(TimeUnit.MILLISECONDS.convert(timeout, unit));
    }

    public static Boolean untilTrue(Callable<Boolean> callable, long timeout, TimeUnit unit) throws SystemException {
        return SleepBuilder.sleep().withComparer(argument -> argument).withTimeout(timeout, unit).withStatement(callable).build();
    }

    public static Boolean untilFalse(Callable<Boolean> callable, long timeout, TimeUnit unit) {
        return SleepBuilder.sleep().withComparer(argument -> argument == false).withTimeout(timeout, unit).withStatement(callable).build();
    }

    public static <T> T untilNull(Callable<T> callable, long timeout, TimeUnit unit) {
        return (T)SleepBuilder.sleep().withComparer(argument -> argument == null).withTimeout(timeout, unit).withStatement(callable).build();
    }

    public static <T> T untilNotNull(Callable<T> callable, long timeout, TimeUnit unit) {
        return (T)SleepBuilder.sleep().withComparer(argument -> argument != null).withTimeout(timeout, unit).withStatement(callable).build();
    }

    public static <T extends Collection> T untilEmpty(Callable<T> callable, long timeout, TimeUnit unit) {
        return (T)SleepBuilder.sleep().withComparer(argument -> argument.isEmpty()).withTimeout(timeout, unit).withStatement(callable).build();
    }

    public static <T extends Collection> T untilNotEmpty(Callable<T> callable, long timeout, TimeUnit unit) {
        return (T)SleepBuilder.sleep().withComparer(argument -> !argument.isEmpty()).withTimeout(timeout, unit).withStatement(callable).build();
    }
}

