/*
 * Decompiled with CFR 0.152.
 */
package com.watchrabbit.commons.sleep;

import com.watchrabbit.commons.callback.ArgumentCallback;
import com.watchrabbit.commons.exception.SystemException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SleepBuilder<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SleepBuilder.class);
    private long interval = 100L;
    private long timeout;
    private ArgumentCallback<Boolean, T> comparer;
    private Callable<T> statement;
    private String name = "sleeper";

    private SleepBuilder() {
    }

    public SleepBuilder<T> withInterval(long interval, TimeUnit timeUnit) {
        this.interval = timeUnit.toMillis(interval);
        return this;
    }

    public SleepBuilder<T> withTimeout(long timeout, TimeUnit timeUnit) {
        this.timeout = timeUnit.toMillis(timeout);
        return this;
    }

    public SleepBuilder<T> withName(String name) {
        this.name = name;
        return this;
    }

    public SleepBuilder<T> withStatement(Callable<T> statement) {
        this.statement = statement;
        return this;
    }

    public SleepBuilder<T> withComparer(ArgumentCallback<Boolean, T> comparer) {
        this.comparer = comparer;
        return this;
    }

    public T build() {
        T result;
        long start = System.currentTimeMillis();
        long sleepingFor = start + this.timeout - System.currentTimeMillis();
        try {
            result = this.statement.call();
            while (this.comparer.call(result).booleanValue() && 0L < sleepingFor) {
                LOGGER.debug("Sleeping on: {}", (Object)this.name);
                LOGGER.debug("Wake up in: {}", (Object)sleepingFor);
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException ex) {
                    LOGGER.error("Sleeper: " + this.name + " interupted!", (Throwable)ex);
                    break;
                }
                sleepingFor = start + this.timeout - System.currentTimeMillis();
                result = this.statement.call();
            }
        }
        catch (Exception ex) {
            LOGGER.error("Callable on sleeper: " + this.name + " throwed exception!", (Throwable)ex);
            throw new SystemException("Callable on sleeper: " + this.name + " throwed exception!", ex);
        }
        return result;
    }

    public static <T> SleepBuilder<T> sleep() {
        return new SleepBuilder<T>();
    }
}

