/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;

public class DeltaCounter
extends Counter {
    private DeltaCounter() {
    }

    public static synchronized DeltaCounter get(MetricRegistry registry, String metricName) {
        if (registry == null || metricName == null || metricName.isEmpty()) {
            throw new IllegalArgumentException("Invalid arguments");
        }
        if (!metricName.startsWith("\u2206") && !metricName.startsWith("\u0394")) {
            metricName = "\u2206" + metricName;
        }
        DeltaCounter counter = new DeltaCounter();
        try {
            return registry.register(metricName, counter);
        }
        catch (IllegalArgumentException e) {
            Counter existing = registry.counter(metricName);
            if (existing instanceof DeltaCounter) {
                return (DeltaCounter)existing;
            }
            throw new IllegalStateException("Existing metric of type: Counter found registered to metricName: " + metricName);
        }
    }
}

