/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.dropwizard.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.DeltaCounter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricAttribute;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.codahale.metrics.WavefrontHistogram;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.entities.histograms.HistogramGranularity;
import com.wavefront.sdk.entities.histograms.WavefrontHistogramImpl;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class DropwizardMetricsReporter
extends ScheduledReporter {
    private static final Logger logger = Logger.getLogger(DropwizardMetricsReporter.class.getCanonicalName());
    private final WavefrontSender wavefrontSender;
    private final Clock clock;
    private final String prefix;
    private final String source;
    private final Map<String, String> reporterPointTags;
    private final Set<HistogramGranularity> histogramGranularities;
    private static final Pattern SIMPLE_NAMES = Pattern.compile("[^a-zA-Z0-9_.\\-~]");

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private DropwizardMetricsReporter(MetricRegistry registry, WavefrontSender wavefrontSender, Clock clock, String prefix, String source, Map<String, String> reporterPointTags, MetricFilter filter, boolean includeJvmMetrics, Set<MetricAttribute> disabledMetricAttributes, Set<HistogramGranularity> histogramGranularities) {
        super(registry, "wavefront-reporter", filter, TimeUnit.SECONDS, TimeUnit.MILLISECONDS, Executors.newSingleThreadScheduledExecutor(), true, disabledMetricAttributes == null ? Collections.emptySet() : disabledMetricAttributes);
        this.wavefrontSender = wavefrontSender;
        this.clock = clock;
        this.prefix = prefix;
        this.source = source;
        this.reporterPointTags = reporterPointTags;
        this.histogramGranularities = histogramGranularities;
        if (includeJvmMetrics) {
            this.tryRegister(registry, "jvm.uptime", () -> ManagementFactory.getRuntimeMXBean().getUptime());
            this.tryRegister(registry, "jvm.current_time", clock::getTime);
            this.tryRegister(registry, "jvm.classes", new ClassLoadingGaugeSet());
            this.tryRegister(registry, "jvm.fd_usage", new FileDescriptorRatioGauge());
            this.tryRegister(registry, "jvm.buffers", new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
            this.tryRegister(registry, "jvm.gc", new GarbageCollectorMetricSet());
            this.tryRegister(registry, "jvm.memory", new MemoryUsageGaugeSet());
            this.tryRegister(registry, "jvm.thread-states", new ThreadStatesGaugeSet());
        }
    }

    private <T extends Metric> void tryRegister(MetricRegistry registry, String name, T metric) {
        try {
            registry.register(name, metric);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.INFO, e.getMessage());
        }
    }

    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        try {
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                if (!(entry.getValue().getValue() instanceof Number)) continue;
                this.reportGauge(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Metric> entry : counters.entrySet()) {
                this.reportCounter(entry.getKey(), (Counter)entry.getValue());
            }
            for (Map.Entry<String, Metric> entry : histograms.entrySet()) {
                this.reportHistogram(entry.getKey(), (Histogram)entry.getValue());
            }
            for (Map.Entry<String, Metric> entry : meters.entrySet()) {
                this.reportMetered(entry.getKey(), (Metered)entry.getValue());
            }
            for (Map.Entry<String, Metric> entry : timers.entrySet()) {
                this.reportTimer(entry.getKey(), (Timer)entry.getValue());
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Unable to report to Wavefront", e);
            try {
                this.wavefrontSender.close();
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "Error closing Wavefront", iOException);
            }
        }
    }

    @Override
    public void stop() {
        try {
            super.stop();
        }
        finally {
            try {
                this.wavefrontSender.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error disconnecting from Wavefront", e);
            }
        }
    }

    public int getFailureCount() {
        return this.wavefrontSender.getFailureCount();
    }

    private void reportTimer(String name, Timer timer) throws IOException {
        Snapshot snapshot = timer.getSnapshot();
        long time = this.clock.getTime() / 1000L;
        this.sendIfEnabled(MetricAttribute.MAX, name, this.convertDuration(snapshot.getMax()), time);
        this.sendIfEnabled(MetricAttribute.MEAN, name, this.convertDuration(snapshot.getMean()), time);
        this.sendIfEnabled(MetricAttribute.MIN, name, this.convertDuration(snapshot.getMin()), time);
        this.sendIfEnabled(MetricAttribute.STDDEV, name, this.convertDuration(snapshot.getStdDev()), time);
        this.sendIfEnabled(MetricAttribute.P50, name, this.convertDuration(snapshot.getMedian()), time);
        this.sendIfEnabled(MetricAttribute.P75, name, this.convertDuration(snapshot.get75thPercentile()), time);
        this.sendIfEnabled(MetricAttribute.P95, name, this.convertDuration(snapshot.get95thPercentile()), time);
        this.sendIfEnabled(MetricAttribute.P98, name, this.convertDuration(snapshot.get98thPercentile()), time);
        this.sendIfEnabled(MetricAttribute.P99, name, this.convertDuration(snapshot.get99thPercentile()), time);
        this.sendIfEnabled(MetricAttribute.P999, name, this.convertDuration(snapshot.get999thPercentile()), time);
        this.reportMetered(name, timer);
    }

    private void reportMetered(String name, Metered meter) throws IOException {
        long time = this.clock.getTime() / 1000L;
        this.sendIfEnabled(MetricAttribute.COUNT, name, meter.getCount(), time);
        this.sendIfEnabled(MetricAttribute.M1_RATE, name, this.convertRate(meter.getOneMinuteRate()), time);
        this.sendIfEnabled(MetricAttribute.M5_RATE, name, this.convertRate(meter.getFiveMinuteRate()), time);
        this.sendIfEnabled(MetricAttribute.M15_RATE, name, this.convertRate(meter.getFifteenMinuteRate()), time);
        this.sendIfEnabled(MetricAttribute.MEAN_RATE, name, this.convertRate(meter.getMeanRate()), time);
    }

    private void reportHistogram(String name, Histogram histogram) throws IOException {
        if (histogram instanceof WavefrontHistogram) {
            String histogramName = this.prefixAndSanitize(name);
            for (WavefrontHistogramImpl.Distribution distribution : ((WavefrontHistogram)histogram).flushDistributions()) {
                this.wavefrontSender.sendDistribution(histogramName, distribution.centroids, this.histogramGranularities, distribution.timestamp, this.source, this.reporterPointTags);
            }
        } else {
            Snapshot snapshot = histogram.getSnapshot();
            long time = this.clock.getTime() / 1000L;
            this.sendIfEnabled(MetricAttribute.COUNT, name, histogram.getCount(), time);
            this.sendIfEnabled(MetricAttribute.MAX, name, snapshot.getMax(), time);
            this.sendIfEnabled(MetricAttribute.MEAN, name, snapshot.getMean(), time);
            this.sendIfEnabled(MetricAttribute.MIN, name, snapshot.getMin(), time);
            this.sendIfEnabled(MetricAttribute.STDDEV, name, snapshot.getStdDev(), time);
            this.sendIfEnabled(MetricAttribute.P50, name, snapshot.getMedian(), time);
            this.sendIfEnabled(MetricAttribute.P75, name, snapshot.get75thPercentile(), time);
            this.sendIfEnabled(MetricAttribute.P95, name, snapshot.get95thPercentile(), time);
            this.sendIfEnabled(MetricAttribute.P98, name, snapshot.get98thPercentile(), time);
            this.sendIfEnabled(MetricAttribute.P99, name, snapshot.get99thPercentile(), time);
            this.sendIfEnabled(MetricAttribute.P999, name, snapshot.get999thPercentile(), time);
        }
    }

    private void reportCounter(String name, Counter counter) throws IOException {
        if (counter instanceof DeltaCounter) {
            long count = counter.getCount();
            name = "\u2206" + this.prefixAndSanitize(name.substring(1), "count");
            this.wavefrontSender.sendDeltaCounter(name, count, this.source, this.reporterPointTags);
            counter.dec(count);
        } else {
            this.wavefrontSender.sendMetric(this.prefixAndSanitize(name, "count"), counter.getCount(), this.clock.getTime() / 1000L, this.source, this.reporterPointTags);
        }
    }

    private void reportGauge(String name, Gauge<Number> gauge) throws IOException {
        this.wavefrontSender.sendMetric(this.prefixAndSanitize(name), gauge.getValue().doubleValue(), this.clock.getTime() / 1000L, this.source, this.reporterPointTags);
    }

    private void sendIfEnabled(MetricAttribute type, String name, double value, long timestamp) throws IOException {
        if (!this.getDisabledMetricAttributes().contains((Object)type)) {
            this.wavefrontSender.sendMetric(this.prefixAndSanitize(name, type.getCode()), value, timestamp, this.source, this.reporterPointTags);
        }
    }

    private String prefixAndSanitize(String ... components) {
        return DropwizardMetricsReporter.sanitize(MetricRegistry.name(this.prefix, components));
    }

    private static String sanitize(String name) {
        return SIMPLE_NAMES.matcher(name).replaceAll("_");
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Clock clock;
        private String prefix;
        private MetricFilter filter;
        private String source;
        private final Map<String, String> reporterPointTags;
        private boolean includeJvmMetrics;
        private Set<MetricAttribute> disabledMetricAttributes;
        private final Set<HistogramGranularity> histogramGranularities;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.prefix = null;
            this.filter = MetricFilter.ALL;
            this.source = "dropwizard-metrics";
            this.reporterPointTags = new HashMap<String, String>();
            this.includeJvmMetrics = false;
            this.disabledMetricAttributes = Collections.emptySet();
            this.histogramGranularities = new HashSet<HistogramGranularity>();
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder withSource(String source) {
            this.source = source;
            return this;
        }

        public Builder withReporterPointTags(Map<String, String> reporterPointTags) {
            this.reporterPointTags.putAll(reporterPointTags);
            return this;
        }

        public Builder withReporterPointTag(String tagKey, String tagVal) {
            this.reporterPointTags.put(tagKey, tagVal);
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder disabledMetricAttributes(Set<MetricAttribute> disabledMetricAttributes) {
            this.disabledMetricAttributes = disabledMetricAttributes;
            return this;
        }

        public Builder withJvmMetrics() {
            this.includeJvmMetrics = true;
            return this;
        }

        public Builder reportMinuteDistribution() {
            this.histogramGranularities.add(HistogramGranularity.MINUTE);
            return this;
        }

        public Builder reportHourDistribution() {
            this.histogramGranularities.add(HistogramGranularity.HOUR);
            return this;
        }

        public Builder reportDayDistribution() {
            this.histogramGranularities.add(HistogramGranularity.DAY);
            return this;
        }

        public DropwizardMetricsReporter build(WavefrontSender wavefrontSender) {
            return new DropwizardMetricsReporter(this.registry, wavefrontSender, this.clock, this.prefix, this.source, this.reporterPointTags, this.filter, this.includeJvmMetrics, this.disabledMetricAttributes, this.histogramGranularities);
        }
    }
}

