/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.dropwizard.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.DeltaCounter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricAttribute;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.WavefrontHistogram;
import com.wavefront.dropwizard.metrics.DropwizardMetricsReporter;
import com.wavefront.sdk.direct_ingestion.WavefrontDirectIngestionClient;
import com.wavefront.sdk.proxy.WavefrontProxyClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Main {
    public static void main(String[] args) throws InterruptedException, IOException {
        String wavefrontServer = args[0];
        String token = args[1];
        String proxyHost = args.length < 3 ? null : args[2];
        String metricsPort = args.length < 4 ? null : args[3];
        String distributionPort = args.length < 5 ? null : args[4];
        WavefrontProxyClient.Builder proxyBuilder = new WavefrontProxyClient.Builder(proxyHost);
        if (metricsPort != null) {
            proxyBuilder.metricsPort(Integer.parseInt(metricsPort));
        }
        if (distributionPort != null) {
            proxyBuilder.distributionPort(Integer.parseInt(distributionPort));
        }
        WavefrontProxyClient wavefrontProxyClient = proxyBuilder.build();
        WavefrontDirectIngestionClient wavefrontDirectIngestionClient = new WavefrontDirectIngestionClient.Builder(wavefrontServer, token).build();
        MetricRegistry metricRegistry = new MetricRegistry();
        DropwizardMetricsReporter.Builder builder = DropwizardMetricsReporter.forRegistry(metricRegistry);
        builder.withSource("mySource");
        builder.prefixedWith("myPrefix");
        builder.withClock(new Clock(){

            @Override
            public long getTick() {
                return System.currentTimeMillis();
            }
        });
        builder.withReporterPointTags((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("env", "Staging");
                this.put("location", "SF");
            }
        });
        builder.withReporterPointTag("cluster", "us-west");
        builder.filter(MetricFilter.startsWith("my"));
        HashSet<MetricAttribute> set = new HashSet<MetricAttribute>();
        set.add(MetricAttribute.STDDEV);
        set.add(MetricAttribute.M15_RATE);
        builder.disabledMetricAttributes(set);
        builder.withJvmMetrics();
        builder.reportMinuteDistribution();
        builder.reportHourDistribution();
        builder.reportDayDistribution();
        DropwizardMetricsReporter dropwizardMetricsReporter = builder.build(wavefrontDirectIngestionClient);
        dropwizardMetricsReporter.start(30L, TimeUnit.SECONDS);
        Counter notReported = metricRegistry.counter("notMyCounter");
        Counter counter = metricRegistry.counter("myCounter");
        DeltaCounter deltaCounter = DeltaCounter.get(metricRegistry, "myDeltaCounter");
        AtomicInteger bufferSize = new AtomicInteger();
        Gauge<Object> gauge = metricRegistry.register("myGauge", () -> bufferSize.get());
        Meter meter = metricRegistry.meter("myMeter");
        Timer timer = metricRegistry.timer("myTimer");
        Histogram dropwizardHistogram = metricRegistry.histogram("myDropwizardHistogram");
        WavefrontHistogram wavefrontHistogram = WavefrontHistogram.get(metricRegistry, "myWavefrontHistogram");
        for (int i = 0; i < 50; ++i) {
            counter.inc();
            deltaCounter.inc();
            notReported.inc();
            bufferSize.set(10 * i);
            meter.mark(i);
            timer.update(i, TimeUnit.SECONDS);
            dropwizardHistogram.update(i);
            wavefrontHistogram.update(i);
            wavefrontHistogram.update((double)i * 1.0);
            Thread.sleep(50L);
        }
    }
}

