/*
 * Decompiled with CFR 0.152.
 */
package com.tdunning.math.stats;

import com.google.common.base.Preconditions;
import com.tdunning.math.stats.AbstractTDigest;
import com.tdunning.math.stats.Centroid;
import com.tdunning.math.stats.Sort;
import com.tdunning.math.stats.TDigest;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jafama.FastMath;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.ReadResolvable;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.SizedWriter;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import wavefront.report.Histogram;
import wavefront.report.HistogramType;

public class AgentDigest
extends AbstractTDigest {
    private final short compression;
    private int lastUsedCell;
    private double totalWeight = 0.0;
    private double[] weight;
    private double[] mean;
    private List<List<Double>> data = null;
    private double[] mergeWeight;
    private double[] mergeMean;
    private List<List<Double>> mergeData = null;
    private double unmergedWeight = 0.0;
    private int tempUsed = 0;
    private final double[] tempWeight;
    private final double[] tempMean;
    private List<List<Double>> tempData = null;
    private final int[] order;
    private long dispatchTimeMillis;
    private static final int FIXED_SIZE = 10;
    private static final int PER_CENTROID_SIZE = 8;

    private static int defaultSizeForCompression(short compression) {
        return (int)(Math.PI * (double)compression + 0.5);
    }

    private static int bufferSizeForCompression(short compression) {
        return (int)(7.5 + 0.37 * (double)compression - 2.0E-4 * (double)compression * (double)compression);
    }

    public AgentDigest(short compression, long dispatchTimeMillis) {
        Preconditions.checkArgument(((double)compression >= 20.0 ? 1 : 0) != 0);
        Preconditions.checkArgument(((double)compression <= 1000.0 ? 1 : 0) != 0);
        int numCentroids = AgentDigest.defaultSizeForCompression(compression);
        int numBuffered = AgentDigest.bufferSizeForCompression(compression);
        this.compression = compression;
        this.weight = new double[numCentroids];
        this.mean = new double[numCentroids];
        this.mergeWeight = new double[numCentroids];
        this.mergeMean = new double[numCentroids];
        this.tempWeight = new double[numBuffered];
        this.tempMean = new double[numBuffered];
        this.order = new int[numBuffered];
        this.lastUsedCell = 0;
        this.dispatchTimeMillis = dispatchTimeMillis;
    }

    public TDigest recordAllData() {
        super.recordAllData();
        this.data = new ArrayList<List<Double>>();
        this.mergeData = new ArrayList<List<Double>>();
        return this;
    }

    void add(double x, int w, Centroid base) {
        this.add(x, w, base.data());
    }

    public void add(double x, int w) {
        this.add(x, w, (List<Double>)null);
    }

    public void add(List<? extends TDigest> others) {
        for (TDigest tDigest : others) {
            this.setMinMax(Math.min(this.min, tDigest.getMin()), Math.max(this.max, tDigest.getMax()));
            for (Centroid centroid : tDigest.centroids()) {
                this.add(centroid.mean(), centroid.count(), this.recordAllData ? centroid.data() : null);
            }
        }
    }

    public void add(double x, int w, List<Double> history) {
        if (Double.isNaN(x)) {
            throw new IllegalArgumentException("Cannot add NaN to t-digest");
        }
        if (this.tempUsed >= this.tempWeight.length) {
            this.mergeNewValues();
        }
        int where = this.tempUsed++;
        this.tempWeight[where] = w;
        this.tempMean[where] = x;
        this.unmergedWeight += (double)w;
        if (this.data != null) {
            if (this.tempData == null) {
                this.tempData = new ArrayList<List<Double>>();
            }
            while (this.tempData.size() <= where) {
                this.tempData.add(new ArrayList());
            }
            if (history == null) {
                history = Collections.singletonList(x);
            }
            this.tempData.get(where).addAll(history);
        }
    }

    private void mergeNewValues() {
        if (this.unmergedWeight > 0.0) {
            int ix;
            Sort.sort((int[])this.order, (double[])this.tempMean, (int)this.tempUsed);
            double wSoFar = 0.0;
            double k1 = 0.0;
            int i = 0;
            int j = 0;
            int n = 0;
            if (this.totalWeight > 0.0) {
                n = this.weight[this.lastUsedCell] > 0.0 ? this.lastUsedCell + 1 : this.lastUsedCell;
            }
            this.lastUsedCell = 0;
            this.totalWeight += this.unmergedWeight;
            this.unmergedWeight = 0.0;
            while (i < this.tempUsed && j < n) {
                ix = this.order[i];
                if (this.tempMean[ix] <= this.mean[j]) {
                    k1 = this.mergeCentroid(wSoFar += this.tempWeight[ix], k1, this.tempWeight[ix], this.tempMean[ix], this.tempData != null ? this.tempData.get(ix) : null);
                    ++i;
                    continue;
                }
                k1 = this.mergeCentroid(wSoFar += this.weight[j], k1, this.weight[j], this.mean[j], this.data != null ? this.data.get(j) : null);
                ++j;
            }
            while (i < this.tempUsed) {
                ix = this.order[i];
                k1 = this.mergeCentroid(wSoFar += this.tempWeight[ix], k1, this.tempWeight[ix], this.tempMean[ix], this.tempData != null ? this.tempData.get(ix) : null);
                ++i;
            }
            while (j < n) {
                k1 = this.mergeCentroid(wSoFar += this.weight[j], k1, this.weight[j], this.mean[j], this.data != null ? this.data.get(j) : null);
                ++j;
            }
            this.tempUsed = 0;
            double[] z = this.weight;
            this.weight = this.mergeWeight;
            this.mergeWeight = z;
            Arrays.fill(this.mergeWeight, 0.0);
            z = this.mean;
            this.mean = this.mergeMean;
            this.mergeMean = z;
            if (this.data != null) {
                this.data = this.mergeData;
                this.mergeData = new ArrayList<List<Double>>();
                this.tempData = new ArrayList<List<Double>>();
            }
        }
    }

    private double mergeCentroid(double wSoFar, double k1, double w, double m, List<Double> newData) {
        double k2 = this.integratedLocation(wSoFar / this.totalWeight);
        if (k2 - k1 <= 1.0 || this.mergeWeight[this.lastUsedCell] == 0.0) {
            int n = this.lastUsedCell;
            this.mergeWeight[n] = this.mergeWeight[n] + w;
            this.mergeMean[this.lastUsedCell] = this.mergeMean[this.lastUsedCell] + (m - this.mergeMean[this.lastUsedCell]) * w / this.mergeWeight[this.lastUsedCell];
        } else {
            ++this.lastUsedCell;
            this.mergeMean[this.lastUsedCell] = m;
            this.mergeWeight[this.lastUsedCell] = w;
            k1 = this.integratedLocation((wSoFar - w) / this.totalWeight);
        }
        if (this.mergeData != null) {
            while (this.mergeData.size() <= this.lastUsedCell) {
                this.mergeData.add(new ArrayList());
            }
            this.mergeData.get(this.lastUsedCell).addAll(newData);
        }
        return k1;
    }

    int checkWeights() {
        return this.checkWeights(this.weight, this.totalWeight, this.lastUsedCell);
    }

    private int checkWeights(double[] w, double total, int last) {
        int badCount = 0;
        int n = last;
        if (w[n] > 0.0) {
            ++n;
        }
        double k1 = 0.0;
        double q = 0.0;
        for (int i = 0; i < n; ++i) {
            double dq = w[i] / total;
            double k2 = this.integratedLocation(q + dq);
            if (k2 - k1 > 1.0 && w[i] != 1.0) {
                System.out.printf("Oversize centroid at %d, k0=%.2f, k1=%.2f, dk=%.2f, w=%.2f, q=%.4f\n", i, k1, k2, k2 - k1, w[i], q);
                ++badCount;
            }
            if (k2 - k1 > 1.5 && w[i] != 1.0) {
                throw new IllegalStateException(String.format("Egregiously oversized centroid at %d, k0=%.2f, k1=%.2f, dk=%.2f, w=%.2f, q=%.4f\n", i, k1, k2, k2 - k1, w[i], q));
            }
            q += dq;
            k1 = k2;
        }
        return badCount;
    }

    private double integratedLocation(double q) {
        return (double)this.compression * (FastMath.asin((double)(2.0 * q - 1.0)) + 1.5707963267948966) / Math.PI;
    }

    public void compress() {
        this.mergeNewValues();
    }

    public long size() {
        return (long)(this.totalWeight + this.unmergedWeight);
    }

    public double cdf(double x) {
        return Double.NaN;
    }

    public double quantile(double q) {
        return Double.NaN;
    }

    public Collection<Centroid> centroids() {
        ArrayList<Centroid> r = new ArrayList<Centroid>();
        int count = this.centroidCount();
        for (int i = 0; i < count; ++i) {
            r.add(new Centroid(this.mean[i], (int)this.weight[i], this.data != null ? this.data.get(i) : null));
        }
        return r;
    }

    public double compression() {
        return this.compression;
    }

    public int byteSize() {
        return 0;
    }

    public int smallByteSize() {
        return 0;
    }

    public int centroidCount() {
        this.mergeNewValues();
        return this.lastUsedCell + (this.weight[this.lastUsedCell] == 0.0 ? 0 : 1);
    }

    public Histogram toHistogram(int duration) {
        int numCentroids = this.centroidCount();
        ArrayList<Double> means = new ArrayList<Double>(this.centroidCount());
        ArrayList<Integer> count = new ArrayList<Integer>(this.centroidCount());
        for (int i = 0; i < numCentroids; ++i) {
            means.add(this.mean[i]);
            count.add((int)Math.round(this.weight[i]));
        }
        return Histogram.newBuilder().setDuration(duration).setBins(means).setCounts(count).setType(HistogramType.TDIGEST).build();
    }

    private int encodedSize() {
        return 10 + this.centroidCount() * 8;
    }

    public void asBytes(ByteBuffer buf) {
    }

    public void asSmallBytes(ByteBuffer buf) {
    }

    public long getDispatchTimeMillis() {
        return this.dispatchTimeMillis;
    }

    public static class AgentDigestMarshaller
    implements SizedReader<AgentDigest>,
    SizedWriter<AgentDigest>,
    ReadResolvable<AgentDigestMarshaller> {
        private static final AgentDigestMarshaller INSTANCE = new AgentDigestMarshaller();
        private static final com.yammer.metrics.core.Histogram accumulatorValueSizes = Metrics.newHistogram((MetricName)new MetricName("histogram", "", "accumulatorValueSize"));

        private AgentDigestMarshaller() {
        }

        public static AgentDigestMarshaller get() {
            return INSTANCE;
        }

        @Nonnull
        public AgentDigest read(Bytes in, long size, @Nullable AgentDigest using) {
            Preconditions.checkArgument((size >= 10L ? 1 : 0) != 0);
            short compression = in.readShort();
            if (using == null || using.compression != compression) {
                using = new AgentDigest(compression, in.readLong());
            } else {
                using.dispatchTimeMillis = in.readLong();
            }
            using.totalWeight = 0.0;
            using.lastUsedCell = (int)((size - 10L) / 8L);
            using.tempUsed = 0;
            using.unmergedWeight = 0.0;
            Arrays.fill(using.weight, using.lastUsedCell, using.weight.length, 0.0);
            for (int i = 0; i < using.lastUsedCell; ++i) {
                float weight = in.readFloat();
                ((AgentDigest)using).weight[i] = weight;
                ((AgentDigest)using).mean[i] = in.readFloat();
                using.totalWeight += weight;
            }
            return using;
        }

        public long size(@Nonnull AgentDigest toWrite) {
            long size = toWrite.encodedSize();
            accumulatorValueSizes.update(size);
            return size;
        }

        public void write(Bytes out, long size, @Nonnull AgentDigest toWrite) {
            int numCentroids = toWrite.centroidCount();
            Preconditions.checkArgument((size == (long)toWrite.encodedSize() ? 1 : 0) != 0);
            out.writeShort(toWrite.compression);
            out.writeLong(toWrite.dispatchTimeMillis);
            for (int i = 0; i < numCentroids; ++i) {
                out.writeFloat((float)toWrite.weight[i]);
                out.writeFloat((float)toWrite.mean[i]);
            }
        }

        @Nonnull
        public AgentDigestMarshaller readResolve() {
            return INSTANCE;
        }

        public void readMarshallable(@Nonnull WireIn wire) throws IORuntimeException {
        }

        public void writeMarshallable(@Nonnull WireOut wire) {
        }
    }
}

