/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.wavefront.agent.ProxyConfig;
import com.wavefront.agent.ProxySendConfigScheduler;
import com.wavefront.agent.TenantInfo;
import com.wavefront.agent.TokenManager;
import com.wavefront.agent.api.APIContainer;
import com.wavefront.agent.preprocessor.PreprocessorConfigManager;
import com.wavefront.api.agent.AgentConfiguration;
import com.wavefront.api.agent.ValidationConfiguration;
import com.wavefront.common.Clock;
import com.wavefront.common.NamedThreadFactory;
import com.wavefront.common.Utils;
import com.wavefront.metrics.JsonMetricsGenerator;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricsRegistry;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ProcessingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProxyCheckInScheduler {
    private static final Logger logger = LogManager.getLogger((String)"proxy");
    private static final int MAX_CHECKIN_ATTEMPTS = 5;
    private static final String ID = Integer.toHexString((int)(Math.random() * 2.147483647E9));
    private final UUID proxyId;
    private final ProxyConfig proxyConfig;
    private final APIContainer apiContainer;
    private final BiConsumer<String, AgentConfiguration> agentConfigurationConsumer;
    private final Runnable shutdownHook;
    private final Runnable truncateBacklog;
    private final AtomicInteger retries = new AtomicInteger(0);
    private final AtomicLong successfulCheckIns = new AtomicLong(0L);
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2, (ThreadFactory)new NamedThreadFactory("proxy-configuration"));
    private String serverEndpointUrl = null;
    private volatile JsonNode agentMetrics;
    private boolean retryImmediately = false;
    public static AtomicBoolean preprocessorRulesNeedUpdate = new AtomicBoolean(false);

    public ProxyCheckInScheduler(UUID proxyId, ProxyConfig proxyConfig, APIContainer apiContainer, BiConsumer<String, AgentConfiguration> agentConfigurationConsumer, Runnable shutdownHook, Runnable truncateBacklog) {
        this.proxyId = proxyId;
        this.proxyConfig = proxyConfig;
        this.apiContainer = apiContainer;
        this.agentConfigurationConsumer = agentConfigurationConsumer;
        this.shutdownHook = shutdownHook;
        this.truncateBacklog = truncateBacklog;
        this.updateProxyMetrics();
        Map<String, AgentConfiguration> configList = this.checkin();
        new ProxySendConfigScheduler(apiContainer, proxyId, proxyConfig).start();
        if (configList == null && this.retryImmediately) {
            this.updateProxyMetrics();
            configList = this.checkin();
            this.sendPreprocessorRules();
        }
        if (configList != null && !configList.isEmpty()) {
            logger.info("initial configuration is available, setting up proxy");
            for (Map.Entry<String, AgentConfiguration> configEntry : configList.entrySet()) {
                agentConfigurationConsumer.accept(configEntry.getKey(), configEntry.getValue());
                this.successfulCheckIns.incrementAndGet();
            }
        }
    }

    public void scheduleCheckins() {
        logger.info("scheduling regular check-ins");
        this.executor.scheduleAtFixedRate(this::updateProxyMetrics, 60L, 60L, TimeUnit.SECONDS);
        this.executor.scheduleWithFixedDelay(this::updateConfiguration, 0L, 1L, TimeUnit.SECONDS);
    }

    public long getSuccessfulCheckinCount() {
        return this.successfulCheckIns.get();
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    private void sendPreprocessorRules() {
        if (preprocessorRulesNeedUpdate.getAndSet(false)) {
            try {
                this.apiContainer.getProxyV2APIForTenant("central").proxySavePreprocessorRules(this.proxyId, PreprocessorConfigManager.getJsonRules());
            }
            catch (NotFoundException ex) {
                logger.debug("'proxySavePreprocessorRules' api end point not found", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, AgentConfiguration> checkin() {
        JsonNode agentMetricsWorkingCopy;
        HashMap configurationList = Maps.newHashMap();
        ScheduledExecutorService scheduledExecutorService = this.executor;
        synchronized (scheduledExecutorService) {
            if (this.agentMetrics == null) {
                return null;
            }
            agentMetricsWorkingCopy = this.agentMetrics;
            this.agentMetrics = null;
            if (this.retries.incrementAndGet() > 5) {
                return null;
            }
        }
        Map<String, TenantInfo> multicastingTenantList = TokenManager.getMulticastingTenantList();
        String tenantName = "central";
        TenantInfo multicastingTenantProxyConfig = multicastingTenantList.get("central");
        try {
            for (Map.Entry<String, TenantInfo> multicastingTenantEntry : multicastingTenantList.entrySet()) {
                tenantName = multicastingTenantEntry.getKey();
                multicastingTenantProxyConfig = multicastingTenantEntry.getValue();
                logger.info("Checking in tenants: " + multicastingTenantProxyConfig.getWFServer());
                ScheduledExecutorService multicastingConfig = this.apiContainer.getProxyV2APIForTenant(tenantName).proxyCheckin(this.proxyId, "Bearer " + multicastingTenantProxyConfig.getBearerToken(), this.proxyConfig.getHostname() + (multicastingTenantList.size() > 1 ? "-multi_tenant" : ""), this.proxyConfig.getProxyname(), Utils.getBuildVersion(), Long.valueOf(System.currentTimeMillis()), agentMetricsWorkingCopy, Boolean.valueOf(this.proxyConfig.isEphemeral()));
                configurationList.put(tenantName, multicastingConfig);
            }
            agentMetricsWorkingCopy = null;
        }
        catch (ClientErrorException ex) {
            Object serverUrl;
            agentMetricsWorkingCopy = null;
            switch (ex.getResponse().getStatus()) {
                case 401: {
                    this.checkinError("HTTP 401 Unauthorized: Please verify that your server and token settings are correct and that the token has Proxy Management permission!");
                    if (this.successfulCheckIns.get() != 0L) break;
                    throw new RuntimeException("Aborting start-up");
                }
                case 403: {
                    this.checkinError("HTTP 403 Forbidden: Please verify that your token has Proxy Management permission!");
                    if (this.successfulCheckIns.get() != 0L) break;
                    throw new RuntimeException("Aborting start-up");
                }
                case 404: 
                case 405: {
                    serverUrl = multicastingTenantProxyConfig.getWFServer().replaceAll("/$", "");
                    if (this.successfulCheckIns.get() == 0L && !this.retryImmediately && !((String)serverUrl).endsWith("/api")) {
                        this.serverEndpointUrl = (String)serverUrl + "/api/";
                        this.checkinError("Possible server endpoint misconfiguration detected, attempting to use " + this.serverEndpointUrl);
                        this.apiContainer.updateServerEndpointURL(tenantName, this.serverEndpointUrl);
                        this.retryImmediately = true;
                        Map<String, AgentConfiguration> multicastingTenantEntry = null;
                        return multicastingTenantEntry;
                    }
                    String secondaryMessage = ((String)serverUrl).endsWith("/api") ? "Current setting: " + multicastingTenantProxyConfig.getWFServer() : "Server endpoint URLs normally end with '/api/'. Current setting: " + multicastingTenantProxyConfig.getBearerToken();
                    this.checkinError("HTTP " + ex.getResponse().getStatus() + ": Misconfiguration detected, please verify that your server setting is correct. " + (String)secondaryMessage);
                    if (this.successfulCheckIns.get() != 0L) break;
                    throw new RuntimeException("Aborting start-up");
                }
                case 407: {
                    this.checkinError("HTTP 407 Proxy Authentication Required: Please verify that proxyUser and proxyPassword settings are correct and make sure your HTTP proxy is not rate limiting!");
                    if (this.successfulCheckIns.get() != 0L) break;
                    throw new RuntimeException("Aborting start-up");
                }
                case 429: {
                    Map<String, AgentConfiguration> map = null;
                    return map;
                }
                default: {
                    this.checkinError("HTTP " + ex.getResponse().getStatus() + " error: Unable to check in with Wavefront! " + multicastingTenantProxyConfig.getWFServer() + ": " + Throwables.getRootCause((Throwable)ex).getMessage());
                }
            }
            serverUrl = Maps.newHashMap();
            return serverUrl;
        }
        catch (ProcessingException ex) {
            Throwable rootCause = Throwables.getRootCause((Throwable)ex);
            if (rootCause instanceof UnknownHostException) {
                this.checkinError("Unknown host: " + multicastingTenantProxyConfig.getWFServer() + ". Please verify your DNS and network settings!");
                Map<String, AgentConfiguration> secondaryMessage = null;
                return secondaryMessage;
            }
            if (rootCause instanceof ConnectException) {
                this.checkinError("Unable to connect to " + multicastingTenantProxyConfig.getWFServer() + ": " + rootCause.getMessage() + " Please verify your network/firewall settings!");
                Map<String, AgentConfiguration> secondaryMessage = null;
                return secondaryMessage;
            }
            if (rootCause instanceof SocketTimeoutException) {
                this.checkinError("Unable to check in with " + multicastingTenantProxyConfig.getWFServer() + ": " + rootCause.getMessage() + " Please verify your network/firewall settings!");
                Map<String, AgentConfiguration> secondaryMessage = null;
                return secondaryMessage;
            }
            this.checkinError("Request processing error: Unable to retrieve proxy configuration! " + multicastingTenantProxyConfig.getWFServer() + ": " + rootCause);
            Map<String, AgentConfiguration> secondaryMessage = null;
            return secondaryMessage;
        }
        catch (Exception ex) {
            this.checkinError("Unable to retrieve proxy configuration from remote server! " + multicastingTenantProxyConfig.getWFServer() + ": " + Throwables.getRootCause((Throwable)ex));
            Map<String, AgentConfiguration> rootCause = null;
            return rootCause;
        }
        finally {
            ScheduledExecutorService scheduledExecutorService2 = this.executor;
            synchronized (scheduledExecutorService2) {
                if (agentMetricsWorkingCopy != null && this.agentMetrics == null) {
                    this.agentMetrics = agentMetricsWorkingCopy;
                }
            }
        }
        if (((AgentConfiguration)configurationList.get((Object)"central")).currentTime != null) {
            Clock.set((long)((AgentConfiguration)configurationList.get((Object)"central")).currentTime);
        }
        String logServerIngestionURL = ((AgentConfiguration)configurationList.get("central")).getLogServerEndpointUrl();
        String logServerIngestionToken = ((AgentConfiguration)configurationList.get("central")).getLogServerToken();
        String WARNING_MSG = "Missing either logServerIngestionToken/logServerIngestionURL or both.";
        if (StringUtils.isBlank((String)logServerIngestionURL) && StringUtils.isBlank((String)logServerIngestionToken)) {
            ValidationConfiguration validationConfiguration = ((AgentConfiguration)configurationList.get("central")).getValidationConfiguration();
            if (validationConfiguration != null && validationConfiguration.enableHyperlogsConvergedCsp()) {
                this.proxyConfig.setEnableHyperlogsConvergedCsp(true);
                logServerIngestionURL = this.proxyConfig.getLogServerIngestionURL();
                logServerIngestionToken = this.proxyConfig.getLogServerIngestionToken();
                if (StringUtils.isBlank((String)logServerIngestionURL) || StringUtils.isBlank((String)logServerIngestionToken)) {
                    this.proxyConfig.setReceivedLogServerDetails(false);
                    logger.error(WARNING_MSG + " To ingest logs to the log server, please provide logServerIngestionToken & logServerIngestionURL in the proxy configuration.");
                }
            }
        } else if (StringUtils.isBlank((String)logServerIngestionURL) || StringUtils.isBlank((String)logServerIngestionToken)) {
            logger.warn(WARNING_MSG + " Proxy will not be ingesting data to the log server as it did not receive at least one of the values during check-in.");
        }
        this.apiContainer.updateLogServerEndpointURLandToken(logServerIngestionURL, logServerIngestionToken);
        return configurationList;
    }

    @VisibleForTesting
    void updateConfiguration() {
        try {
            Map<String, AgentConfiguration> configList = this.checkin();
            this.sendPreprocessorRules();
            if (configList != null && !configList.isEmpty()) {
                for (Map.Entry<String, AgentConfiguration> configEntry : configList.entrySet()) {
                    AgentConfiguration config = configEntry.getValue();
                    if (config == null) continue;
                    if (configEntry.getKey().equals("central")) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Server configuration getShutOffAgents: " + config.getShutOffAgents());
                            logger.debug("Server configuration isTruncateQueue: " + config.isTruncateQueue());
                        }
                        if (config.getShutOffAgents()) {
                            logger.warn((String)ObjectUtils.firstNonNull((Object[])new String[]{config.getShutOffMessage(), "Shutting down: Server side flag indicating proxy has to shut down."}));
                            this.shutdownHook.run();
                        } else if (config.isTruncateQueue()) {
                            logger.warn("Truncating queue: Server side flag indicating proxy queue has to be truncated.");
                            this.truncateBacklog.run();
                        }
                    }
                    this.agentConfigurationConsumer.accept(configEntry.getKey(), config);
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception occurred during configuration update", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void updateProxyMetrics() {
        try {
            HashMap<String, String> pointTags = new HashMap<String, String>(this.proxyConfig.getAgentMetricsPointTags());
            pointTags.put("processId", ID);
            pointTags.put("hostname", this.proxyConfig.getHostname());
            ScheduledExecutorService scheduledExecutorService = this.executor;
            synchronized (scheduledExecutorService) {
                this.agentMetrics = JsonMetricsGenerator.generateJsonMetrics((MetricsRegistry)Metrics.defaultRegistry(), (boolean)true, (boolean)true, (boolean)true, pointTags, null);
                this.retries.set(0);
            }
        }
        catch (Exception ex) {
            logger.error("Could not generate proxy metrics", (Throwable)ex);
        }
    }

    private void checkinError(String errMsg) {
        if (this.successfulCheckIns.get() == 0L) {
            logger.error(Strings.repeat((String)"*", (int)errMsg.length()));
        }
        logger.error(errMsg);
        if (this.successfulCheckIns.get() == 0L) {
            logger.error(Strings.repeat((String)"*", (int)errMsg.length()));
        }
    }
}

