/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent;

import com.wavefront.agent.ProxyConfig;
import com.wavefront.agent.api.APIContainer;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.NotFoundException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProxySendConfigScheduler {
    private static final Logger logger = LogManager.getLogger((String)ProxySendConfigScheduler.class.getCanonicalName());
    private boolean successful = false;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private final Runnable task = () -> {
        try {
            apiContainer.getProxyV2APIForTenant("central").proxySaveConfig(proxyId, proxyConfig.getJsonConfig());
            this.successful = true;
            logger.info("Configuration sent to the server successfully.");
        }
        catch (NotFoundException ex) {
            logger.debug("'proxySaveConfig' api end point not found", (Throwable)ex);
            this.successful = true;
        }
        catch (Throwable e) {
            logger.warn("Can't send the Proxy configuration to the server, retrying in 60 seconds. " + e.getMessage());
            logger.log(Level.DEBUG, "Exception: ", e);
        }
        if (this.successful) {
            this.executor.shutdown();
        }
    };

    public ProxySendConfigScheduler(APIContainer apiContainer, UUID proxyId, ProxyConfig proxyConfig) {
    }

    public void start() {
        this.executor.scheduleAtFixedRate(this.task, 0L, 60L, TimeUnit.SECONDS);
    }
}

