/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.channel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.wavefront.agent.channel.ChannelUtils;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetAddress;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ChannelHandler.Sharable
public class SharedGraphiteHostAnnotator {
    private static final List<String> DEFAULT_SOURCE_TAGS = ImmutableList.of((Object)"source", (Object)"host", (Object)"\"source\"", (Object)"\"host\"");
    private final Function<InetAddress, String> hostnameResolver;
    private final List<String> sourceTags;
    private final List<String> sourceTagsJson;

    public SharedGraphiteHostAnnotator(@Nullable List<String> customSourceTags, @Nonnull Function<InetAddress, String> hostnameResolver) {
        if (customSourceTags == null) {
            customSourceTags = ImmutableList.of();
        }
        this.hostnameResolver = hostnameResolver;
        this.sourceTags = Streams.concat((Stream[])new Stream[]{DEFAULT_SOURCE_TAGS.stream(), customSourceTags.stream()}).map(customTag -> customTag + "=").collect(Collectors.toList());
        this.sourceTagsJson = Streams.concat((Stream[])new Stream[]{DEFAULT_SOURCE_TAGS.subList(2, 4).stream(), customSourceTags.stream().map(customTag -> "\"" + customTag + "\"")}).collect(Collectors.toList());
    }

    public String apply(ChannelHandlerContext ctx, String msg) {
        return this.apply(ctx, msg, false);
    }

    public String apply(ChannelHandlerContext ctx, String msg, boolean addAsJsonProperty) {
        List<String> defaultSourceTags = addAsJsonProperty ? this.sourceTagsJson : this.sourceTags;
        for (int i = 0; i < defaultSourceTags.size(); ++i) {
            String tag = defaultSourceTags.get(i);
            int strIndex = msg.indexOf(tag);
            if (strIndex <= -1 || msg.length() - strIndex - tag.length() <= 0 || msg.charAt(strIndex + tag.length()) <= ' ') continue;
            return msg;
        }
        String sourceValue = "\"" + this.hostnameResolver.apply(ChannelUtils.getRemoteAddress(ctx)) + "\"";
        if (addAsJsonProperty) {
            return msg.replaceFirst("\\{", "{\"source\":" + sourceValue + ", ");
        }
        return msg + " source=" + sourceValue;
    }
}

