/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.wavefront.agent.data.DataSubmissionException;
import com.wavefront.agent.data.DataSubmissionTask;
import com.wavefront.agent.data.EntityProperties;
import com.wavefront.agent.data.QueueingReason;
import com.wavefront.agent.data.TaskQueueLevel;
import com.wavefront.agent.data.TaskResult;
import com.wavefront.agent.queueing.TaskQueue;
import com.wavefront.common.TaggedMetricName;
import com.wavefront.common.logger.MessageDedupingLogger;
import com.wavefront.data.ReportableEntityType;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
abstract class AbstractDataSubmissionTask<T extends DataSubmissionTask<T>>
implements DataSubmissionTask<T> {
    private static final int MAX_RETRIES = 15;
    private static final Logger log = new MessageDedupingLogger(Logger.getLogger(AbstractDataSubmissionTask.class.getCanonicalName()), 1000L, 1.0);
    @JsonProperty
    protected long enqueuedTimeMillis = Long.MAX_VALUE;
    @JsonProperty
    protected int attempts = 0;
    @JsonProperty
    protected int serverErrors = 0;
    @JsonProperty
    protected String handle;
    @JsonProperty
    protected ReportableEntityType entityType;
    @JsonProperty
    protected Boolean limitRetries = null;
    protected transient Histogram timeSpentInQueue;
    protected transient Supplier<Long> timeProvider;
    protected transient EntityProperties properties;
    protected transient TaskQueue<T> backlog;

    AbstractDataSubmissionTask() {
    }

    AbstractDataSubmissionTask(EntityProperties properties, TaskQueue<T> backlog, String handle, ReportableEntityType entityType, @Nullable Supplier<Long> timeProvider) {
        this.properties = properties;
        this.backlog = backlog;
        this.handle = handle;
        this.entityType = entityType;
        this.timeProvider = (Supplier)MoreObjects.firstNonNull(timeProvider, System::currentTimeMillis);
    }

    @Override
    public long getEnqueuedMillis() {
        return this.enqueuedTimeMillis;
    }

    @Override
    public ReportableEntityType getEntityType() {
        return this.entityType;
    }

    abstract Response doExecute() throws DataSubmissionException;

    /*
     * Exception decompiling
     */
    @Override
    public TaskResult execute() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 20[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void enqueue(@Nullable QueueingReason reason) {
        this.enqueuedTimeMillis = this.timeProvider.get();
        try {
            this.backlog.add(this);
            if (reason != null) {
                Metrics.newCounter((MetricName)new TaggedMetricName(this.entityType + "." + this.handle, "queued", new String[]{"reason", reason.toString()})).inc((long)this.weight());
            }
        }
        catch (IOException e) {
            Metrics.newCounter((MetricName)new TaggedMetricName("buffer", "failures", new String[]{"port", this.handle})).inc();
            log.severe("[" + this.handle + "] CRITICAL (Losing data): WF-1: Error adding task to the queue: " + e.getMessage());
        }
    }

    private TaskResult checkStatusAndQueue(QueueingReason reason, boolean requeue) {
        if (reason == QueueingReason.AUTH) {
            return TaskResult.REMOVED;
        }
        if (this.enqueuedTimeMillis == Long.MAX_VALUE) {
            if (this.properties.getTaskQueueLevel().isLessThan(TaskQueueLevel.ANY_ERROR)) {
                return TaskResult.RETRY_LATER;
            }
            this.enqueue(reason);
            return TaskResult.PERSISTED;
        }
        if (requeue) {
            this.enqueue(null);
            return TaskResult.PERSISTED_RETRY;
        }
        return TaskResult.RETRY_LATER;
    }

    protected TaskResult handleStatus429() {
        if (this.enqueuedTimeMillis == Long.MAX_VALUE) {
            if (this.properties.getTaskQueueLevel().isLessThan(TaskQueueLevel.PUSHBACK)) {
                return TaskResult.RETRY_LATER;
            }
            this.enqueue(QueueingReason.PUSHBACK);
            return TaskResult.PERSISTED;
        }
        if (this.properties.isSplitPushWhenRateLimited()) {
            List<DataSubmissionTask> splitTasks = this.splitTask(this.properties.getMinBatchSplitSize(), this.properties.getDataPerBatch());
            if (splitTasks.size() == 1) {
                return TaskResult.RETRY_LATER;
            }
            splitTasks.forEach(x -> x.enqueue(null));
            return TaskResult.PERSISTED;
        }
        return TaskResult.RETRY_LATER;
    }

    private /* synthetic */ void lambda$execute$0(DataSubmissionTask x) {
        x.enqueue(this.enqueuedTimeMillis == Long.MAX_VALUE ? QueueingReason.SPLIT : null);
    }
}

