/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.data;

import com.wavefront.agent.ProxyConfig;
import com.wavefront.agent.config.ReportableConfig;
import com.wavefront.agent.data.GlobalProperties;
import com.wavefront.api.agent.SpanSamplingPolicy;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;

public final class GlobalPropertiesImpl
implements GlobalProperties {
    private final ProxyConfig wrapped;
    private Double retryBackoffBaseSeconds = null;
    private short histogramStorageAccuracy = (short)32;
    private Double traceSamplingRate = null;
    private Integer dropSpansDelayedMinutes = null;
    private List<SpanSamplingPolicy> activeSpanSamplingPolicies;

    public GlobalPropertiesImpl(ProxyConfig wrapped) {
        this.wrapped = wrapped;
        ReportableConfig.reportSettingAsGauge(this::getRetryBackoffBaseSeconds, "dynamic.retryBackoffBaseSeconds");
    }

    @Override
    public double getRetryBackoffBaseSeconds() {
        return (Double)ObjectUtils.firstNonNull((Object[])new Double[]{this.retryBackoffBaseSeconds, this.wrapped.getRetryBackoffBaseSeconds()});
    }

    @Override
    public void setRetryBackoffBaseSeconds(@Nullable Double retryBackoffBaseSeconds) {
        this.retryBackoffBaseSeconds = retryBackoffBaseSeconds;
    }

    @Override
    public short getHistogramStorageAccuracy() {
        return this.histogramStorageAccuracy;
    }

    @Override
    public void setHistogramStorageAccuracy(short histogramStorageAccuracy) {
        this.histogramStorageAccuracy = histogramStorageAccuracy;
    }

    @Override
    public double getTraceSamplingRate() {
        if (this.traceSamplingRate != null) {
            return Math.min(this.traceSamplingRate, this.wrapped.getTraceSamplingRate());
        }
        return this.wrapped.getTraceSamplingRate();
    }

    @Override
    public void setTraceSamplingRate(@Nullable Double traceSamplingRate) {
        this.traceSamplingRate = traceSamplingRate;
    }

    @Override
    public Integer getDropSpansDelayedMinutes() {
        return this.dropSpansDelayedMinutes;
    }

    @Override
    public void setDropSpansDelayedMinutes(@Nullable Integer dropSpansDelayedMinutes) {
        this.dropSpansDelayedMinutes = dropSpansDelayedMinutes;
    }

    @Override
    public List<SpanSamplingPolicy> getActiveSpanSamplingPolicies() {
        return this.activeSpanSamplingPolicies;
    }

    @Override
    public void setActiveSpanSamplingPolicies(@Nullable List<SpanSamplingPolicy> activeSpanSamplingPolicies) {
        this.activeSpanSamplingPolicies = activeSpanSamplingPolicies;
    }
}

