/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.wavefront.agent.data.AbstractDataSubmissionTask;
import com.wavefront.agent.data.EntityProperties;
import com.wavefront.agent.handlers.LineDelimitedUtils;
import com.wavefront.agent.queueing.TaskQueue;
import com.wavefront.api.ProxyV2API;
import com.wavefront.data.ReportableEntityType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="__CLASS")
public class LineDelimitedDataSubmissionTask
extends AbstractDataSubmissionTask<LineDelimitedDataSubmissionTask> {
    private transient ProxyV2API api;
    private transient UUID proxyId;
    @JsonProperty
    private String format;
    @JsonProperty
    @VisibleForTesting
    protected List<String> payload;

    LineDelimitedDataSubmissionTask() {
    }

    public LineDelimitedDataSubmissionTask(ProxyV2API api, UUID proxyId, EntityProperties properties, TaskQueue<LineDelimitedDataSubmissionTask> backlog, String format, ReportableEntityType entityType, String handle, @Nonnull List<String> payload, @Nullable Supplier<Long> timeProvider) {
        super(properties, backlog, handle, entityType, timeProvider);
        this.api = api;
        this.proxyId = proxyId;
        this.format = format;
        this.payload = new ArrayList<String>(payload);
    }

    @Override
    Response doExecute() {
        return this.api.proxyReport(this.proxyId, this.format, LineDelimitedUtils.joinPushData(this.payload));
    }

    @Override
    public int weight() {
        return this.payload.size();
    }

    @Override
    public List<LineDelimitedDataSubmissionTask> splitTask(int minSplitSize, int maxSplitSize) {
        if (this.payload.size() > Math.max(1, minSplitSize)) {
            ArrayList<LineDelimitedDataSubmissionTask> result = new ArrayList<LineDelimitedDataSubmissionTask>();
            int stride = Math.min(maxSplitSize, (int)Math.ceil((double)this.payload.size() / 2.0));
            int endingIndex = 0;
            int startingIndex = 0;
            while (endingIndex < this.payload.size() - 1) {
                endingIndex = Math.min(this.payload.size(), startingIndex + stride) - 1;
                result.add(new LineDelimitedDataSubmissionTask(this.api, this.proxyId, this.properties, this.backlog, this.format, this.getEntityType(), this.handle, this.payload.subList(startingIndex, endingIndex + 1), this.timeProvider));
                startingIndex += stride;
            }
            return result;
        }
        return ImmutableList.of((Object)this);
    }

    public List<String> payload() {
        return this.payload;
    }

    public void injectMembers(ProxyV2API api, UUID proxyId, EntityProperties properties, TaskQueue<LineDelimitedDataSubmissionTask> backlog) {
        this.api = api;
        this.proxyId = proxyId;
        this.properties = properties;
        this.backlog = backlog;
        this.timeProvider = System::currentTimeMillis;
    }
}

