/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.wavefront.agent.data.AbstractDataSubmissionTask;
import com.wavefront.agent.data.EntityProperties;
import com.wavefront.agent.data.TaskResult;
import com.wavefront.agent.queueing.TaskQueue;
import com.wavefront.api.LogAPI;
import com.wavefront.data.ReportableEntityType;
import com.wavefront.dto.Log;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="__CLASS")
public class LogDataSubmissionTask
extends AbstractDataSubmissionTask<LogDataSubmissionTask> {
    private static final Logger LOGGER = Logger.getLogger("LogDataSubmission");
    public static final String AGENT_PREFIX = "WF-PROXY-AGENT-";
    private transient LogAPI api;
    private transient UUID proxyId;
    @JsonProperty
    private List<Log> logs;
    @JsonProperty
    private int weight;

    LogDataSubmissionTask() {
    }

    public LogDataSubmissionTask(LogAPI api, UUID proxyId, EntityProperties properties, TaskQueue<LogDataSubmissionTask> backlog, String handle, @Nonnull List<Log> logs, @Nullable Supplier<Long> timeProvider) {
        super(properties, backlog, handle, ReportableEntityType.LOGS, timeProvider);
        this.api = api;
        this.proxyId = proxyId;
        this.logs = new ArrayList<Log>(logs);
        for (Log l : logs) {
            this.weight += l.getDataSize();
        }
    }

    @Override
    Response doExecute() {
        try {
            LOGGER.finest(() -> "Logs batch sent to vRLIC: " + new Gson().toJson(this.logs));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error occurred while logging the batch sent to vRLIC: " + e.getMessage());
        }
        return this.api.proxyLogs(AGENT_PREFIX + this.proxyId.toString(), this.logs);
    }

    @Override
    protected TaskResult handleStatus429() {
        Metrics.newCounter((MetricName)new MetricName(this.entityType + "." + this.handle, "", "failed.ingestion_limit_reached")).inc((long)this.weight());
        return TaskResult.REMOVED;
    }

    @Override
    public int weight() {
        return this.weight;
    }

    @Override
    public List<LogDataSubmissionTask> splitTask(int minSplitSize, int maxSplitSize) {
        if (this.logs.size() > Math.max(1, minSplitSize)) {
            ArrayList<LogDataSubmissionTask> result = new ArrayList<LogDataSubmissionTask>();
            int stride = Math.min(maxSplitSize, (int)Math.ceil((double)this.logs.size() / 2.0));
            int endingIndex = 0;
            int startingIndex = 0;
            while (endingIndex < this.logs.size() - 1) {
                endingIndex = Math.min(this.logs.size(), startingIndex + stride) - 1;
                result.add(new LogDataSubmissionTask(this.api, this.proxyId, this.properties, this.backlog, this.handle, this.logs.subList(startingIndex, endingIndex + 1), this.timeProvider));
                startingIndex += stride;
            }
            return result;
        }
        return ImmutableList.of((Object)this);
    }

    public void injectMembers(LogAPI api, UUID proxyId, EntityProperties properties, TaskQueue<LogDataSubmissionTask> backlog) {
        this.api = api;
        this.proxyId = proxyId;
        this.properties = properties;
        this.backlog = backlog;
        this.timeProvider = System::currentTimeMillis;
    }
}

