/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.handlers;

import com.wavefront.agent.handlers.AbstractReportableEntityHandler;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.SenderTask;
import com.wavefront.api.agent.ValidationConfiguration;
import com.wavefront.common.Clock;
import com.wavefront.common.Utils;
import com.wavefront.data.DeltaCounterValueException;
import com.wavefront.data.Validation;
import com.wavefront.ingester.ReportPointSerializer;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.Histogram;
import wavefront.report.ReportPoint;

class ReportPointHandlerImpl
extends AbstractReportableEntityHandler<ReportPoint, String> {
    final Logger validItemsLogger;
    final ValidationConfiguration validationConfig;
    final Function<Histogram, Histogram> recompressor;
    final com.yammer.metrics.core.Histogram receivedPointLag;
    final com.yammer.metrics.core.Histogram receivedTagCount;
    final Supplier<Counter> discardedCounterSupplier;

    ReportPointHandlerImpl(HandlerKey handlerKey, int blockedItemsPerBatch, @Nullable Map<String, Collection<SenderTask<String>>> senderTaskMap, @Nonnull ValidationConfiguration validationConfig, boolean setupMetrics, @Nullable BiConsumer<String, Long> receivedRateSink, @Nullable Logger blockedItemLogger, @Nullable Logger validItemsLogger, @Nullable Function<Histogram, Histogram> recompressor) {
        super(handlerKey, blockedItemsPerBatch, new ReportPointSerializer(), senderTaskMap, setupMetrics, receivedRateSink, blockedItemLogger);
        super.initializeCounters();
        this.validationConfig = validationConfig;
        this.validItemsLogger = validItemsLogger;
        this.recompressor = recompressor;
        MetricsRegistry registry = setupMetrics ? Metrics.defaultRegistry() : LOCAL_REGISTRY;
        this.receivedPointLag = registry.newHistogram(new MetricName(handlerKey.toString() + ".received", "", "lag"), false);
        this.receivedTagCount = registry.newHistogram(new MetricName(handlerKey.toString() + ".received", "", "tagCount"), false);
        this.discardedCounterSupplier = Utils.lazySupplier(() -> Metrics.newCounter((MetricName)new MetricName(handlerKey.toString(), "", "discarded")));
    }

    @Override
    void reportInternal(ReportPoint point) {
        this.receivedTagCount.update(point.getAnnotations().size());
        try {
            Validation.validatePoint((ReportPoint)point, (ValidationConfiguration)this.validationConfig);
        }
        catch (DeltaCounterValueException e) {
            this.discardedCounterSupplier.get().inc();
            return;
        }
        this.receivedPointLag.update(Clock.now() - point.getTimestamp());
        if (point.getValue() instanceof Histogram && this.recompressor != null) {
            Histogram histogram = (Histogram)point.getValue();
            point.setValue(this.recompressor.apply(histogram));
        }
        String strPoint = (String)this.serializer.apply(point);
        this.getTask("central").add(strPoint);
        this.getReceivedCounter().inc();
        if (this.isMulticastingActive && point.getAnnotations() != null && point.getAnnotations().containsKey("multicastingTenantName")) {
            String[] multicastingTenantNames = ((String)point.getAnnotations().get("multicastingTenantName")).trim().split(",");
            point.getAnnotations().remove("multicastingTenantName");
            for (String multicastingTenantName : multicastingTenantNames) {
                if (this.getTask(multicastingTenantName) == null) continue;
                this.getTask(multicastingTenantName).add((String)this.serializer.apply(point));
            }
        }
        if (this.validItemsLogger != null) {
            this.validItemsLogger.info(strPoint);
        }
    }
}

