/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.histogram;

import com.google.common.collect.ImmutableMap;
import com.wavefront.agent.histogram.Granularity;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HistogramKey {
    private byte granularityOrdinal;
    private int binId;
    private String metric;
    @Nullable
    private String source;
    @Nullable
    private String[] tags;

    HistogramKey(byte granularityOrdinal, int binId, @Nonnull String metric, @Nullable String source, @Nullable String[] tags) {
        this.granularityOrdinal = granularityOrdinal;
        this.binId = binId;
        this.metric = metric;
        this.source = source;
        this.tags = tags == null || tags.length == 0 ? null : tags;
    }

    HistogramKey() {
    }

    public byte getGranularityOrdinal() {
        return this.granularityOrdinal;
    }

    public int getBinId() {
        return this.binId;
    }

    public String getMetric() {
        return this.metric;
    }

    @Nullable
    public String getSource() {
        return this.source;
    }

    @Nullable
    public String[] getTags() {
        return this.tags;
    }

    public String toString() {
        return "HistogramKey{granularityOrdinal=" + this.granularityOrdinal + ", binId=" + this.binId + ", metric='" + this.metric + '\'' + ", source='" + this.source + '\'' + ", tags=" + Arrays.toString(this.tags) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistogramKey histogramKey = (HistogramKey)o;
        if (this.granularityOrdinal != histogramKey.granularityOrdinal) {
            return false;
        }
        if (this.binId != histogramKey.binId) {
            return false;
        }
        if (!this.metric.equals(histogramKey.metric)) {
            return false;
        }
        if (!Objects.equals(this.source, histogramKey.source)) {
            return false;
        }
        return Arrays.equals(this.tags, histogramKey.tags);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.granularityOrdinal;
        result = 31 * result + this.binId;
        result = 31 * result + this.metric.hashCode();
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.tags);
        return result;
    }

    public Map<String, String> getTagsAsMap() {
        if (this.tags == null || this.tags.length == 0) {
            return ImmutableMap.of();
        }
        HashMap<String, String> annotations = new HashMap<String, String>(this.tags.length / 2);
        for (int i = 0; i < this.tags.length - 1; i += 2) {
            annotations.put(this.tags[i], this.tags[i + 1]);
        }
        return annotations;
    }

    public long getBinTimeMillis() {
        return this.getBinDurationInMillis() * (long)this.binId;
    }

    public long getBinDurationInMillis() {
        return Granularity.values()[this.granularityOrdinal].getInMillis();
    }

    void setGranularityOrdinal(byte granularityOrdinal) {
        this.granularityOrdinal = granularityOrdinal;
    }

    void setBinId(int binId) {
        this.binId = binId;
    }

    void setMetric(String metric) {
        this.metric = metric;
    }

    void setSource(@Nullable String source) {
        this.source = source;
    }

    void setTags(@Nullable String[] tags) {
        this.tags = tags;
    }
}

