/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.histogram;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.wavefront.agent.histogram.MapSettings;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.hash.serialization.SizedWriter;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.VanillaChronicleMap;

public class MapLoader<K, V, KM extends BytesReader<K> & BytesWriter<K>, VM extends SizedReader<V> & SizedWriter<V>> {
    private static final Logger logger = Logger.getLogger(MapLoader.class.getCanonicalName());
    private static final double MAX_BLOAT_FACTOR = 1000.0;
    private static final ObjectMapper JSON_PARSER = new ObjectMapper();
    private final Class<K> keyClass;
    private final Class<V> valueClass;
    private final long entries;
    private final double avgKeySize;
    private final double avgValueSize;
    private final KM keyMarshaller;
    private final VM valueMarshaller;
    private final boolean doPersist;
    private final LoadingCache<File, ChronicleMap<K, V>> maps = CacheBuilder.newBuilder().build(new CacheLoader<File, ChronicleMap<K, V>>(){

        private ChronicleMap<K, V> newPersistedMap(File file) throws IOException {
            return ChronicleMap.of((Class)MapLoader.this.keyClass, (Class)MapLoader.this.valueClass).keyMarshaller(MapLoader.this.keyMarshaller).valueMarshaller(MapLoader.this.valueMarshaller).entries(MapLoader.this.entries).averageKeySize(MapLoader.this.avgKeySize).averageValueSize(MapLoader.this.avgValueSize).maxBloatFactor(1000.0).createPersistedTo(file);
        }

        private ChronicleMap<K, V> newInMemoryMap() {
            return ChronicleMap.of((Class)MapLoader.this.keyClass, (Class)MapLoader.this.valueClass).keyMarshaller(MapLoader.this.keyMarshaller).valueMarshaller(MapLoader.this.valueMarshaller).entries(MapLoader.this.entries).averageKeySize(MapLoader.this.avgKeySize).averageValueSize(MapLoader.this.avgValueSize).maxBloatFactor(1000.0).create();
        }

        private MapSettings loadSettings(File file) throws IOException {
            return (MapSettings)JSON_PARSER.readValue((Reader)new FileReader(file), MapSettings.class);
        }

        private void saveSettings(MapSettings settings, File file) throws IOException {
            FileWriter writer = new FileWriter(file);
            JSON_PARSER.writeValue((Writer)writer, (Object)settings);
            ((Writer)writer).close();
        }

        public ChronicleMap<K, V> load(@Nonnull File file) throws Exception {
            if (!MapLoader.this.doPersist) {
                logger.log(Level.WARNING, "Accumulator persistence is disabled, unflushed histograms will be lost on proxy shutdown.");
                return this.newInMemoryMap();
            }
            MapSettings newSettings = new MapSettings(MapLoader.this.entries, MapLoader.this.avgKeySize, MapLoader.this.avgValueSize);
            File settingsFile = new File(file.getAbsolutePath().concat(".settings"));
            try {
                if (file.exists()) {
                    MapSettings settings;
                    if (settingsFile.exists() && !(settings = this.loadSettings(settingsFile)).equals(newSettings)) {
                        logger.info(file.getName() + " settings changed, reconfiguring (this may take a few moments)...");
                        File originalFile = new File(file.getAbsolutePath());
                        File oldFile = new File(file.getAbsolutePath().concat(".temp"));
                        if (oldFile.exists()) {
                            oldFile.delete();
                        }
                        file.renameTo(oldFile);
                        ChronicleMap toMigrate = ChronicleMap.of((Class)MapLoader.this.keyClass, (Class)MapLoader.this.valueClass).entries(settings.getEntries()).averageKeySize(settings.getAvgKeySize()).averageValueSize(settings.getAvgValueSize()).recoverPersistedTo(oldFile, false);
                        ChronicleMap result = this.newPersistedMap(originalFile);
                        if (toMigrate.size() > 0) {
                            logger.info(originalFile.getName() + " starting data migration (" + toMigrate.size() + " records)");
                            for (Object key : toMigrate.keySet()) {
                                result.put(key, toMigrate.get(key));
                            }
                            toMigrate.close();
                            logger.info(originalFile.getName() + " data migration finished");
                        }
                        this.saveSettings(newSettings, settingsFile);
                        oldFile.delete();
                        logger.info(originalFile.getName() + " reconfiguration finished");
                        return result;
                    }
                    logger.fine("Restoring accumulator state from " + file.getAbsolutePath());
                    ChronicleMap result = ChronicleMap.of((Class)MapLoader.this.keyClass, (Class)MapLoader.this.valueClass).entries(MapLoader.this.entries).averageKeySize(MapLoader.this.avgKeySize).averageValueSize(MapLoader.this.avgValueSize).recoverPersistedTo(file, false);
                    if (result.isEmpty()) {
                        result.close();
                        file.delete();
                        logger.fine("Empty accumulator - reinitializing: " + file.getName());
                        result = this.newPersistedMap(file);
                    } else if (result instanceof VanillaChronicleMap) {
                        logger.fine("Accumulator map restored from " + file.getAbsolutePath());
                        VanillaChronicleMap vcm = (VanillaChronicleMap)result;
                        if (!vcm.keyClass().equals(MapLoader.this.keyClass) || !vcm.valueClass().equals(MapLoader.this.valueClass)) {
                            throw new IllegalStateException("Persisted map params are not matching expected map params  key exp: " + MapLoader.this.keyClass.getSimpleName() + " act: " + vcm.keyClass().getSimpleName() + " val exp: " + MapLoader.this.valueClass.getSimpleName() + " act: " + vcm.valueClass().getSimpleName());
                        }
                    }
                    this.saveSettings(newSettings, settingsFile);
                    return result;
                }
                logger.fine("Accumulator map initialized as " + file.getName());
                this.saveSettings(newSettings, settingsFile);
                return this.newPersistedMap(file);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to load/create map from '" + file.getAbsolutePath() + "'. Please move or delete the file and restart the proxy! Reason: ", e);
                throw new RuntimeException(e);
            }
        }
    });

    public MapLoader(Class<K> keyClass, Class<V> valueClass, long entries, double avgKeySize, double avgValueSize, KM keyMarshaller, VM valueMarshaller, boolean doPersist) {
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.entries = entries;
        this.avgKeySize = avgKeySize;
        this.avgValueSize = avgValueSize;
        this.keyMarshaller = keyMarshaller;
        this.valueMarshaller = valueMarshaller;
        this.doPersist = doPersist;
    }

    public ChronicleMap<K, V> get(File f) throws Exception {
        Preconditions.checkNotNull((Object)f);
        return (ChronicleMap)this.maps.get((Object)f);
    }

    public String toString() {
        return "MapLoader{keyClass=" + this.keyClass + ", valueClass=" + this.valueClass + ", entries=" + this.entries + ", avgKeySize=" + this.avgKeySize + ", avgValueSize=" + this.avgValueSize + ", keyMarshaller=" + this.keyMarshaller + ", valueMarshaller=" + this.valueMarshaller + ", doPersist=" + this.doPersist + ", maps=" + this.maps + '}';
    }
}

