/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners.otlp;

import com.google.common.collect.Sets;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.rpc.Code;
import com.google.rpc.Status;
import com.wavefront.agent.auth.TokenAuthenticator;
import com.wavefront.agent.channel.ChannelUtils;
import com.wavefront.agent.channel.HealthCheckManager;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.handlers.ReportableEntityHandlerFactory;
import com.wavefront.agent.listeners.AbstractHttpOnlyHandler;
import com.wavefront.agent.listeners.FeatureCheckUtils;
import com.wavefront.agent.listeners.otlp.OtlpMetricsUtils;
import com.wavefront.agent.listeners.otlp.OtlpTraceUtils;
import com.wavefront.agent.preprocessor.ReportableEntityPreprocessor;
import com.wavefront.agent.sampler.SpanSampler;
import com.wavefront.common.NamedThreadFactory;
import com.wavefront.data.ReportableEntityType;
import com.wavefront.internal.SpanDerivedMetricsUtils;
import com.wavefront.internal.reporter.WavefrontInternalReporter;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.annotation.NonNull;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.collector.trace.v1.ExportTraceServiceRequest;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import wavefront.report.ReportPoint;
import wavefront.report.Span;
import wavefront.report.SpanLogs;

public class OtlpHttpHandler
extends AbstractHttpOnlyHandler
implements Closeable,
Runnable {
    private static final Logger logger = Logger.getLogger(OtlpHttpHandler.class.getCanonicalName());
    private final String defaultSource;
    private final Set<Pair<Map<String, String>, String>> discoveredHeartbeatMetrics;
    @Nullable
    private final WavefrontInternalReporter internalReporter;
    @Nullable
    private final Supplier<ReportableEntityPreprocessor> preprocessorSupplier;
    private final Pair<SpanSampler, Counter> spanSamplerAndCounter;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ReportableEntityHandler<Span, String> spanHandler;
    @Nullable
    private final WavefrontSender sender;
    private final ReportableEntityHandler<SpanLogs, String> spanLogsHandler;
    private final Set<String> traceDerivedCustomTagKeys;
    private final ReportableEntityHandler<ReportPoint, String> metricsHandler;
    private final ReportableEntityHandler<ReportPoint, String> histogramHandler;
    private final Counter receivedSpans;
    private final Pair<Supplier<Boolean>, Counter> spansDisabled;
    private final Pair<Supplier<Boolean>, Counter> spanLogsDisabled;
    private final boolean includeResourceAttrsForMetrics;
    private final boolean includeOtlpAppTagsOnMetrics;

    public OtlpHttpHandler(ReportableEntityHandlerFactory handlerFactory, @Nullable TokenAuthenticator tokenAuthenticator, @Nullable HealthCheckManager healthCheckManager, @NonNull String handle, @Nullable WavefrontSender wfSender, @Nullable Supplier<ReportableEntityPreprocessor> preprocessorSupplier, SpanSampler sampler, Supplier<Boolean> spansFeatureDisabled, Supplier<Boolean> spanLogsFeatureDisabled, String defaultSource, Set<String> traceDerivedCustomTagKeys, boolean includeResourceAttrsForMetrics, boolean includeOtlpAppTagsOnMetrics) {
        super(tokenAuthenticator, healthCheckManager, handle);
        this.includeResourceAttrsForMetrics = includeResourceAttrsForMetrics;
        this.includeOtlpAppTagsOnMetrics = includeOtlpAppTagsOnMetrics;
        this.spanHandler = handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.TRACE, handle));
        this.spanLogsHandler = handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.TRACE_SPAN_LOGS, handle));
        this.metricsHandler = handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.POINT, handle));
        this.histogramHandler = handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.HISTOGRAM, handle));
        this.sender = wfSender;
        this.preprocessorSupplier = preprocessorSupplier;
        this.defaultSource = defaultSource;
        this.traceDerivedCustomTagKeys = traceDerivedCustomTagKeys;
        this.discoveredHeartbeatMetrics = Sets.newConcurrentHashSet();
        this.receivedSpans = Metrics.newCounter((MetricName)new MetricName("spans." + handle, "", "received.total"));
        this.spanSamplerAndCounter = Pair.of((Object)sampler, (Object)Metrics.newCounter((MetricName)new MetricName("spans." + handle, "", "sampler.discarded")));
        this.spansDisabled = Pair.of(spansFeatureDisabled, (Object)Metrics.newCounter((MetricName)new MetricName("spans." + handle, "", "discarded")));
        this.spanLogsDisabled = Pair.of(spanLogsFeatureDisabled, (Object)Metrics.newCounter((MetricName)new MetricName("spanLogs." + handle, "", "discarded")));
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("otlp-http-heart-beater"));
        this.scheduledExecutorService.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.MINUTES);
        this.internalReporter = OtlpTraceUtils.createAndStartInternalReporter(this.sender);
    }

    @Override
    protected void handleHttpMessage(ChannelHandlerContext ctx, FullHttpRequest request) throws URISyntaxException {
        URI uri = new URI(request.uri());
        String path = uri.getPath().endsWith("/") ? uri.getPath() : uri.getPath() + "/";
        try {
            switch (path) {
                case "/v1/traces/": {
                    ExportTraceServiceRequest traceRequest = ExportTraceServiceRequest.parseFrom((ByteBuffer)request.content().nioBuffer());
                    long spanCount = OtlpTraceUtils.getSpansCount(traceRequest);
                    this.receivedSpans.inc(spanCount);
                    if (FeatureCheckUtils.isFeatureDisabled((Supplier<Boolean>)((Supplier)this.spansDisabled._1), "Ingested span discarded because distributed tracing feature has not been enabled for your account.", (Counter)this.spansDisabled._2, spanCount)) {
                        HttpResponse response = this.makeErrorResponse(Code.FAILED_PRECONDITION, "Ingested span discarded because distributed tracing feature has not been enabled for your account.");
                        ChannelUtils.writeHttpResponse(ctx, response, (HttpMessage)request);
                        return;
                    }
                    OtlpTraceUtils.exportToWavefront(traceRequest, this.spanHandler, this.spanLogsHandler, this.preprocessorSupplier, this.spanLogsDisabled, this.spanSamplerAndCounter, this.defaultSource, this.discoveredHeartbeatMetrics, this.internalReporter, this.traceDerivedCustomTagKeys);
                    break;
                }
                case "/v1/metrics/": {
                    ExportMetricsServiceRequest metricRequest = ExportMetricsServiceRequest.parseFrom((ByteBuffer)request.content().nioBuffer());
                    OtlpMetricsUtils.exportToWavefront(metricRequest, this.metricsHandler, this.histogramHandler, this.preprocessorSupplier, this.defaultSource, this.includeResourceAttrsForMetrics, this.includeOtlpAppTagsOnMetrics);
                    break;
                }
                default: {
                    ChannelUtils.writeHttpResponse(ctx, HttpResponseStatus.BAD_REQUEST, (Object)("unknown endpoint " + path), (HttpMessage)request);
                    return;
                }
            }
            ChannelUtils.writeHttpResponse(ctx, HttpResponseStatus.OK, (Object)"", (HttpMessage)request);
        }
        catch (InvalidProtocolBufferException e) {
            this.logWarning("WF-300: Failed to handle incoming OTLP request", e, ctx);
            HttpResponse response = this.makeErrorResponse(Code.INVALID_ARGUMENT, e.getMessage());
            ChannelUtils.writeHttpResponse(ctx, response, (HttpMessage)request);
        }
    }

    @Override
    public void run() {
        try {
            SpanDerivedMetricsUtils.reportHeartbeats((WavefrontSender)this.sender, this.discoveredHeartbeatMetrics, (String)"otlp");
        }
        catch (IOException e) {
            logger.warning("Cannot report heartbeat metric to wavefront");
        }
    }

    @Override
    public void close() throws IOException {
        this.scheduledExecutorService.shutdownNow();
    }

    private HttpResponse makeErrorResponse(Code rpcCode, String msg) {
        Status pbStatus = Status.newBuilder().setCode(rpcCode.getNumber()).setMessage(msg).build();
        ByteBuf content = Unpooled.copiedBuffer((byte[])pbStatus.toByteArray());
        HttpHeaders headers = new DefaultHttpHeaders().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/x-protobuf").set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
        HttpResponseStatus httpStatus = rpcCode == Code.NOT_FOUND ? HttpResponseStatus.NOT_FOUND : HttpResponseStatus.BAD_REQUEST;
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, httpStatus, content, headers, (HttpHeaders)new DefaultHttpHeaders());
    }
}

