/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners.tracing;

import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.handlers.ReportableEntityHandlerFactory;
import com.wavefront.agent.listeners.tracing.JaegerProtobufUtils;
import com.wavefront.agent.listeners.tracing.JaegerTChannelCollectorHandler;
import com.wavefront.agent.preprocessor.ReportableEntityPreprocessor;
import com.wavefront.agent.sampler.SpanSampler;
import com.wavefront.common.NamedThreadFactory;
import com.wavefront.data.ReportableEntityType;
import com.wavefront.internal.SpanDerivedMetricsUtils;
import com.wavefront.internal.reporter.WavefrontInternalReporter;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.WavefrontSender;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import io.grpc.stub.StreamObserver;
import io.opentelemetry.exporter.jaeger.proto.api_v2.Collector;
import io.opentelemetry.exporter.jaeger.proto.api_v2.CollectorServiceGrpc;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import wavefront.report.Span;
import wavefront.report.SpanLogs;

public class JaegerGrpcCollectorHandler
extends CollectorServiceGrpc.CollectorServiceImplBase
implements Runnable,
Closeable {
    protected static final Logger logger = Logger.getLogger(JaegerTChannelCollectorHandler.class.getCanonicalName());
    private static final String JAEGER_COMPONENT = "jaeger";
    private static final String DEFAULT_SOURCE = "jaeger";
    private final ReportableEntityHandler<Span, String> spanHandler;
    private final ReportableEntityHandler<SpanLogs, String> spanLogsHandler;
    @Nullable
    private final WavefrontSender wfSender;
    @Nullable
    private final WavefrontInternalReporter wfInternalReporter;
    private final Supplier<Boolean> traceDisabled;
    private final Supplier<Boolean> spanLogsDisabled;
    private final Supplier<ReportableEntityPreprocessor> preprocessorSupplier;
    private final SpanSampler sampler;
    private final String proxyLevelApplicationName;
    private final Set<String> traceDerivedCustomTagKeys;
    private final Counter receivedSpansTotal;
    private final Counter discardedTraces;
    private final Counter discardedBatches;
    private final Counter processedBatches;
    private final Counter failedBatches;
    private final Counter discardedSpansBySampler;
    private final Set<Pair<Map<String, String>, String>> discoveredHeartbeatMetrics;
    private final ScheduledExecutorService scheduledExecutorService;

    public JaegerGrpcCollectorHandler(String handle, ReportableEntityHandlerFactory handlerFactory, @Nullable WavefrontSender wfSender, Supplier<Boolean> traceDisabled, Supplier<Boolean> spanLogsDisabled, @Nullable Supplier<ReportableEntityPreprocessor> preprocessor, SpanSampler sampler, @Nullable String traceJaegerApplicationName, Set<String> traceDerivedCustomTagKeys) {
        this(handle, handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.TRACE, handle)), handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.TRACE_SPAN_LOGS, handle)), wfSender, traceDisabled, spanLogsDisabled, preprocessor, sampler, traceJaegerApplicationName, traceDerivedCustomTagKeys);
    }

    public JaegerGrpcCollectorHandler(String handle, ReportableEntityHandler<Span, String> spanHandler, ReportableEntityHandler<SpanLogs, String> spanLogsHandler, @Nullable WavefrontSender wfSender, Supplier<Boolean> traceDisabled, Supplier<Boolean> spanLogsDisabled, @Nullable Supplier<ReportableEntityPreprocessor> preprocessor, SpanSampler sampler, @Nullable String traceJaegerApplicationName, Set<String> traceDerivedCustomTagKeys) {
        this.spanHandler = spanHandler;
        this.spanLogsHandler = spanLogsHandler;
        this.wfSender = wfSender;
        this.traceDisabled = traceDisabled;
        this.spanLogsDisabled = spanLogsDisabled;
        this.preprocessorSupplier = preprocessor;
        this.sampler = sampler;
        this.proxyLevelApplicationName = StringUtils.isBlank((String)traceJaegerApplicationName) ? "Jaeger" : traceJaegerApplicationName.trim();
        this.traceDerivedCustomTagKeys = traceDerivedCustomTagKeys;
        this.discardedTraces = Metrics.newCounter((MetricName)new MetricName("spans." + handle, "", "discarded"));
        this.discardedBatches = Metrics.newCounter((MetricName)new MetricName("spans." + handle + ".batches", "", "discarded"));
        this.processedBatches = Metrics.newCounter((MetricName)new MetricName("spans." + handle + ".batches", "", "processed"));
        this.failedBatches = Metrics.newCounter((MetricName)new MetricName("spans." + handle + ".batches", "", "failed"));
        this.discardedSpansBySampler = Metrics.newCounter((MetricName)new MetricName("spans." + handle, "", "sampler.discarded"));
        this.receivedSpansTotal = Metrics.newCounter((MetricName)new MetricName("spans." + handle, "", "received.total"));
        this.discoveredHeartbeatMetrics = Sets.newConcurrentHashSet();
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("jaeger-heart-beater"));
        this.scheduledExecutorService.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.MINUTES);
        if (wfSender != null) {
            this.wfInternalReporter = new WavefrontInternalReporter.Builder().prefixedWith("tracing.derived").withSource("jaeger").reportMinuteDistribution().build(wfSender);
            this.wfInternalReporter.start(1L, TimeUnit.MINUTES);
        } else {
            this.wfInternalReporter = null;
        }
    }

    public void postSpans(Collector.PostSpansRequest request, StreamObserver<Collector.PostSpansResponse> responseObserver) {
        try {
            JaegerProtobufUtils.processBatch(request.getBatch(), null, "jaeger", this.proxyLevelApplicationName, this.spanHandler, this.spanLogsHandler, this.wfInternalReporter, this.traceDisabled, this.spanLogsDisabled, this.preprocessorSupplier, this.sampler, this.traceDerivedCustomTagKeys, this.discardedTraces, this.discardedBatches, this.discardedSpansBySampler, this.discoveredHeartbeatMetrics, this.receivedSpansTotal);
            this.processedBatches.inc();
        }
        catch (Exception e) {
            this.failedBatches.inc();
            logger.log(Level.WARNING, "Jaeger Protobuf batch processing failed", Throwables.getRootCause((Throwable)e));
        }
        responseObserver.onNext((Object)Collector.PostSpansResponse.newBuilder().build());
        responseObserver.onCompleted();
    }

    @Override
    public void run() {
        try {
            SpanDerivedMetricsUtils.reportHeartbeats((WavefrontSender)this.wfSender, this.discoveredHeartbeatMetrics, (String)"jaeger");
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Cannot report heartbeat metric to wavefront");
        }
    }

    @Override
    public void close() {
        this.scheduledExecutorService.shutdownNow();
    }
}

