/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners.tracing;

import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.listeners.FeatureCheckUtils;
import com.wavefront.agent.listeners.tracing.SpanUtils;
import com.wavefront.agent.preprocessor.ReportableEntityPreprocessor;
import com.wavefront.agent.sampler.SpanSampler;
import com.wavefront.internal.SpanDerivedMetricsUtils;
import com.wavefront.internal.reporter.WavefrontInternalReporter;
import com.wavefront.sdk.common.Pair;
import com.yammer.metrics.core.Counter;
import io.opentelemetry.exporter.jaeger.proto.api_v2.Model;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import wavefront.report.Annotation;
import wavefront.report.Span;
import wavefront.report.SpanLog;
import wavefront.report.SpanLogs;

public abstract class JaegerProtobufUtils {
    protected static final Logger logger = Logger.getLogger(JaegerProtobufUtils.class.getCanonicalName());
    private static final Set<String> IGNORE_TAGS = ImmutableSet.of((Object)"sampler.type", (Object)"sampler.param");
    private static final Logger JAEGER_DATA_LOGGER = Logger.getLogger("JaegerDataLogger");

    private JaegerProtobufUtils() {
    }

    public static void processBatch(Model.Batch batch, @Nullable StringBuilder output, String sourceName, String applicationName, ReportableEntityHandler<Span, String> spanHandler, ReportableEntityHandler<SpanLogs, String> spanLogsHandler, @Nullable WavefrontInternalReporter wfInternalReporter, Supplier<Boolean> traceDisabled, Supplier<Boolean> spanLogsDisabled, Supplier<ReportableEntityPreprocessor> preprocessorSupplier, SpanSampler sampler, Set<String> traceDerivedCustomTagKeys, Counter discardedTraces, Counter discardedBatches, Counter discardedSpansBySampler, Set<Pair<Map<String, String>, String>> discoveredHeartbeatMetrics, Counter receivedSpansTotal) {
        String serviceName = batch.getProcess().getServiceName();
        ArrayList<Annotation> processAnnotations = new ArrayList<Annotation>();
        boolean isSourceProcessTagPresent = false;
        String cluster = "none";
        String shard = "none";
        if (batch.getProcess().getTagsList() != null) {
            for (Model.KeyValue tag : batch.getProcess().getTagsList()) {
                if (tag.getKey().equals("application") && tag.getVType() == Model.ValueType.STRING) {
                    applicationName = tag.getVStr();
                    continue;
                }
                if (tag.getKey().equals("cluster") && tag.getVType() == Model.ValueType.STRING) {
                    cluster = tag.getVStr();
                    continue;
                }
                if (tag.getKey().equals("shard") && tag.getVType() == Model.ValueType.STRING) {
                    shard = tag.getVStr();
                    continue;
                }
                if (tag.getKey().equals("hostname") && tag.getVType() == Model.ValueType.STRING) {
                    if (isSourceProcessTagPresent) continue;
                    sourceName = tag.getVStr();
                    continue;
                }
                if (tag.getKey().equals("source") && tag.getVType() == Model.ValueType.STRING) {
                    sourceName = tag.getVStr();
                    isSourceProcessTagPresent = true;
                    continue;
                }
                if (tag.getKey().equals("service") && tag.getVType() == Model.ValueType.STRING) continue;
                Annotation annotation = JaegerProtobufUtils.tagToAnnotation(tag);
                processAnnotations.add(annotation);
            }
        }
        if (FeatureCheckUtils.isFeatureDisabled(traceDisabled, "Ingested span discarded because distributed tracing feature has not been enabled for your account.", discardedBatches, output)) {
            discardedTraces.inc((long)batch.getSpansCount());
            receivedSpansTotal.inc((long)batch.getSpansCount());
            return;
        }
        receivedSpansTotal.inc((long)batch.getSpansCount());
        for (Model.Span span : batch.getSpansList()) {
            JaegerProtobufUtils.processSpan(span, serviceName, sourceName, applicationName, cluster, shard, processAnnotations, spanHandler, spanLogsHandler, wfInternalReporter, spanLogsDisabled, preprocessorSupplier, sampler, traceDerivedCustomTagKeys, discardedSpansBySampler, discoveredHeartbeatMetrics);
        }
    }

    private static void processSpan(Model.Span span, String serviceName, String sourceName, String applicationName, String cluster, String shard, List<Annotation> processAnnotations, ReportableEntityHandler<Span, String> spanHandler, ReportableEntityHandler<SpanLogs, String> spanLogsHandler, @Nullable WavefrontInternalReporter wfInternalReporter, Supplier<Boolean> spanLogsDisabled, Supplier<ReportableEntityPreprocessor> preprocessorSupplier, SpanSampler sampler, Set<String> traceDerivedCustomTagKeys, Counter discardedSpansBySampler, Set<Pair<Map<String, String>, String>> discoveredHeartbeatMetrics) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>(processAnnotations);
        annotations.add(new Annotation("service", serviceName));
        String componentTagValue = "none";
        boolean isError = false;
        if (span.getTagsList() != null) {
            block38: for (Model.KeyValue tag : span.getTagsList()) {
                Annotation annotation;
                if (IGNORE_TAGS.contains(tag.getKey()) || tag.getVType() == Model.ValueType.STRING && StringUtils.isBlank((String)tag.getVStr()) || (annotation = JaegerProtobufUtils.tagToAnnotation(tag)) == null) continue;
                switch (annotation.getKey()) {
                    case "application": {
                        applicationName = annotation.getValue();
                        continue block38;
                    }
                    case "cluster": {
                        cluster = annotation.getValue();
                        continue block38;
                    }
                    case "shard": {
                        shard = annotation.getValue();
                        continue block38;
                    }
                    case "source": {
                        sourceName = annotation.getValue();
                        continue block38;
                    }
                    case "service": {
                        continue block38;
                    }
                    case "component": {
                        componentTagValue = annotation.getValue();
                        break;
                    }
                    case "error": {
                        isError = annotation.getValue().equals("true");
                    }
                }
                annotations.add(annotation);
            }
        }
        annotations.add(new Annotation("application", applicationName));
        annotations.add(new Annotation("cluster", cluster));
        annotations.add(new Annotation("shard", shard));
        if (span.getReferencesList() != null) {
            for (Model.SpanRef reference : span.getReferencesList()) {
                switch (reference.getRefType()) {
                    case CHILD_OF: {
                        if (reference.getSpanId().isEmpty()) break;
                        annotations.add(new Annotation("parent", SpanUtils.toStringId(reference.getSpanId())));
                        break;
                    }
                    case FOLLOWS_FROM: {
                        if (reference.getSpanId().isEmpty()) break;
                        annotations.add(new Annotation("followsFrom", SpanUtils.toStringId(reference.getSpanId())));
                    }
                }
            }
        }
        if (!spanLogsDisabled.get().booleanValue() && span.getLogsCount() > 0) {
            annotations.add(new Annotation("_spanLogs", "true"));
        }
        Span wavefrontSpan = Span.newBuilder().setCustomer("dummy").setName(span.getOperationName()).setSource(sourceName).setSpanId(SpanUtils.toStringId(span.getSpanId())).setTraceId(SpanUtils.toStringId(span.getTraceId())).setStartMillis(Timestamps.toMillis((Timestamp)span.getStartTime())).setDuration(Durations.toMillis((Duration)span.getDuration())).setAnnotations(annotations).build();
        if (JAEGER_DATA_LOGGER.isLoggable(Level.FINEST)) {
            JAEGER_DATA_LOGGER.info("Inbound Jaeger span: " + span.toString());
            JAEGER_DATA_LOGGER.info("Converted Wavefront span: " + wavefrontSpan.toString());
        }
        if (preprocessorSupplier != null) {
            ReportableEntityPreprocessor preprocessor = preprocessorSupplier.get();
            String[] messageHolder = new String[1];
            preprocessor.forSpan().transform(wavefrontSpan);
            if (!preprocessor.forSpan().filter(wavefrontSpan, messageHolder)) {
                if (messageHolder[0] != null) {
                    spanHandler.reject(wavefrontSpan, (String)messageHolder[0]);
                } else {
                    spanHandler.block(wavefrontSpan);
                }
                return;
            }
        }
        if (sampler.sample(wavefrontSpan, discardedSpansBySampler)) {
            spanHandler.report(wavefrontSpan);
            if (span.getLogsCount() > 0 && !FeatureCheckUtils.isFeatureDisabled(spanLogsDisabled, "Ingested span log discarded because this feature has not been enabled for your account.", null)) {
                SpanLogs spanLogs = SpanLogs.newBuilder().setCustomer("default").setTraceId(wavefrontSpan.getTraceId()).setSpanId(wavefrontSpan.getSpanId()).setLogs(span.getLogsList().stream().map(x -> {
                    HashMap fields = new HashMap(x.getFieldsCount());
                    x.getFieldsList().forEach(t -> {
                        switch (t.getVType()) {
                            case STRING: {
                                fields.put(t.getKey(), t.getVStr());
                                break;
                            }
                            case BOOL: {
                                fields.put(t.getKey(), String.valueOf(t.getVBool()));
                                break;
                            }
                            case INT64: {
                                fields.put(t.getKey(), String.valueOf(t.getVInt64()));
                                break;
                            }
                            case FLOAT64: {
                                fields.put(t.getKey(), String.valueOf(t.getVFloat64()));
                                break;
                            }
                        }
                    });
                    return SpanLog.newBuilder().setTimestamp(Timestamps.toMicros((Timestamp)x.getTimestamp())).setFields(fields).build();
                }).collect(Collectors.toList())).build();
                spanLogsHandler.report(spanLogs);
            }
        }
        if (wfInternalReporter != null) {
            List processedAnnotations = wavefrontSpan.getAnnotations();
            block40: for (Annotation processedAnnotation : processedAnnotations) {
                switch (processedAnnotation.getKey()) {
                    case "application": {
                        applicationName = processedAnnotation.getValue();
                        continue block40;
                    }
                    case "service": {
                        serviceName = processedAnnotation.getValue();
                        continue block40;
                    }
                    case "cluster": {
                        cluster = processedAnnotation.getValue();
                        continue block40;
                    }
                    case "shard": {
                        shard = processedAnnotation.getValue();
                        continue block40;
                    }
                    case "component": {
                        componentTagValue = processedAnnotation.getValue();
                        continue block40;
                    }
                    case "error": {
                        isError = processedAnnotation.getValue().equals("true");
                        continue block40;
                    }
                }
            }
            List spanTags = processedAnnotations.stream().map(a -> new Pair((Object)a.getKey(), (Object)a.getValue())).collect(Collectors.toList());
            discoveredHeartbeatMetrics.add((Pair<Map<String, String>, String>)SpanDerivedMetricsUtils.reportWavefrontGeneratedData((WavefrontInternalReporter)wfInternalReporter, (String)wavefrontSpan.getName(), (String)applicationName, (String)serviceName, (String)cluster, (String)shard, (String)wavefrontSpan.getSource(), (String)componentTagValue, (boolean)isError, (long)Durations.toMicros((Duration)span.getDuration()), traceDerivedCustomTagKeys, spanTags, (boolean)true));
        }
    }

    @Nullable
    private static Annotation tagToAnnotation(Model.KeyValue tag) {
        switch (tag.getVType()) {
            case BOOL: {
                return new Annotation(tag.getKey(), String.valueOf(tag.getVBool()));
            }
            case INT64: {
                return new Annotation(tag.getKey(), String.valueOf(tag.getVInt64()));
            }
            case FLOAT64: {
                return new Annotation(tag.getKey(), String.valueOf(tag.getVFloat64()));
            }
            case STRING: {
                return new Annotation(tag.getKey(), tag.getVStr());
            }
        }
        return null;
    }
}

