/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners.tracing;

import com.google.common.collect.ImmutableSet;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.listeners.FeatureCheckUtils;
import com.wavefront.agent.listeners.tracing.SpanUtils;
import com.wavefront.agent.preprocessor.ReportableEntityPreprocessor;
import com.wavefront.agent.sampler.SpanSampler;
import com.wavefront.internal.SpanDerivedMetricsUtils;
import com.wavefront.internal.reporter.WavefrontInternalReporter;
import com.wavefront.sdk.common.Pair;
import com.yammer.metrics.core.Counter;
import io.jaegertracing.thriftjava.Batch;
import io.jaegertracing.thriftjava.Span;
import io.jaegertracing.thriftjava.SpanRef;
import io.jaegertracing.thriftjava.Tag;
import io.jaegertracing.thriftjava.TagType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import wavefront.report.Annotation;
import wavefront.report.SpanLog;
import wavefront.report.SpanLogs;

public abstract class JaegerThriftUtils {
    protected static final Logger logger = Logger.getLogger(JaegerThriftUtils.class.getCanonicalName());
    private static final Set<String> IGNORE_TAGS = ImmutableSet.of((Object)"sampler.type", (Object)"sampler.param");
    private static final Logger JAEGER_DATA_LOGGER = Logger.getLogger("JaegerDataLogger");

    private JaegerThriftUtils() {
    }

    public static void processBatch(Batch batch, @Nullable StringBuilder output, String sourceName, String applicationName, ReportableEntityHandler<wavefront.report.Span, String> spanHandler, ReportableEntityHandler<SpanLogs, String> spanLogsHandler, @Nullable WavefrontInternalReporter wfInternalReporter, Supplier<Boolean> traceDisabled, Supplier<Boolean> spanLogsDisabled, Supplier<ReportableEntityPreprocessor> preprocessorSupplier, SpanSampler sampler, Set<String> traceDerivedCustomTagKeys, Counter discardedTraces, Counter discardedBatches, Counter discardedSpansBySampler, Set<Pair<Map<String, String>, String>> discoveredHeartbeatMetrics, Counter receivedSpansTotal) {
        String serviceName = batch.getProcess().getServiceName();
        ArrayList<Annotation> processAnnotations = new ArrayList<Annotation>();
        boolean isSourceProcessTagPresent = false;
        String cluster = "none";
        String shard = "none";
        if (batch.getProcess().getTags() != null) {
            for (Tag tag : batch.getProcess().getTags()) {
                if (tag.getKey().equals("application") && tag.getVType() == TagType.STRING) {
                    applicationName = tag.getVStr();
                    continue;
                }
                if (tag.getKey().equals("cluster") && tag.getVType() == TagType.STRING) {
                    cluster = tag.getVStr();
                    continue;
                }
                if (tag.getKey().equals("shard") && tag.getVType() == TagType.STRING) {
                    shard = tag.getVStr();
                    continue;
                }
                if (tag.getKey().equals("hostname") && tag.getVType() == TagType.STRING) {
                    if (isSourceProcessTagPresent) continue;
                    sourceName = tag.getVStr();
                    continue;
                }
                if (tag.getKey().equals("source") && tag.getVType() == TagType.STRING) {
                    sourceName = tag.getVStr();
                    isSourceProcessTagPresent = true;
                    continue;
                }
                if (tag.getKey().equals("service") && tag.getVType() == TagType.STRING) continue;
                Annotation annotation = JaegerThriftUtils.tagToAnnotation(tag);
                processAnnotations.add(annotation);
            }
        }
        if (FeatureCheckUtils.isFeatureDisabled(traceDisabled, "Ingested span discarded because distributed tracing feature has not been enabled for your account.", discardedBatches, output)) {
            discardedTraces.inc((long)batch.getSpansSize());
            receivedSpansTotal.inc((long)batch.getSpansSize());
            return;
        }
        receivedSpansTotal.inc((long)batch.getSpansSize());
        for (Span span : batch.getSpans()) {
            JaegerThriftUtils.processSpan(span, serviceName, sourceName, applicationName, cluster, shard, processAnnotations, spanHandler, spanLogsHandler, wfInternalReporter, spanLogsDisabled, preprocessorSupplier, sampler, traceDerivedCustomTagKeys, discardedSpansBySampler, discoveredHeartbeatMetrics);
        }
    }

    private static void processSpan(Span span, String serviceName, String sourceName, String applicationName, String cluster, String shard, List<Annotation> processAnnotations, ReportableEntityHandler<wavefront.report.Span, String> spanHandler, ReportableEntityHandler<SpanLogs, String> spanLogsHandler, @Nullable WavefrontInternalReporter wfInternalReporter, Supplier<Boolean> spanLogsDisabled, Supplier<ReportableEntityPreprocessor> preprocessorSupplier, SpanSampler sampler, Set<String> traceDerivedCustomTagKeys, Counter discardedSpansBySampler, Set<Pair<Map<String, String>, String>> discoveredHeartbeatMetrics) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>(processAnnotations);
        String traceId = new UUID(span.getTraceIdHigh(), span.getTraceIdLow()).toString();
        String strippedTraceId = StringUtils.stripStart((String)traceId.replace("-", ""), (String)"0");
        strippedTraceId = strippedTraceId.length() > 0 ? strippedTraceId : "0";
        annotations.add(new Annotation("jaegerSpanId", Long.toHexString(span.getSpanId())));
        annotations.add(new Annotation("jaegerTraceId", strippedTraceId));
        annotations.add(new Annotation("service", serviceName));
        long parentSpanId = span.getParentSpanId();
        if (parentSpanId != 0L) {
            annotations.add(new Annotation("parent", new UUID(0L, parentSpanId).toString()));
        }
        String componentTagValue = "none";
        boolean isError = false;
        if (span.getTags() != null) {
            block38: for (Tag tag : span.getTags()) {
                Annotation annotation;
                if (IGNORE_TAGS.contains(tag.getKey()) || tag.vType == TagType.STRING && StringUtils.isBlank((String)tag.getVStr()) || (annotation = JaegerThriftUtils.tagToAnnotation(tag)) == null) continue;
                switch (annotation.getKey()) {
                    case "application": {
                        applicationName = annotation.getValue();
                        continue block38;
                    }
                    case "cluster": {
                        cluster = annotation.getValue();
                        continue block38;
                    }
                    case "shard": {
                        shard = annotation.getValue();
                        continue block38;
                    }
                    case "source": {
                        sourceName = annotation.getValue();
                        continue block38;
                    }
                    case "service": {
                        continue block38;
                    }
                    case "component": {
                        componentTagValue = annotation.getValue();
                        break;
                    }
                    case "error": {
                        isError = annotation.getValue().equals("true");
                    }
                }
                annotations.add(annotation);
            }
        }
        annotations.add(new Annotation("application", applicationName));
        annotations.add(new Annotation("cluster", cluster));
        annotations.add(new Annotation("shard", shard));
        if (span.getReferences() != null) {
            for (SpanRef reference : span.getReferences()) {
                switch (reference.refType) {
                    case CHILD_OF: {
                        if (reference.getSpanId() != 0L && reference.getSpanId() != parentSpanId) {
                            annotations.add(new Annotation("parent", new UUID(0L, reference.getSpanId()).toString()));
                        }
                    }
                    case FOLLOWS_FROM: {
                        if (reference.getSpanId() == 0L) break;
                        annotations.add(new Annotation("followsFrom", new UUID(0L, reference.getSpanId()).toString()));
                    }
                }
            }
        }
        if (!spanLogsDisabled.get().booleanValue() && span.getLogs() != null && !span.getLogs().isEmpty()) {
            annotations.add(new Annotation("_spanLogs", "true"));
        }
        wavefront.report.Span wavefrontSpan = wavefront.report.Span.newBuilder().setCustomer("dummy").setName(span.getOperationName()).setSource(sourceName).setSpanId(new UUID(0L, span.getSpanId()).toString()).setTraceId(traceId).setStartMillis(span.getStartTime() / 1000L).setDuration(span.getDuration() / 1000L).setAnnotations(annotations).build();
        if (JAEGER_DATA_LOGGER.isLoggable(Level.FINEST)) {
            JAEGER_DATA_LOGGER.info("Inbound Jaeger span: " + span.toString());
            JAEGER_DATA_LOGGER.info("Converted Wavefront span: " + wavefrontSpan.toString());
        }
        if (preprocessorSupplier != null) {
            ReportableEntityPreprocessor preprocessor = preprocessorSupplier.get();
            String[] messageHolder = new String[1];
            preprocessor.forSpan().transform(wavefrontSpan);
            if (!preprocessor.forSpan().filter(wavefrontSpan, messageHolder)) {
                if (messageHolder[0] != null) {
                    spanHandler.reject(wavefrontSpan, (String)messageHolder[0]);
                } else {
                    spanHandler.block(wavefrontSpan);
                }
                return;
            }
        }
        if (sampler.sample(wavefrontSpan, discardedSpansBySampler)) {
            spanHandler.report(wavefrontSpan);
            if (span.getLogs() != null && !span.getLogs().isEmpty() && !FeatureCheckUtils.isFeatureDisabled(spanLogsDisabled, "Ingested span log discarded because this feature has not been enabled for your account.", null)) {
                SpanLogs spanLogs = SpanLogs.newBuilder().setCustomer("default").setTraceId(wavefrontSpan.getTraceId()).setSpanId(wavefrontSpan.getSpanId()).setLogs(span.getLogs().stream().map(x -> {
                    HashMap fields = new HashMap(x.fields.size());
                    x.fields.forEach(t -> {
                        switch (t.vType) {
                            case STRING: {
                                fields.put(t.getKey(), t.getVStr());
                                break;
                            }
                            case BOOL: {
                                fields.put(t.getKey(), String.valueOf(t.isVBool()));
                                break;
                            }
                            case LONG: {
                                fields.put(t.getKey(), String.valueOf(t.getVLong()));
                                break;
                            }
                            case DOUBLE: {
                                fields.put(t.getKey(), String.valueOf(t.getVDouble()));
                                break;
                            }
                        }
                    });
                    return SpanLog.newBuilder().setTimestamp(x.timestamp).setFields(fields).build();
                }).collect(Collectors.toList())).build();
                SpanUtils.addSpanLine(wavefrontSpan, spanLogs);
                spanLogsHandler.report(spanLogs);
            }
        }
        if (wfInternalReporter != null) {
            List processedAnnotations = wavefrontSpan.getAnnotations();
            block40: for (Annotation processedAnnotation : processedAnnotations) {
                switch (processedAnnotation.getKey()) {
                    case "application": {
                        applicationName = processedAnnotation.getValue();
                        continue block40;
                    }
                    case "service": {
                        serviceName = processedAnnotation.getValue();
                        continue block40;
                    }
                    case "cluster": {
                        cluster = processedAnnotation.getValue();
                        continue block40;
                    }
                    case "shard": {
                        shard = processedAnnotation.getValue();
                        continue block40;
                    }
                    case "component": {
                        componentTagValue = processedAnnotation.getValue();
                        continue block40;
                    }
                    case "error": {
                        isError = processedAnnotation.getValue().equals("true");
                        continue block40;
                    }
                }
            }
            List spanTags = processedAnnotations.stream().map(a -> new Pair((Object)a.getKey(), (Object)a.getValue())).collect(Collectors.toList());
            discoveredHeartbeatMetrics.add((Pair<Map<String, String>, String>)SpanDerivedMetricsUtils.reportWavefrontGeneratedData((WavefrontInternalReporter)wfInternalReporter, (String)wavefrontSpan.getName(), (String)applicationName, (String)serviceName, (String)cluster, (String)shard, (String)wavefrontSpan.getSource(), (String)componentTagValue, (boolean)isError, (long)span.getDuration(), traceDerivedCustomTagKeys, spanTags, (boolean)true));
        }
    }

    @Nullable
    private static Annotation tagToAnnotation(Tag tag) {
        switch (tag.vType) {
            case BOOL: {
                return new Annotation(tag.getKey(), String.valueOf(tag.isVBool()));
            }
            case LONG: {
                return new Annotation(tag.getKey(), String.valueOf(tag.getVLong()));
            }
            case DOUBLE: {
                return new Annotation(tag.getKey(), String.valueOf(tag.getVDouble()));
            }
            case STRING: {
                return new Annotation(tag.getKey(), tag.getVStr());
            }
        }
        return null;
    }
}

