/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.logsharvesting;

import com.yammer.metrics.core.DeltaCounter;
import com.yammer.metrics.core.MetricName;
import java.io.IOException;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.specific.SpecificDatumReader;
import wavefront.report.TimeSeries;

public class TimeSeriesUtils {
    private static DatumReader<TimeSeries> datumReader = new SpecificDatumReader(TimeSeries.class);

    public static TimeSeries fromMetricName(MetricName metricName) throws IOException {
        String name = metricName.getName();
        boolean deltaCounter = DeltaCounter.isDelta((String)name);
        if (deltaCounter) {
            name = DeltaCounter.getNameWithoutDeltaPrefix((String)name);
        }
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(TimeSeries.SCHEMA$, name);
        TimeSeries toReturn = (TimeSeries)datumReader.read(null, (Decoder)decoder);
        if (deltaCounter) {
            String newName = DeltaCounter.getDeltaCounterName((String)toReturn.getMetric());
            toReturn.setMetric(newName);
        }
        return toReturn;
    }

    public static MetricName toMetricName(TimeSeries timeSeries) {
        return new MetricName("group", "type", timeSeries.toString());
    }
}

