/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class CountTransformer<T>
implements Function<T, T> {
    private final PreprocessorRuleMetrics ruleMetrics;
    private final Predicate<T> v2Predicate;

    public CountTransformer(@Nullable Predicate<T> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T apply(@Nullable T input) {
        if (input == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (this.v2Predicate.test(input)) {
                this.ruleMetrics.incrementRuleAppliedCounter();
            }
            T t = input;
            return t;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

