/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.wavefront.agent.preprocessor.AnnotatedPredicate;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import com.wavefront.common.TaggedMetricName;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class MetricsFilter
implements AnnotatedPredicate<String> {
    private final boolean allow;
    private final List<Pattern> regexList = new ArrayList<Pattern>();
    private final PreprocessorRuleMetrics ruleMetrics;
    private final Map<String, Boolean> cacheMetrics = new ConcurrentHashMap<String, Boolean>();
    private final Cache<String, Boolean> cacheRegexMatchs;
    private final Counter miss;
    private final Counter queries;

    public MetricsFilter(Map<String, Object> rule, PreprocessorRuleMetrics ruleMetrics, String ruleName, String strPort) {
        this.ruleMetrics = ruleMetrics;
        if (!(rule.get("names") instanceof List)) {
            throw new IllegalArgumentException("'names' should be a list of strings");
        }
        List names = (List)rule.get("names");
        Map opts = (Map)rule.get("opts");
        int maximumSize = 1000000;
        if (opts != null && opts.get("cacheSize") != null && opts.get("cacheSize") instanceof Integer) {
            maximumSize = (Integer)opts.get("cacheSize");
        }
        this.cacheRegexMatchs = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize((long)maximumSize).build();
        String func = rule.get("function").toString();
        if (!func.equalsIgnoreCase("allow") && !func.equalsIgnoreCase("drop")) {
            throw new IllegalArgumentException("'Func' should be 'allow' or 'drop', not '" + func + "'");
        }
        this.allow = func.equalsIgnoreCase("allow");
        names.stream().filter(s -> s.startsWith("/") && s.endsWith("/")).forEach(s -> this.regexList.add(Pattern.compile(s.replaceAll("/([^/]*)/", "$1"))));
        names.stream().filter(s -> !s.startsWith("/") && !s.endsWith("/")).forEach(s -> this.cacheMetrics.put((String)s, this.allow));
        this.queries = Metrics.newCounter((MetricName)new TaggedMetricName("preprocessor." + ruleName, "regexCache.queries", new String[]{"port", strPort}));
        this.miss = Metrics.newCounter((MetricName)new TaggedMetricName("preprocessor." + ruleName, "regexCache.miss", new String[]{"port", strPort}));
        TaggedMetricName sizeMetrics = new TaggedMetricName("preprocessor." + ruleName, "regexCache.size", new String[]{"port", strPort});
        Metrics.defaultRegistry().removeMetric((MetricName)sizeMetrics);
        Metrics.newGauge((MetricName)sizeMetrics, (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return (int)MetricsFilter.this.cacheRegexMatchs.estimatedSize();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test(String pointLine, @Nullable String[] messageHolder) {
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            String name = pointLine.substring(0, pointLine.indexOf(" "));
            Boolean res = this.cacheMetrics.get(name);
            if (res == null) {
                res = this.testRegex(name);
            }
            boolean bl = res;
            return bl;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }

    private boolean testRegex(String name) {
        this.queries.inc();
        return Boolean.TRUE.equals(this.cacheRegexMatchs.get((Object)name, s -> {
            this.miss.inc();
            for (Pattern regex : this.regexList) {
                if (!regex.matcher(name).find()) continue;
                return this.allow;
            }
            return !this.allow;
        }));
    }
}

