/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.wavefront.agent.preprocessor.LengthLimitActionType;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class PreprocessorUtil {
    public static String truncate(String input, int maxLength, LengthLimitActionType actionSubtype) {
        switch (actionSubtype) {
            case TRUNCATE: {
                return input.substring(0, maxLength);
            }
            case TRUNCATE_WITH_ELLIPSIS: {
                return input.substring(0, maxLength - 3) + "...";
            }
        }
        throw new IllegalArgumentException((Object)((Object)actionSubtype) + " action is not allowed!");
    }

    @Nullable
    public static String getString(Map<String, Object> ruleMap, String key) {
        Object value = ruleMap.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Number) {
            return String.valueOf(value);
        }
        return (String)ruleMap.get(key);
    }

    public static boolean getBoolean(Map<String, Object> ruleMap, String key, boolean defaultValue) {
        Object value = ruleMap.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new IllegalArgumentException();
    }

    public static int getInteger(Map<String, Object> ruleMap, String key, int defaultValue) {
        Object value = ruleMap.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new IllegalArgumentException();
    }
}

