/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import wavefront.report.ReportPoint;

public class ReportPointRenameTagTransformer
implements Function<ReportPoint, ReportPoint> {
    private final String tag;
    private final String newTag;
    @Nullable
    private final Pattern compiledPattern;
    private final PreprocessorRuleMetrics ruleMetrics;
    private final Predicate<ReportPoint> v2Predicate;

    public ReportPointRenameTagTransformer(String tag, String newTag, @Nullable String patternMatch, @Nullable Predicate<ReportPoint> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        this.tag = (String)Preconditions.checkNotNull((Object)tag, (Object)"[tag] can't be null");
        this.newTag = (String)Preconditions.checkNotNull((Object)newTag, (Object)"[newtag] can't be null");
        Preconditions.checkArgument((!tag.isEmpty() ? 1 : 0) != 0, (Object)"[tag] can't be blank");
        Preconditions.checkArgument((!newTag.isEmpty() ? 1 : 0) != 0, (Object)"[newtag] can't be blank");
        this.compiledPattern = patternMatch != null ? Pattern.compile(patternMatch) : null;
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ReportPoint apply(@Nullable ReportPoint reportPoint) {
        if (reportPoint == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(reportPoint)) {
                ReportPoint reportPoint2 = reportPoint;
                return reportPoint2;
            }
            String tagValue = (String)reportPoint.getAnnotations().get(this.tag);
            if (tagValue == null || this.compiledPattern != null && !this.compiledPattern.matcher(tagValue).matches()) {
                ReportPoint reportPoint3 = reportPoint;
                return reportPoint3;
            }
            reportPoint.getAnnotations().remove(this.tag);
            reportPoint.getAnnotations().put(this.newTag, tagValue);
            this.ruleMetrics.incrementRuleAppliedCounter();
            ReportPoint reportPoint4 = reportPoint;
            return reportPoint4;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

