/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.wavefront.agent.preprocessor.AnnotatedPredicate;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.Span;

public class SpanBlockFilter
implements AnnotatedPredicate<Span> {
    @Nullable
    private final String scope;
    @Nullable
    private final Pattern compiledPattern;
    private final Predicate<Span> v2Predicate;
    private boolean isV1PredicatePresent = false;
    private final PreprocessorRuleMetrics ruleMetrics;

    public SpanBlockFilter(@Nullable String scope, @Nullable String patternMatch, @Nullable Predicate<Span> v2Predicate, @Nonnull PreprocessorRuleMetrics ruleMetrics) {
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
        if (v2Predicate == null) {
            Preconditions.checkNotNull((Object)scope, (Object)"[scope] can't be null");
            Preconditions.checkArgument((!scope.isEmpty() ? 1 : 0) != 0, (Object)"[scope] can't be blank");
            Preconditions.checkNotNull((Object)patternMatch, (Object)"[match] can't be null");
            Preconditions.checkArgument((!patternMatch.isEmpty() ? 1 : 0) != 0, (Object)"[match] can't be blank");
            this.isV1PredicatePresent = true;
        } else {
            boolean bothV1PredicatesNull;
            boolean bothV1PredicatesValid = !Strings.isNullOrEmpty((String)scope) && !Strings.isNullOrEmpty((String)patternMatch);
            boolean bl = bothV1PredicatesNull = scope == null && patternMatch == null;
            if (bothV1PredicatesValid) {
                this.isV1PredicatePresent = true;
            } else if (!bothV1PredicatesNull) {
                throw new IllegalArgumentException("[match], [scope] for rule should both be valid non null/blank values or both null.");
            }
        }
        if (this.isV1PredicatePresent) {
            this.compiledPattern = Pattern.compile(patternMatch);
            this.scope = scope;
        } else {
            this.compiledPattern = null;
            this.scope = null;
        }
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test(@Nonnull Span span, @Nullable String[] messageHolder) {
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(span)) {
                boolean bl = true;
                return bl;
            }
            if (!this.isV1PredicatePresent) {
                this.ruleMetrics.incrementRuleAppliedCounter();
                boolean bl = false;
                return bl;
            }
            switch (this.scope) {
                case "spanName": {
                    if (!this.compiledPattern.matcher(span.getName()).matches()) break;
                    this.ruleMetrics.incrementRuleAppliedCounter();
                    boolean bl = false;
                    return bl;
                }
                case "sourceName": {
                    if (!this.compiledPattern.matcher(span.getSource()).matches()) break;
                    this.ruleMetrics.incrementRuleAppliedCounter();
                    boolean bl = false;
                    return bl;
                }
                default: {
                    for (Annotation annotation : span.getAnnotations()) {
                        if (!annotation.getKey().equals(this.scope) || !this.compiledPattern.matcher(annotation.getValue()).matches()) continue;
                        this.ruleMetrics.incrementRuleAppliedCounter();
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }
}

