/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.queueing;

import com.wavefront.agent.data.DataSubmissionTask;
import com.wavefront.agent.queueing.DirectByteArrayOutputStream;
import com.wavefront.agent.queueing.QueueFile;
import com.wavefront.agent.queueing.TaskConverter;
import com.wavefront.agent.queueing.TaskQueue;
import com.wavefront.common.Utils;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FileBasedTaskQueue<T extends DataSubmissionTask<T>>
implements TaskQueue<T> {
    private static final Logger log = Logger.getLogger(FileBasedTaskQueue.class.getCanonicalName());
    private final DirectByteArrayOutputStream bytes = new DirectByteArrayOutputStream();
    private volatile T head;
    private final AtomicLong currentWeight = new AtomicLong();
    private final QueueFile queueFile;
    private final TaskConverter<T> taskConverter;

    public FileBasedTaskQueue(QueueFile queueFile, TaskConverter<T> taskConverter) {
        this.queueFile = queueFile;
        this.taskConverter = taskConverter;
        log.fine("Enumerating queue");
        this.queueFile.iterator().forEachRemaining(task -> {
            Integer weight = taskConverter.getWeight((byte[])task);
            if (weight != null) {
                this.currentWeight.addAndGet(weight.intValue());
            }
        });
        log.fine("Enumerated: " + this.currentWeight.get() + " items in " + queueFile.size() + " tasks");
    }

    @Override
    public T peek() {
        try {
            if (this.head != null) {
                return this.head;
            }
            byte[] task = this.queueFile.peek();
            if (task == null) {
                return null;
            }
            this.head = (DataSubmissionTask)this.taskConverter.fromBytes(task);
            return this.head;
        }
        catch (IOException ex) {
            throw (Error)Utils.throwAny(ex);
        }
    }

    @Override
    public void add(@Nonnull T entry) throws IOException {
        this.bytes.reset();
        this.taskConverter.serializeToStream(entry, this.bytes);
        this.queueFile.add(this.bytes.getArray(), 0, this.bytes.size());
        this.currentWeight.addAndGet(entry.weight());
    }

    @Override
    public void clear() throws IOException {
        this.queueFile.clear();
        this.head = null;
        this.currentWeight.set(0L);
    }

    @Override
    public void remove() throws IOException {
        if (this.head == null) {
            byte[] task = this.queueFile.peek();
            if (task == null) {
                return;
            }
            this.head = (DataSubmissionTask)this.taskConverter.fromBytes(task);
        }
        this.queueFile.remove();
        if (this.head != null) {
            int weight = this.head.weight();
            this.currentWeight.getAndUpdate(x -> x > (long)weight ? x - (long)weight : 0L);
            this.head = null;
        }
    }

    @Override
    public int size() {
        return this.queueFile.size();
    }

    @Override
    public void close() throws IOException {
        this.queueFile.close();
    }

    @Override
    @Nullable
    public Long weight() {
        return this.currentWeight.get();
    }

    @Override
    @Nullable
    public Long getAvailableBytes() {
        return this.queueFile.storageBytes() - this.queueFile.usedBytes();
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        final Iterator iterator = this.queueFile.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                byte[] data = (byte[])iterator.next();
                try {
                    return (DataSubmissionTask)FileBasedTaskQueue.this.taskConverter.fromBytes(data);
                }
                catch (IOException e) {
                    throw (Error)Utils.throwAny(e);
                }
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }
}

