/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.queueing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.wavefront.agent.data.DataSubmissionTask;
import com.wavefront.agent.queueing.TaskConverter;
import com.wavefront.common.TaggedMetricName;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorOutputStream;
import org.apache.commons.io.IOUtils;

public class RetryTaskConverter<T extends DataSubmissionTask<T>>
implements TaskConverter<T> {
    private static final Logger logger = Logger.getLogger(RetryTaskConverter.class.getCanonicalName());
    static final byte[] TASK_HEADER = new byte[]{87, 70};
    static final byte FORMAT_RAW = 1;
    static final byte FORMAT_GZIP = 2;
    static final byte FORMAT_LZ4_OLD = 3;
    static final byte WRAPPED = 4;
    static final byte FORMAT_LZ4 = 5;
    static final byte[] PREFIX = new byte[]{87, 70, 6, 4};
    private final ObjectMapper objectMapper = ((JsonMapper.Builder)JsonMapper.builder().activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance)).build();
    private final TaskConverter.CompressionType compressionType;
    private final Counter errorCounter;

    public RetryTaskConverter(String handle, TaskConverter.CompressionType compressionType) {
        this.compressionType = compressionType;
        this.errorCounter = Metrics.newCounter((MetricName)new TaggedMetricName("buffer", "read-errors", new String[]{"port", handle}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public T fromBytes(@Nonnull byte[] bytes) {
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        int len = TASK_HEADER.length;
        byte[] prefix = new byte[len];
        if (input.read(prefix, 0, len) == len && Arrays.equals(prefix, TASK_HEADER)) {
            int bytesToRead = input.read();
            if (bytesToRead > 0) {
                byte[] header = new byte[bytesToRead];
                if (input.read(header, 0, bytesToRead) == bytesToRead) {
                    InputStream stream = null;
                    byte compression = header[0] == 4 && bytesToRead > 1 ? header[1] : header[0];
                    try {
                        switch (compression) {
                            case 3: {
                                input.skip(21L);
                                stream = new BlockLZ4CompressorInputStream((InputStream)input);
                                break;
                            }
                            case 5: {
                                stream = new BlockLZ4CompressorInputStream((InputStream)input);
                                break;
                            }
                            case 2: {
                                stream = new GZIPInputStream(input);
                                break;
                            }
                            case 1: {
                                stream = input;
                                break;
                            }
                            default: {
                                logger.warning("Unable to restore persisted task - unsupported data format header detected: " + Arrays.toString(header));
                                T t = null;
                                return t;
                            }
                        }
                        DataSubmissionTask dataSubmissionTask = (DataSubmissionTask)this.objectMapper.readValue(stream, DataSubmissionTask.class);
                        return (T)dataSubmissionTask;
                    }
                    catch (Throwable t) {
                        logger.warning("Unable to restore persisted task: " + t);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)stream);
                    }
                } else {
                    logger.warning("Unable to restore persisted task - corrupted header, ignoring");
                }
            } else {
                logger.warning("Unable to restore persisted task - missing header, ignoring");
            }
        } else {
            logger.warning("Unable to restore persisted task - invalid or missing header, ignoring");
        }
        this.errorCounter.inc();
        return null;
    }

    @Override
    public void serializeToStream(@Nonnull T t, @Nonnull OutputStream bytes) throws IOException {
        bytes.write(TASK_HEADER);
        bytes.write(6);
        bytes.write(4);
        switch (this.compressionType) {
            case LZ4: {
                bytes.write(5);
                bytes.write(ByteBuffer.allocate(4).putInt(t.weight()).array());
                BlockLZ4CompressorOutputStream lz4BlockOutputStream = new BlockLZ4CompressorOutputStream(bytes);
                this.objectMapper.writeValue((OutputStream)lz4BlockOutputStream, t);
                lz4BlockOutputStream.close();
                return;
            }
            case GZIP: {
                bytes.write(2);
                bytes.write(ByteBuffer.allocate(4).putInt(t.weight()).array());
                GZIPOutputStream gzipOutputStream = new GZIPOutputStream(bytes);
                this.objectMapper.writeValue((OutputStream)gzipOutputStream, t);
                gzipOutputStream.close();
                return;
            }
            case NONE: {
                bytes.write(1);
                bytes.write(ByteBuffer.allocate(4).putInt(t.weight()).array());
                this.objectMapper.writeValue(bytes, t);
            }
        }
    }

    @Override
    @Nullable
    public Integer getWeight(@Nonnull byte[] bytes) {
        if (bytes.length > 8 && Arrays.equals(Arrays.copyOf(bytes, PREFIX.length), PREFIX)) {
            return bytes[5] << 24 | (bytes[6] & 0xFF) << 16 | (bytes[7] & 0xFF) << 8 | bytes[8] & 0xFF;
        }
        Object t = this.fromBytes(bytes);
        if (t == null) {
            return null;
        }
        return t.weight();
    }
}

