/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.queueing;

import com.wavefront.agent.queueing.QueueFile;
import com.wavefront.common.TimeProvider;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TapeQueueFile
implements QueueFile {
    private static final Method usedBytes;
    private static final Field fileLength;
    private final com.squareup.tape2.QueueFile delegate;
    @Nullable
    private final BiConsumer<Integer, Long> writeStatsConsumer;
    private final TimeProvider clock;

    public TapeQueueFile(com.squareup.tape2.QueueFile delegate) {
        this(delegate, null, null);
    }

    public TapeQueueFile(com.squareup.tape2.QueueFile delegate, @Nullable BiConsumer<Integer, Long> writeStatsConsumer) {
        this(delegate, writeStatsConsumer, null);
    }

    public TapeQueueFile(com.squareup.tape2.QueueFile delegate, @Nullable BiConsumer<Integer, Long> writeStatsConsumer, @Nullable TimeProvider clock) {
        this.delegate = delegate;
        this.writeStatsConsumer = writeStatsConsumer;
        this.clock = clock == null ? System::currentTimeMillis : clock;
    }

    @Override
    public void add(byte[] data, int offset, int count) throws IOException {
        long startTime = this.clock.currentTimeMillis();
        this.delegate.add(data, offset, count);
        if (this.writeStatsConsumer != null) {
            this.writeStatsConsumer.accept(count, this.clock.currentTimeMillis() - startTime);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    @Nullable
    public byte[] peek() throws IOException {
        return this.delegate.peek();
    }

    @Override
    @Nonnull
    public Iterator<byte[]> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public long storageBytes() {
        try {
            return (Long)fileLength.get(this.delegate);
        }
        catch (IllegalAccessException e) {
            return 0L;
        }
    }

    @Override
    public long usedBytes() {
        try {
            return (Long)usedBytes.invoke((Object)this.delegate, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return 0L;
        }
    }

    @Override
    public long availableBytes() {
        return this.storageBytes() - this.usedBytes();
    }

    @Override
    public void remove() throws IOException {
        this.delegate.remove();
    }

    @Override
    public void clear() throws IOException {
        this.delegate.clear();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    static {
        try {
            Class<?> classQueueFile = Class.forName("com.squareup.tape2.QueueFile");
            usedBytes = classQueueFile.getDeclaredMethod("usedBytes", new Class[0]);
            usedBytes.setAccessible(true);
            fileLength = classQueueFile.getDeclaredField("fileLength");
            fileLength.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

