/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.common;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;

public class HostMetricTagsPair {
    public final String metric;
    public final String host;
    @Nullable
    private final Map<String, String> tags;

    public HostMetricTagsPair(String host, String metric, @Nullable Map<String, String> tags) {
        Preconditions.checkNotNull((Object)host, (Object)"HostMetricTagsPair.host cannot be null");
        Preconditions.checkNotNull((Object)metric, (Object)"HostMetricTagsPair.metric cannot be null");
        this.metric = metric.trim();
        this.host = host.trim().toLowerCase();
        this.tags = tags;
    }

    public String getHost() {
        return this.host;
    }

    public String getMetric() {
        return this.metric;
    }

    @Nullable
    public Map<String, String> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostMetricTagsPair that = (HostMetricTagsPair)o;
        if (!this.metric.equals(that.metric) || !this.host.equals(that.host)) {
            return false;
        }
        return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = 31 * result + this.metric.hashCode();
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("[host: %s, metric: %s, tags: %s]", this.host, this.metric, this.tags);
    }
}

