/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent;

import com.beust.jcommander.ParameterException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.sun.management.UnixOperatingSystemMXBean;
import com.wavefront.agent.InteractiveTester;
import com.wavefront.agent.ProxyCheckInScheduler;
import com.wavefront.agent.ProxyConfig;
import com.wavefront.agent.ProxyUtil;
import com.wavefront.agent.TokenManager;
import com.wavefront.agent.api.APIContainer;
import com.wavefront.agent.config.LogsIngestionConfig;
import com.wavefront.agent.data.EntityPropertiesFactory;
import com.wavefront.agent.data.EntityPropertiesFactoryImpl;
import com.wavefront.agent.logsharvesting.InteractiveLogsTester;
import com.wavefront.agent.preprocessor.InteractivePreprocessorTester;
import com.wavefront.agent.preprocessor.LineBasedAllowFilter;
import com.wavefront.agent.preprocessor.LineBasedBlockFilter;
import com.wavefront.agent.preprocessor.PreprocessorConfigManager;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import com.wavefront.agent.queueing.QueueExporter;
import com.wavefront.agent.queueing.SQSQueueFactoryImpl;
import com.wavefront.agent.queueing.TaskQueueFactoryImpl;
import com.wavefront.api.agent.AgentConfiguration;
import com.wavefront.api.agent.ValidationConfiguration;
import com.wavefront.common.TaggedMetricName;
import com.wavefront.common.Utils;
import com.wavefront.data.ReportableEntityType;
import com.wavefront.metrics.ExpectedAgentMetric;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractAgent {
    protected static final Logger logger = Logger.getLogger("proxy");
    final Counter activeListeners;
    protected final ProxyConfig proxyConfig;
    protected APIContainer apiContainer;
    protected final List<ExecutorService> managedExecutors;
    protected final List<Runnable> shutdownTasks;
    protected final PreprocessorConfigManager preprocessors;
    protected final ValidationConfiguration validationConfiguration;
    protected final Map<String, EntityPropertiesFactory> entityPropertiesFactoryMap;
    protected final AtomicBoolean shuttingDown;
    protected final AtomicBoolean truncate;
    protected ProxyCheckInScheduler proxyCheckinScheduler;
    protected UUID agentId;
    protected SslContext sslContext;
    protected List<String> tlsPorts;
    protected boolean secureAllPorts;

    @Deprecated
    public AbstractAgent(boolean localAgent, boolean pushAgent) {
        this();
    }

    public AbstractAgent() {
        this.activeListeners = Metrics.newCounter((MetricName)ExpectedAgentMetric.ACTIVE_LISTENERS.metricName);
        this.proxyConfig = new ProxyConfig();
        this.managedExecutors = new ArrayList<ExecutorService>();
        this.shutdownTasks = new ArrayList<Runnable>();
        this.preprocessors = new PreprocessorConfigManager();
        this.validationConfiguration = new ValidationConfiguration();
        this.entityPropertiesFactoryMap = Maps.newHashMap();
        this.shuttingDown = new AtomicBoolean(false);
        this.truncate = new AtomicBoolean(false);
        this.tlsPorts = Collections.EMPTY_LIST;
        this.secureAllPorts = false;
        this.entityPropertiesFactoryMap.put("central", new EntityPropertiesFactoryImpl(this.proxyConfig));
    }

    private void addPreprocessorFilters(String ports, String allowList, String blockList) {
        if (ports != null && (allowList != null || blockList != null)) {
            for (String strPort : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)ports)) {
                PreprocessorRuleMetrics ruleMetrics = new PreprocessorRuleMetrics(Metrics.newCounter((MetricName)new TaggedMetricName("validationRegex", "points-rejected", new String[]{"port", strPort})), Metrics.newCounter((MetricName)new TaggedMetricName("validationRegex", "cpu-nanos", new String[]{"port", strPort})), Metrics.newCounter((MetricName)new TaggedMetricName("validationRegex", "points-checked", new String[]{"port", strPort})));
                if (blockList != null) {
                    this.preprocessors.getSystemPreprocessor(strPort).forPointLine().addFilter(new LineBasedBlockFilter(blockList, ruleMetrics));
                }
                if (allowList == null) continue;
                this.preprocessors.getSystemPreprocessor(strPort).forPointLine().addFilter(new LineBasedAllowFilter(allowList, ruleMetrics));
            }
        }
    }

    @VisibleForTesting
    void initSslContext() throws SSLException {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.proxyConfig.getPrivateCertPath()) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.proxyConfig.getPrivateKeyPath())) {
            this.sslContext = SslContextBuilder.forServer((File)new File(this.proxyConfig.getPrivateCertPath()), (File)new File(this.proxyConfig.getPrivateKeyPath())).build();
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.proxyConfig.getTlsPorts()) && this.sslContext == null) {
            Preconditions.checkArgument((this.sslContext != null ? 1 : 0) != 0, (Object)"Missing TLS certificate/private key configuration.");
        }
        if (StringUtils.equals((String)this.proxyConfig.getTlsPorts(), (String)"*")) {
            this.secureAllPorts = true;
        } else {
            this.tlsPorts = Utils.csvToList(this.proxyConfig.getTlsPorts());
        }
    }

    private void initPreprocessors() {
        String configFileName = this.proxyConfig.getPreprocessorConfigFile();
        if (configFileName != null) {
            try {
                this.preprocessors.loadFile(configFileName);
                this.preprocessors.setUpConfigFileMonitoring(configFileName, 5000);
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException("Unable to load preprocessor rules - file does not exist: " + configFileName);
            }
            logger.info("Preprocessor configuration loaded from " + configFileName);
        }
        String allPorts = StringUtils.join((Object[])new String[]{(String)ObjectUtils.firstNonNull((Object[])new String[]{this.proxyConfig.getPushListenerPorts(), ""}), (String)ObjectUtils.firstNonNull((Object[])new String[]{this.proxyConfig.getGraphitePorts(), ""}), (String)ObjectUtils.firstNonNull((Object[])new String[]{this.proxyConfig.getPicklePorts(), ""}), (String)ObjectUtils.firstNonNull((Object[])new String[]{this.proxyConfig.getTraceListenerPorts(), ""})}, (String)",");
        this.addPreprocessorFilters(allPorts, this.proxyConfig.getAllowRegex(), this.proxyConfig.getBlockRegex());
        this.addPreprocessorFilters(this.proxyConfig.getOpentsdbPorts(), this.proxyConfig.getOpentsdbAllowRegex(), this.proxyConfig.getOpentsdbBlockRegex());
    }

    protected LogsIngestionConfig loadLogsIngestionConfig() {
        try {
            if (this.proxyConfig.getLogsIngestionConfigFile() == null) {
                return null;
            }
            ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            return (LogsIngestionConfig)objectMapper.readValue(new File(this.proxyConfig.getLogsIngestionConfigFile()), LogsIngestionConfig.class);
        }
        catch (UnrecognizedPropertyException e) {
            logger.severe("Unable to load logs ingestion config: " + e.getMessage());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not load logs ingestion config", e);
        }
        return null;
    }

    private void postProcessConfig() {
        if (StringUtils.isBlank((String)this.proxyConfig.getHostname())) {
            throw new IllegalArgumentException("hostname cannot be blank! Please correct your configuration settings.");
        }
        if (this.proxyConfig.isSqsQueueBuffer()) {
            if (StringUtils.isBlank((String)this.proxyConfig.getSqsQueueIdentifier())) {
                throw new IllegalArgumentException("sqsQueueIdentifier cannot be blank! Please correct your configuration settings.");
            }
            if (!SQSQueueFactoryImpl.isValidSQSTemplate(this.proxyConfig.getSqsQueueNameTemplate())) {
                throw new IllegalArgumentException("sqsQueueNameTemplate is invalid! Must contain {{id}} {{entity}} and {{port}} replacements.");
            }
        }
    }

    @VisibleForTesting
    void parseArguments(String[] args) {
        try {
            if (!this.proxyConfig.parseArguments(args, this.getClass().getCanonicalName())) {
                System.exit(0);
            }
        }
        catch (ParameterException e) {
            logger.severe("Parameter exception: " + e.getMessage());
            System.exit(1);
        }
    }

    public void start(String[] args) {
        String versionStr = "Wavefront Proxy version " + Utils.getBuildVersion() + " (pkg:" + Utils.getPackage() + "), runtime: " + Utils.getJavaVersion();
        logger.info(versionStr);
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        if (os instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean os1 = (UnixOperatingSystemMXBean)os;
            logger.info("OS Max File Descriptors: " + os1.getMaxFileDescriptorCount());
        }
        try {
            this.parseArguments(args);
            this.postProcessConfig();
            this.initSslContext();
            this.initPreprocessors();
            if (this.proxyConfig.isTestLogs() || this.proxyConfig.getTestPreprocessorForPort() != null || this.proxyConfig.getTestSpanPreprocessorForPort() != null) {
                InteractiveTester interactiveTester;
                if (this.proxyConfig.isTestLogs()) {
                    logger.info("Reading line-by-line sample log messages from STDIN");
                    interactiveTester = new InteractiveLogsTester(this::loadLogsIngestionConfig, this.proxyConfig.getPrefix());
                } else if (this.proxyConfig.getTestPreprocessorForPort() != null) {
                    logger.info("Reading line-by-line points from STDIN");
                    interactiveTester = new InteractivePreprocessorTester(this.preprocessors.get(this.proxyConfig.getTestPreprocessorForPort()), ReportableEntityType.POINT, this.proxyConfig.getTestPreprocessorForPort(), this.proxyConfig.getCustomSourceTags());
                } else if (this.proxyConfig.getTestSpanPreprocessorForPort() != null) {
                    logger.info("Reading line-by-line spans from STDIN");
                    interactiveTester = new InteractivePreprocessorTester(this.preprocessors.get(String.valueOf(this.proxyConfig.getTestPreprocessorForPort())), ReportableEntityType.TRACE, this.proxyConfig.getTestPreprocessorForPort(), this.proxyConfig.getCustomSourceTags());
                } else {
                    throw new IllegalStateException();
                }
                while (interactiveTester.interactiveTest()) {
                }
                System.exit(0);
            }
            if (this.proxyConfig.getExportQueueOutputFile() != null && this.proxyConfig.getExportQueuePorts() != null) {
                TaskQueueFactoryImpl tqFactory = new TaskQueueFactoryImpl(this.proxyConfig.getBufferFile(), false, false, this.proxyConfig.getBufferShardSize());
                EntityPropertiesFactoryImpl epFactory = new EntityPropertiesFactoryImpl(this.proxyConfig);
                QueueExporter queueExporter = new QueueExporter(this.proxyConfig.getBufferFile(), this.proxyConfig.getExportQueuePorts(), this.proxyConfig.getExportQueueOutputFile(), this.proxyConfig.isExportQueueRetainData(), tqFactory, epFactory);
                logger.info("Starting queue export for ports: " + this.proxyConfig.getExportQueuePorts());
                queueExporter.export();
                logger.info("Done");
                System.exit(0);
            }
            this.agentId = ProxyUtil.getOrCreateProxyId(this.proxyConfig);
            this.apiContainer = new APIContainer(this.proxyConfig, this.proxyConfig.isUseNoopSender());
            TokenManager.start(this.apiContainer);
            for (String tenantName : TokenManager.getMulticastingTenantList().keySet()) {
                this.entityPropertiesFactoryMap.put(tenantName, new EntityPropertiesFactoryImpl(this.proxyConfig));
            }
            this.proxyCheckinScheduler = new ProxyCheckInScheduler(this.agentId, this.proxyConfig, this.apiContainer, this::processConfiguration, () -> System.exit(1), this::truncateBacklog);
            this.proxyCheckinScheduler.scheduleCheckins();
            this.startListeners();
            Timer startupTimer = new Timer("Timer-startup");
            this.shutdownTasks.add(startupTimer::cancel);
            startupTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (AbstractAgent.this.activeListeners.count() == 0L) {
                        logger.severe("**** All listener threads failed to start - there is already a running instance listening on configured ports, or no listening ports configured!");
                        logger.severe("Aborting start-up");
                        System.exit(1);
                    }
                    Runtime.getRuntime().addShutdownHook(new Thread("proxy-shutdown-hook"){

                        @Override
                        public void run() {
                            AbstractAgent.this.shutdown();
                        }
                    });
                    logger.info("setup complete");
                }
            }, 5000L);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            System.exit(1);
        }
    }

    protected void processConfiguration(String tenantName, AgentConfiguration config) {
        try {
            for (String tn : TokenManager.getMulticastingTenantList().keySet()) {
                this.apiContainer.getProxyV2APIForTenant(tn).proxyConfigProcessed(this.agentId);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void shutdown() {
        if (!this.shuttingDown.compareAndSet(false, true)) {
            return;
        }
        try {
            try {
                logger.info("Shutting down the proxy...");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.out.println("Shutting down: Stopping listeners...");
            this.stopListeners();
            System.out.println("Shutting down: Stopping schedulers...");
            if (this.proxyCheckinScheduler != null) {
                this.proxyCheckinScheduler.shutdown();
            }
            this.managedExecutors.forEach(ExecutorService::shutdownNow);
            this.managedExecutors.forEach(x -> {
                try {
                    x.awaitTermination(this.proxyConfig.getHttpRequestTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            System.out.println("Shutting down: Running finalizing tasks...");
            this.shutdownTasks.forEach(Runnable::run);
            System.out.println("Shutdown complete.");
        }
        catch (Throwable t) {
            try {
                logger.log(Level.SEVERE, "Error during shutdown: ", t);
            }
            catch (Throwable loggingError) {
                t.addSuppressed(loggingError);
                t.printStackTrace();
            }
        }
    }

    protected abstract void startListeners() throws Exception;

    protected abstract void stopListeners();

    protected abstract void stopListener(int var1);

    protected abstract void truncateBacklog();
}

