/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.wavefront.agent.ProxyConfigDef;
import com.wavefront.agent.TenantInfo;
import com.wavefront.agent.TokenManager;
import com.wavefront.agent.TokenWorkerCSP;
import com.wavefront.agent.TokenWorkerWF;
import com.wavefront.agent.auth.TokenValidationMethod;
import com.wavefront.agent.config.Categories;
import com.wavefront.agent.config.ProxyConfigOption;
import com.wavefront.agent.config.ReportableConfig;
import com.wavefront.agent.config.SubCategories;
import com.wavefront.agent.data.TaskQueueLevel;
import com.wavefront.common.TaggedMetricName;
import com.wavefront.common.TimeProvider;
import com.wavefront.common.Utils;
import com.yammer.metrics.core.MetricName;
import io.opentracing.tag.Tags;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class ProxyConfig
extends ProxyConfigDef {
    static final int GRAPHITE_LISTENING_PORT = 2878;
    private static final Logger logger = Logger.getLogger(ProxyConfig.class.getCanonicalName());
    private static final double MAX_RETRY_BACKOFF_BASE_SECONDS = 60.0;
    @VisibleForTesting
    public static final Integer NUMBER_OF_VISIBLE_DIGITS = 4;
    private final List<Field> modifyByArgs = new ArrayList<Field>();
    private final List<Field> modifyByFile = new ArrayList<Field>();
    TimeProvider timeProvider = System::currentTimeMillis;

    public String getCSPBaseUrl() {
        return this.cspBaseUrl;
    }

    public boolean isHelp() {
        return this.help;
    }

    public boolean isVersion() {
        return this.version;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isTestLogs() {
        return this.testLogs;
    }

    public String getTestPreprocessorForPort() {
        return this.testPreprocessorForPort;
    }

    public String getTestSpanPreprocessorForPort() {
        return this.testSpanPreprocessorForPort;
    }

    public String getServer() {
        return this.server;
    }

    public String getBufferFile() {
        return this.bufferFile;
    }

    public int getBufferShardSize() {
        return this.bufferShardSize;
    }

    public boolean isDisableBufferSharding() {
        return this.disableBufferSharding;
    }

    public boolean isSqsQueueBuffer() {
        return this.sqsQueueBuffer;
    }

    public String getSqsQueueNameTemplate() {
        return this.sqsQueueNameTemplate;
    }

    public String getSqsQueueRegion() {
        return this.sqsQueueRegion;
    }

    public String getSqsQueueIdentifier() {
        return this.sqsQueueIdentifier;
    }

    public TaskQueueLevel getTaskQueueLevel() {
        return this.taskQueueLevel;
    }

    public String getExportQueuePorts() {
        return this.exportQueuePorts;
    }

    public String getExportQueueOutputFile() {
        return this.exportQueueOutputFile;
    }

    public boolean isExportQueueRetainData() {
        return this.exportQueueRetainData;
    }

    public boolean isUseNoopSender() {
        return this.useNoopSender;
    }

    public int getFlushThreads() {
        return this.flushThreads;
    }

    public int getFlushThreadsSourceTags() {
        return this.flushThreadsSourceTags;
    }

    public int getFlushThreadsEvents() {
        return this.flushThreadsEvents;
    }

    public int getFlushThreadsLogs() {
        return this.flushThreadsLogs;
    }

    public int getPushFlushIntervalLogs() {
        return this.pushFlushIntervalLogs;
    }

    public boolean isPurgeBuffer() {
        return this.purgeBuffer;
    }

    public int getPushFlushInterval() {
        return this.pushFlushInterval;
    }

    public int getPushFlushMaxPoints() {
        return this.pushFlushMaxPoints;
    }

    public int getPushFlushMaxHistograms() {
        return this.pushFlushMaxHistograms;
    }

    public int getPushFlushMaxSourceTags() {
        return this.pushFlushMaxSourceTags;
    }

    public int getPushFlushMaxSpans() {
        return this.pushFlushMaxSpans;
    }

    public int getPushFlushMaxSpanLogs() {
        return this.pushFlushMaxSpanLogs;
    }

    public int getPushFlushMaxEvents() {
        return this.pushFlushMaxEvents;
    }

    public int getPushFlushMaxLogs() {
        return this.pushFlushMaxLogs;
    }

    public double getPushRateLimit() {
        return this.pushRateLimit;
    }

    public double getPushRateLimitHistograms() {
        return this.pushRateLimitHistograms;
    }

    public double getPushRateLimitSourceTags() {
        return this.pushRateLimitSourceTags;
    }

    public double getPushRateLimitSpans() {
        return this.pushRateLimitSpans;
    }

    public double getPushRateLimitSpanLogs() {
        return this.pushRateLimitSpanLogs;
    }

    public double getPushRateLimitEvents() {
        return this.pushRateLimitEvents;
    }

    public double getPushRateLimitLogs() {
        return this.pushRateLimitLogs;
    }

    public int getPushRateLimitMaxBurstSeconds() {
        return this.pushRateLimitMaxBurstSeconds;
    }

    public int getPushMemoryBufferLimit() {
        return this.pushMemoryBufferLimit;
    }

    public int getPushMemoryBufferLimitLogs() {
        return this.pushMemoryBufferLimitLogs;
    }

    public int getPushBlockedSamples() {
        return this.pushBlockedSamples;
    }

    public String getBlockedPointsLoggerName() {
        return this.blockedPointsLoggerName;
    }

    public String getBlockedHistogramsLoggerName() {
        return this.blockedHistogramsLoggerName;
    }

    public String getBlockedSpansLoggerName() {
        return this.blockedSpansLoggerName;
    }

    public String getBlockedLogsLoggerName() {
        return this.blockedLogsLoggerName;
    }

    public String getPushListenerPorts() {
        return this.pushListenerPorts;
    }

    public int getPushListenerMaxReceivedLength() {
        return this.pushListenerMaxReceivedLength;
    }

    public int getPushListenerHttpBufferSize() {
        return this.pushListenerHttpBufferSize;
    }

    public int getTraceListenerMaxReceivedLength() {
        return this.traceListenerMaxReceivedLength;
    }

    public int getTraceListenerHttpBufferSize() {
        return this.traceListenerHttpBufferSize;
    }

    public int getListenerIdleConnectionTimeout() {
        return this.listenerIdleConnectionTimeout;
    }

    public int getMemGuardFlushThreshold() {
        return this.memGuardFlushThreshold;
    }

    public boolean isHistogramPassthroughRecompression() {
        return this.histogramPassthroughRecompression;
    }

    public String getHistogramStateDirectory() {
        return this.histogramStateDirectory;
    }

    public long getHistogramAccumulatorResolveInterval() {
        return this.histogramAccumulatorResolveInterval;
    }

    public long getHistogramAccumulatorFlushInterval() {
        return this.histogramAccumulatorFlushInterval;
    }

    public int getHistogramAccumulatorFlushMaxBatchSize() {
        return this.histogramAccumulatorFlushMaxBatchSize;
    }

    public int getHistogramMaxReceivedLength() {
        return this.histogramMaxReceivedLength;
    }

    public int getHistogramHttpBufferSize() {
        return this.histogramHttpBufferSize;
    }

    public String getHistogramMinuteListenerPorts() {
        return this.histogramMinuteListenerPorts;
    }

    public int getHistogramMinuteFlushSecs() {
        return this.histogramMinuteFlushSecs;
    }

    public short getHistogramMinuteCompression() {
        return this.histogramMinuteCompression;
    }

    public int getHistogramMinuteAvgKeyBytes() {
        return this.histogramMinuteAvgKeyBytes;
    }

    public int getHistogramMinuteAvgDigestBytes() {
        return this.histogramMinuteAvgDigestBytes;
    }

    public long getHistogramMinuteAccumulatorSize() {
        return this.histogramMinuteAccumulatorSize;
    }

    public boolean isHistogramMinuteAccumulatorPersisted() {
        return this.histogramMinuteAccumulatorPersisted;
    }

    public boolean isHistogramMinuteMemoryCache() {
        return this.histogramMinuteMemoryCache;
    }

    public String getHistogramHourListenerPorts() {
        return this.histogramHourListenerPorts;
    }

    public int getHistogramHourFlushSecs() {
        return this.histogramHourFlushSecs;
    }

    public short getHistogramHourCompression() {
        return this.histogramHourCompression;
    }

    public int getHistogramHourAvgKeyBytes() {
        return this.histogramHourAvgKeyBytes;
    }

    public int getHistogramHourAvgDigestBytes() {
        return this.histogramHourAvgDigestBytes;
    }

    public long getHistogramHourAccumulatorSize() {
        return this.histogramHourAccumulatorSize;
    }

    public boolean isHistogramHourAccumulatorPersisted() {
        return this.histogramHourAccumulatorPersisted;
    }

    public boolean isHistogramHourMemoryCache() {
        return this.histogramHourMemoryCache;
    }

    public String getHistogramDayListenerPorts() {
        return this.histogramDayListenerPorts;
    }

    public int getHistogramDayFlushSecs() {
        return this.histogramDayFlushSecs;
    }

    public short getHistogramDayCompression() {
        return this.histogramDayCompression;
    }

    public int getHistogramDayAvgKeyBytes() {
        return this.histogramDayAvgKeyBytes;
    }

    public int getHistogramDayAvgDigestBytes() {
        return this.histogramDayAvgDigestBytes;
    }

    public long getHistogramDayAccumulatorSize() {
        return this.histogramDayAccumulatorSize;
    }

    public boolean isHistogramDayAccumulatorPersisted() {
        return this.histogramDayAccumulatorPersisted;
    }

    public boolean isHistogramDayMemoryCache() {
        return this.histogramDayMemoryCache;
    }

    public String getHistogramDistListenerPorts() {
        return this.histogramDistListenerPorts;
    }

    public int getHistogramDistFlushSecs() {
        return this.histogramDistFlushSecs;
    }

    public short getHistogramDistCompression() {
        return this.histogramDistCompression;
    }

    public int getHistogramDistAvgKeyBytes() {
        return this.histogramDistAvgKeyBytes;
    }

    public int getHistogramDistAvgDigestBytes() {
        return this.histogramDistAvgDigestBytes;
    }

    public long getHistogramDistAccumulatorSize() {
        return this.histogramDistAccumulatorSize;
    }

    public boolean isHistogramDistAccumulatorPersisted() {
        return this.histogramDistAccumulatorPersisted;
    }

    public boolean isHistogramDistMemoryCache() {
        return this.histogramDistMemoryCache;
    }

    public String getGraphitePorts() {
        return this.graphitePorts;
    }

    public String getGraphiteFormat() {
        return this.graphiteFormat;
    }

    public String getGraphiteDelimiters() {
        return this.graphiteDelimiters;
    }

    public String getGraphiteFieldsToRemove() {
        return this.graphiteFieldsToRemove;
    }

    public String getJsonListenerPorts() {
        return this.jsonListenerPorts;
    }

    public String getDataDogJsonPorts() {
        return this.dataDogJsonPorts;
    }

    public String getDataDogRequestRelayTarget() {
        return this.dataDogRequestRelayTarget;
    }

    public int getDataDogRequestRelayAsyncThreads() {
        return this.dataDogRequestRelayAsyncThreads;
    }

    public boolean isDataDogRequestRelaySyncMode() {
        return this.dataDogRequestRelaySyncMode;
    }

    public boolean isDataDogProcessSystemMetrics() {
        return this.dataDogProcessSystemMetrics;
    }

    public boolean isDataDogProcessServiceChecks() {
        return this.dataDogProcessServiceChecks;
    }

    public String getWriteHttpJsonListenerPorts() {
        return this.writeHttpJsonListenerPorts;
    }

    public String getOtlpGrpcListenerPorts() {
        return this.otlpGrpcListenerPorts;
    }

    public String getOtlpHttpListenerPorts() {
        return this.otlpHttpListenerPorts;
    }

    public boolean isOtlpResourceAttrsOnMetricsIncluded() {
        return this.otlpResourceAttrsOnMetricsIncluded;
    }

    public boolean isOtlpAppTagsOnMetricsIncluded() {
        return this.otlpAppTagsOnMetricsIncluded;
    }

    public int getFilebeatPort() {
        return this.filebeatPort;
    }

    public int getRawLogsPort() {
        return this.rawLogsPort;
    }

    public int getRawLogsMaxReceivedLength() {
        return this.rawLogsMaxReceivedLength;
    }

    public int getRawLogsHttpBufferSize() {
        return this.rawLogsHttpBufferSize;
    }

    public String getLogsIngestionConfigFile() {
        return this.logsIngestionConfigFile;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getProxyname() {
        return this.proxyname;
    }

    public String getIdFile() {
        return this.idFile;
    }

    public String getAllowRegex() {
        return this.allowRegex;
    }

    public String getBlockRegex() {
        return this.blockRegex;
    }

    public String getOpentsdbPorts() {
        return this.opentsdbPorts;
    }

    public String getOpentsdbAllowRegex() {
        return this.opentsdbAllowRegex;
    }

    public String getOpentsdbBlockRegex() {
        return this.opentsdbBlockRegex;
    }

    public String getPicklePorts() {
        return this.picklePorts;
    }

    public String getTraceListenerPorts() {
        return this.traceListenerPorts;
    }

    public String getTraceJaegerListenerPorts() {
        return this.traceJaegerListenerPorts;
    }

    public String getTraceJaegerHttpListenerPorts() {
        return this.traceJaegerHttpListenerPorts;
    }

    public String getTraceJaegerGrpcListenerPorts() {
        return this.traceJaegerGrpcListenerPorts;
    }

    public String getTraceJaegerApplicationName() {
        return this.traceJaegerApplicationName;
    }

    public String getTraceZipkinListenerPorts() {
        return this.traceZipkinListenerPorts;
    }

    public String getTraceZipkinApplicationName() {
        return this.traceZipkinApplicationName;
    }

    public String getCustomTracingListenerPorts() {
        return this.customTracingListenerPorts;
    }

    public String getCustomTracingApplicationName() {
        return this.customTracingApplicationName;
    }

    public String getCustomTracingServiceName() {
        return this.customTracingServiceName;
    }

    public double getTraceSamplingRate() {
        return this.traceSamplingRate;
    }

    public int getTraceSamplingDuration() {
        return this.traceSamplingDuration;
    }

    public Set<String> getTraceDerivedCustomTagKeys() {
        HashSet<String> customTagKeys = new HashSet<String>(Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)ObjectUtils.firstNonNull((Object[])new String[]{this.traceDerivedCustomTagKeys, ""})));
        customTagKeys.add(Tags.SPAN_KIND.getKey());
        return customTagKeys;
    }

    public boolean isBackendSpanHeadSamplingPercentIgnored() {
        return this.backendSpanHeadSamplingPercentIgnored;
    }

    public String getPushRelayListenerPorts() {
        return this.pushRelayListenerPorts;
    }

    public boolean isPushRelayHistogramAggregator() {
        return this.pushRelayHistogramAggregator;
    }

    public long getPushRelayHistogramAggregatorAccumulatorSize() {
        return this.pushRelayHistogramAggregatorAccumulatorSize;
    }

    public int getPushRelayHistogramAggregatorFlushSecs() {
        return this.pushRelayHistogramAggregatorFlushSecs;
    }

    public short getPushRelayHistogramAggregatorCompression() {
        return this.pushRelayHistogramAggregatorCompression;
    }

    public boolean isSplitPushWhenRateLimited() {
        return this.splitPushWhenRateLimited;
    }

    public double getRetryBackoffBaseSeconds() {
        return this.retryBackoffBaseSeconds;
    }

    public List<String> getCustomSourceTags() {
        LinkedHashSet tagSet = new LinkedHashSet();
        Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)this.customSourceTags).forEach(x -> {
            if (!tagSet.add(x)) {
                logger.warning("Duplicate tag " + x + " specified in customSourceTags config setting");
            }
        });
        return new ArrayList<String>(tagSet);
    }

    public List<String> getCustomTimestampTags() {
        LinkedHashSet tagSet = new LinkedHashSet();
        Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)this.customTimestampTags).forEach(x -> {
            if (!tagSet.add(x)) {
                logger.warning("Duplicate tag " + x + " specified in customTimestampTags config setting");
            }
        });
        return new ArrayList<String>(tagSet);
    }

    public List<String> getCustomMessageTags() {
        LinkedHashSet tagSet = new LinkedHashSet();
        Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)this.customMessageTags).forEach(x -> {
            if (!tagSet.add(x)) {
                logger.warning("Duplicate tag " + x + " specified in customMessageTags config setting");
            }
        });
        return new ArrayList<String>(tagSet);
    }

    public List<String> getCustomApplicationTags() {
        LinkedHashSet tagSet = new LinkedHashSet();
        Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)this.customApplicationTags).forEach(x -> {
            if (!tagSet.add(x)) {
                logger.warning("Duplicate tag " + x + " specified in customApplicationTags config setting");
            }
        });
        return new ArrayList<String>(tagSet);
    }

    public List<String> getCustomServiceTags() {
        LinkedHashSet tagSet = new LinkedHashSet();
        Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)this.customServiceTags).forEach(x -> {
            if (!tagSet.add(x)) {
                logger.warning("Duplicate tag " + x + " specified in customServiceTags config setting");
            }
        });
        return new ArrayList<String>(tagSet);
    }

    public List<String> getCustomExceptionTags() {
        LinkedHashSet tagSet = new LinkedHashSet();
        Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)this.customExceptionTags).forEach(x -> {
            if (!tagSet.add(x)) {
                logger.warning("Duplicate tag " + x + " specified in customExceptionTags config setting");
            }
        });
        return new ArrayList<String>(tagSet);
    }

    public List<String> getCustomLevelTags() {
        LinkedHashSet tagSet = new LinkedHashSet();
        Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)this.customLevelTags).forEach(x -> {
            if (!tagSet.add(x)) {
                logger.warning("Duplicate tag " + x + " specified in customLevelTags config setting");
            }
        });
        return new ArrayList<String>(tagSet);
    }

    public Map<String, String> getAgentMetricsPointTags() {
        return this.agentMetricsPointTags == null ? Collections.emptyMap() : Splitter.on((String)",").trimResults().omitEmptyStrings().withKeyValueSeparator("=").split((CharSequence)this.agentMetricsPointTags);
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public boolean isDisableRdnsLookup() {
        return this.disableRdnsLookup;
    }

    public boolean isGzipCompression() {
        return this.gzipCompression;
    }

    public int getGzipCompressionLevel() {
        return this.gzipCompressionLevel;
    }

    public int getSoLingerTime() {
        return this.soLingerTime;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public String getHttpUserAgent() {
        return this.httpUserAgent;
    }

    public int getHttpConnectTimeout() {
        return this.httpConnectTimeout;
    }

    public int getHttpRequestTimeout() {
        return this.httpRequestTimeout;
    }

    public int getHttpMaxConnTotal() {
        return this.httpMaxConnTotal;
    }

    public int getHttpMaxConnPerRoute() {
        return this.httpMaxConnPerRoute;
    }

    public int getHttpAutoRetries() {
        return this.httpAutoRetries;
    }

    public String getPreprocessorConfigFile() {
        return this.preprocessorConfigFile;
    }

    public int getDataBackfillCutoffHours() {
        return this.dataBackfillCutoffHours;
    }

    public int getDataPrefillCutoffHours() {
        return this.dataPrefillCutoffHours;
    }

    public TokenValidationMethod getAuthMethod() {
        return this.authMethod;
    }

    public String getAuthTokenIntrospectionServiceUrl() {
        return this.authTokenIntrospectionServiceUrl;
    }

    public String getAuthTokenIntrospectionAuthorizationHeader() {
        return this.authTokenIntrospectionAuthorizationHeader;
    }

    public int getAuthResponseRefreshInterval() {
        return this.authResponseRefreshInterval;
    }

    public int getAuthResponseMaxTtl() {
        return this.authResponseMaxTtl;
    }

    public String getAuthStaticToken() {
        return this.authStaticToken;
    }

    public int getAdminApiListenerPort() {
        return this.adminApiListenerPort;
    }

    public String getAdminApiRemoteIpAllowRegex() {
        return this.adminApiRemoteIpAllowRegex;
    }

    public String getHttpHealthCheckPorts() {
        return this.httpHealthCheckPorts;
    }

    public boolean isHttpHealthCheckAllPorts() {
        return this.httpHealthCheckAllPorts;
    }

    public String getHttpHealthCheckPath() {
        return this.httpHealthCheckPath;
    }

    public String getHttpHealthCheckResponseContentType() {
        return this.httpHealthCheckResponseContentType;
    }

    public int getHttpHealthCheckPassStatusCode() {
        return this.httpHealthCheckPassStatusCode;
    }

    public String getHttpHealthCheckPassResponseBody() {
        return this.httpHealthCheckPassResponseBody;
    }

    public int getHttpHealthCheckFailStatusCode() {
        return this.httpHealthCheckFailStatusCode;
    }

    public String getHttpHealthCheckFailResponseBody() {
        return this.httpHealthCheckFailResponseBody;
    }

    public long getDeltaCountersAggregationIntervalSeconds() {
        return this.deltaCountersAggregationIntervalSeconds;
    }

    public String getDeltaCountersAggregationListenerPorts() {
        return this.deltaCountersAggregationListenerPorts;
    }

    @JsonIgnore
    public TimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    public String getPrivateCertPath() {
        return this.privateCertPath;
    }

    public String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public String getTlsPorts() {
        return this.tlsPorts;
    }

    public boolean isTrafficShaping() {
        return this.trafficShaping;
    }

    public int getTrafficShapingWindowSeconds() {
        return this.trafficShapingWindowSeconds;
    }

    public double getTrafficShapingHeadroom() {
        return this.trafficShapingHeadroom;
    }

    public List<String> getCorsEnabledPorts() {
        return Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)this.corsEnabledPorts);
    }

    public List<String> getCorsOrigin() {
        return Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)this.corsOrigin);
    }

    public boolean isCorsAllowNullOrigin() {
        return this.corsAllowNullOrigin;
    }

    public String getLogServerIngestionToken() {
        return this.logServerIngestionToken;
    }

    public String getLogServerIngestionURL() {
        return this.logServerIngestionURL;
    }

    public boolean enableHyperlogsConvergedCsp() {
        return this.enableHyperlogsConvergedCsp;
    }

    public void setEnableHyperlogsConvergedCsp(boolean enableHyperlogsConvergedCsp) {
        this.enableHyperlogsConvergedCsp = enableHyperlogsConvergedCsp;
    }

    public boolean receivedLogServerDetails() {
        return this.receivedLogServerDetails;
    }

    public void setReceivedLogServerDetails(boolean receivedLogServerDetails) {
        this.receivedLogServerDetails = receivedLogServerDetails;
    }

    @Override
    public void verifyAndInit() {
        throw new UnsupportedOperationException("not implemented");
    }

    private void configFileExtraArguments(ReportableConfig config) {
        int multicastingTenants = Integer.parseInt(config.getProperty("multicastingTenants", "0"));
        for (int i = 1; i <= multicastingTenants; ++i) {
            String tenantName = config.getProperty(String.format("multicastingTenantName_%d", i), "");
            if (tenantName.equals("central")) {
                throw new IllegalArgumentException("Error in multicasting endpoints initiation: \"central\" is the reserved tenant name.");
            }
            String tenantServer = config.getProperty(String.format("multicastingServer_%d", i), "");
            String tenantToken = config.getProperty(String.format("multicastingToken_%d", i), "");
            String tenantCSPAppId = config.getProperty(String.format("multicastingCSPAppId_%d", i), "");
            String tenantCSPAppSecret = config.getProperty(String.format("multicastingCSPAppSecret_%d", i), "");
            String tenantCSPOrgId = config.getProperty(String.format("multicastingCSPOrgId_%d", i), "");
            String tenantCSPAPIToken = config.getProperty(String.format("multicastingCSPAPIToken_%d", i), "");
            this.constructTenantInfoObject(tenantCSPAppId, tenantCSPAppSecret, tenantCSPOrgId, tenantCSPAPIToken, tenantToken, tenantServer, tenantName);
        }
        if (config.isDefined("avgHistogramKeyBytes").booleanValue()) {
            this.histogramDayAvgKeyBytes = this.histogramDistAvgKeyBytes = config.getInteger("avgHistogramKeyBytes", 150);
            this.histogramHourAvgKeyBytes = this.histogramDistAvgKeyBytes;
            this.histogramMinuteAvgKeyBytes = this.histogramDistAvgKeyBytes;
        }
        if (config.isDefined("avgHistogramDigestBytes").booleanValue()) {
            this.histogramDayAvgDigestBytes = this.histogramDistAvgDigestBytes = config.getInteger("avgHistogramDigestBytes", 500);
            this.histogramHourAvgDigestBytes = this.histogramDistAvgDigestBytes;
            this.histogramMinuteAvgDigestBytes = this.histogramDistAvgDigestBytes;
        }
        if (config.isDefined("histogramAccumulatorSize").booleanValue()) {
            this.histogramDayAccumulatorSize = this.histogramDistAccumulatorSize = config.getLong("histogramAccumulatorSize", 100000);
            this.histogramHourAccumulatorSize = this.histogramDistAccumulatorSize;
            this.histogramMinuteAccumulatorSize = this.histogramDistAccumulatorSize;
        }
        if (config.isDefined("histogramCompression").booleanValue()) {
            this.histogramDayCompression = this.histogramDistCompression = config.getNumber("histogramCompression", null, 20, 1000).shortValue();
            this.histogramHourCompression = this.histogramDistCompression;
            this.histogramMinuteCompression = this.histogramDistCompression;
        }
        if (config.isDefined("persistAccumulator").booleanValue()) {
            this.histogramDayAccumulatorPersisted = this.histogramDistAccumulatorPersisted = config.getBoolean("persistAccumulator", false).booleanValue();
            this.histogramHourAccumulatorPersisted = this.histogramDistAccumulatorPersisted;
            this.histogramMinuteAccumulatorPersisted = this.histogramDistAccumulatorPersisted;
        }
        this.histogramMinuteCompression = config.getNumber("histogramMinuteCompression", this.histogramMinuteCompression, 20, 1000).shortValue();
        this.histogramMinuteAvgDigestBytes = 32 + this.histogramMinuteCompression * 7;
        this.histogramHourCompression = config.getNumber("histogramHourCompression", this.histogramHourCompression, 20, 1000).shortValue();
        this.histogramHourAvgDigestBytes = 32 + this.histogramHourCompression * 7;
        this.histogramDayCompression = config.getNumber("histogramDayCompression", this.histogramDayCompression, 20, 1000).shortValue();
        this.histogramDayAvgDigestBytes = 32 + this.histogramDayCompression * 7;
        this.histogramDistCompression = config.getNumber("histogramDistCompression", this.histogramDistCompression, 20, 1000).shortValue();
        this.histogramDistAvgDigestBytes = 32 + this.histogramDistCompression * 7;
        this.proxyPassword = config.getString("proxyPassword", this.proxyPassword, s -> "<removed>");
        this.httpMaxConnTotal = Math.min(200, config.getInteger("httpMaxConnTotal", this.httpMaxConnTotal));
        this.httpMaxConnPerRoute = Math.min(100, config.getInteger("httpMaxConnPerRoute", this.httpMaxConnPerRoute));
        this.gzipCompressionLevel = config.getNumber("gzipCompressionLevel", this.gzipCompressionLevel, 1, 9).intValue();
        this.pushFlushMaxPoints = Math.max(Math.min(Math.min(config.getInteger("pushFlushMaxPoints", this.pushFlushMaxPoints), 40000), (int)this.pushRateLimit), 100);
        this.pushFlushMaxHistograms = Math.max(Math.min(Math.min(config.getInteger("pushFlushMaxHistograms", this.pushFlushMaxHistograms), 10000), (int)this.pushRateLimitHistograms), 100);
        this.pushFlushMaxSourceTags = Math.max(Math.min(Math.min(config.getInteger("pushFlushMaxSourceTags", this.pushFlushMaxSourceTags), 50), (int)this.pushRateLimitSourceTags), 1);
        this.pushFlushMaxSpans = Math.max(Math.min(Math.min(config.getInteger("pushFlushMaxSpans", this.pushFlushMaxSpans), 5000), (int)this.pushRateLimitSpans), 100);
        this.pushFlushMaxSpanLogs = Math.max(Math.min(Math.min(config.getInteger("pushFlushMaxSpanLogs", this.pushFlushMaxSpanLogs), 1000), (int)this.pushRateLimitSpanLogs), 100);
        this.pushFlushMaxEvents = Math.min(Math.min(Math.max(config.getInteger("pushFlushMaxEvents", this.pushFlushMaxEvents), 1), 50), (int)(this.pushRateLimitEvents + 1.0));
        this.pushFlushMaxLogs = Math.max(Math.min(Math.min(config.getInteger("pushFlushMaxLogs", this.pushFlushMaxLogs), 0x500000), (int)this.pushRateLimitLogs), 0x100000);
        this.pushMemoryBufferLimitLogs = Math.max(config.getInteger("pushMemoryBufferLimitLogs", this.pushMemoryBufferLimitLogs), this.pushFlushMaxLogs);
        this.pushMemoryBufferLimit = Math.max(config.getInteger("pushMemoryBufferLimit", this.pushMemoryBufferLimit), this.pushFlushMaxPoints);
        this.retryBackoffBaseSeconds = Math.max(Math.min(config.getDouble("retryBackoffBaseSeconds", this.retryBackoffBaseSeconds), 60.0), 1.0);
    }

    public boolean parseArguments(String[] args, String programName) throws ParameterException {
        JCommander jc = JCommander.newBuilder().programName(programName).addObject((Object)this).allowParameterOverwriting(true).acceptUnknownOptions(true).build();
        jc.parse(args);
        if (this.isVersion()) {
            return false;
        }
        if (this.isHelp()) {
            jc.usage();
            return false;
        }
        this.detectModifiedOptions(Arrays.stream(args).filter(s -> s.startsWith("-")), this.modifyByArgs);
        String argsStr = this.modifyByArgs.stream().map(field -> field.getName()).collect(Collectors.joining(", "));
        logger.info("modifyByArgs: " + argsStr);
        if (this.pushConfigFile != null) {
            ReportableConfig confFile = new ReportableConfig();
            ArrayList fileArgs = new ArrayList();
            try {
                confFile.load(Files.newInputStream(Paths.get(this.pushConfigFile, new String[0]), new OpenOption[0]));
            }
            catch (Throwable exception) {
                logger.severe("Could not load configuration file " + this.pushConfigFile);
                throw new RuntimeException(exception.getMessage());
            }
            confFile.entrySet().stream().filter(entry -> !entry.getKey().toString().startsWith("multicasting")).forEach(entry -> {
                fileArgs.add("--" + entry.getKey().toString());
                fileArgs.add(entry.getValue().toString());
            });
            jc.parse(fileArgs.toArray(new String[0]));
            this.detectModifiedOptions(fileArgs.stream().filter(s -> s.startsWith("-")), this.modifyByFile);
            String fileStr = this.modifyByFile.stream().map(field -> field.getName()).collect(Collectors.joining(", "));
            logger.info("modifyByFile: " + fileStr);
            this.modifyByArgs.removeAll(this.modifyByFile);
            this.configFileExtraArguments(confFile);
        }
        this.constructTenantInfoObject(this.cspAppId, this.cspAppSecret, this.cspOrgId, this.cspAPIToken, this.token, this.server, "central");
        logger.info("Unparsed arguments: " + Joiner.on((String)", ").join((Iterable)jc.getUnknownOptions()));
        String FQDN = Utils.getLocalHostName();
        if (!this.hostname.equals(FQDN)) {
            logger.warning("Deprecated field hostname specified in config setting. Please use proxyname config field to set proxy name.");
            if (this.proxyname.equals(FQDN)) {
                this.proxyname = this.hostname;
            }
        }
        logger.info("Using proxyname:'" + this.proxyname + "' hostname:'" + this.hostname + "'");
        if (this.httpUserAgent == null) {
            this.httpUserAgent = "Wavefront-Proxy/" + Utils.getBuildVersion();
        }
        this.createConfigMetrics();
        ArrayList cfgStrs = new ArrayList();
        ArrayList<Field> cfg = new ArrayList<Field>();
        cfg.addAll(this.modifyByArgs);
        cfg.addAll(this.modifyByFile);
        cfg.stream().forEach(field -> {
            boolean hide;
            Optional<ProxyConfigOption> option = Arrays.stream((ProxyConfigOption[])field.getAnnotationsByType(ProxyConfigOption.class)).findFirst();
            boolean bl = hide = option.isPresent() && option.get().hide();
            if (!hide) {
                boolean secret = option.isPresent() && option.get().secret();
                try {
                    boolean arg = !this.modifyByFile.contains(field);
                    cfgStrs.add("\t" + (arg ? "* " : "  ") + field.getName() + " = " + (secret ? "******" : field.get(this)));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        logger.info("Config: (* command line argument)");
        for (String cfgStr : cfgStrs) {
            logger.info(cfgStr);
        }
        return true;
    }

    private void createConfigMetrics() {
        Field[] fields;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            boolean hide;
            Optional<Parameter> parameter = Arrays.stream((Parameter[])field.getAnnotationsByType(Parameter.class)).findFirst();
            Optional<ProxyConfigOption> option = Arrays.stream((ProxyConfigOption[])field.getAnnotationsByType(ProxyConfigOption.class)).findFirst();
            boolean bl = hide = option.isPresent() && option.get().hide();
            if (!parameter.isPresent() || hide) continue;
            MetricName name = new MetricName("config", "", field.getName());
            try {
                Object val;
                Class type = (Class)field.getGenericType();
                if (type.isAssignableFrom(String.class)) {
                    val = (String)field.get(this);
                    if (StringUtils.isNotBlank((String)val)) {
                        name = new TaggedMetricName(name.getGroup(), name.getName(), new String[]{"value", val});
                        ReportableConfig.reportGauge(1, name);
                        continue;
                    }
                    ReportableConfig.reportGauge(0, name);
                    continue;
                }
                if (type.isEnum()) {
                    val = field.get(this).toString();
                    name = new TaggedMetricName(name.getGroup(), name.getName(), new String[]{"value", val});
                    ReportableConfig.reportGauge(1, name);
                    continue;
                }
                if (type.isAssignableFrom(Boolean.TYPE)) {
                    val = (Boolean)field.get(this);
                    ReportableConfig.reportGauge(((Boolean)val).booleanValue() ? 1 : 0, name);
                    continue;
                }
                if (type.isAssignableFrom(Integer.TYPE)) {
                    ReportableConfig.reportGauge((int)((Integer)field.get(this)), name);
                    continue;
                }
                if (type.isAssignableFrom(Double.TYPE)) {
                    ReportableConfig.reportGauge((double)((Double)field.get(this)), name);
                    continue;
                }
                if (type.isAssignableFrom(Long.TYPE)) {
                    ReportableConfig.reportGauge((long)((Long)field.get(this)), name);
                    continue;
                }
                if (type.isAssignableFrom(Short.TYPE)) {
                    ReportableConfig.reportGauge((short)((Short)field.get(this)), name);
                    continue;
                }
                throw new RuntimeException("--- " + field.getType());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void detectModifiedOptions(Stream<String> args, List<Field> list) {
        args.forEach(arg -> {
            Field[] fields = this.getClass().getSuperclass().getDeclaredFields();
            list.addAll(Arrays.stream(fields).filter(field -> {
                String[] names;
                Optional<Parameter> parameter = Arrays.stream((Parameter[])field.getAnnotationsByType(Parameter.class)).findFirst();
                return parameter.isPresent() && Arrays.asList(names = parameter.get().names()).contains(arg);
            }).collect(Collectors.toList()));
        });
    }

    @JsonIgnore
    public JsonNode getJsonConfig() {
        TreeMap<Categories, Map> cfg = new TreeMap<Categories, Map>(Comparator.comparingInt(Categories::getOrder));
        for (Field field : this.getClass().getSuperclass().getDeclaredFields()) {
            Optional<ProxyConfigOption> option = Arrays.stream((ProxyConfigOption[])field.getAnnotationsByType(ProxyConfigOption.class)).findFirst();
            Optional<Parameter> parameter = Arrays.stream((Parameter[])field.getAnnotationsByType(Parameter.class)).findFirst();
            if (!parameter.isPresent()) continue;
            ProxyConfigOptionDescriptor data = new ProxyConfigOptionDescriptor();
            data.name = Arrays.stream(parameter.get().names()).max(Comparator.comparingInt(String::length)).orElseGet(() -> field.getName()).replaceAll("--", "");
            data.description = parameter.get().description();
            data.order = parameter.get().order() == -1 ? 99999 : parameter.get().order();
            try {
                Object val = field.get(this);
                if ((data.name.equals("token") || data.name.equals("cspAPIToken") || data.name.equals("cspAppId") || data.name.equals("cspAppSecret")) && val != null) {
                    String value = val.toString();
                    data.value = StringUtils.repeat((String)"*", (int)(value.length() - NUMBER_OF_VISIBLE_DIGITS)) + value.substring(value.length() - NUMBER_OF_VISIBLE_DIGITS);
                } else {
                    data.value = val != null ? val.toString() : "null";
                }
            }
            catch (IllegalAccessException e) {
                logger.severe(e.toString());
            }
            if (this.modifyByArgs.contains(field)) {
                data.modifyBy = "Argument";
            } else if (this.modifyByFile.contains(field)) {
                data.modifyBy = "Config file";
            }
            if (option.isPresent()) {
                Categories category = option.get().category();
                SubCategories subCategory = option.get().subCategory();
                if (option.get().hide()) continue;
                Set options = cfg.computeIfAbsent(category, s -> new TreeMap(Comparator.comparingInt(SubCategories::getOrder))).computeIfAbsent(subCategory, s -> new TreeSet());
                options.add(data);
                continue;
            }
            throw new RuntimeException("All options need 'ProxyConfigOption' annotation (" + data.name + ") !!");
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = (JsonNode)mapper.convertValue(cfg, JsonNode.class);
        return node;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void constructTenantInfoObject(@Nullable String appId, @Nullable String appSecret, @Nullable String cspOrgId, @Nullable String cspAPIToken, @Nonnull String wfToken, @Nonnull String server, @Nonnull String tenantName) {
        void var12_15;
        String BAD_CONFIG = "incorrect configuration, one (and only one) of these options are required: `token`, `cspAPIToken` or `cspAppId, cspAppSecret`" + ("central".equals(tenantName) ? "" : " for tenant `" + tenantName + "`");
        boolean isOAuthApp = StringUtils.isNotBlank((String)appId) || StringUtils.isNotBlank((String)appSecret);
        boolean isCSPAPIToken = StringUtils.isNotBlank((String)cspAPIToken);
        boolean isWFToken = StringUtils.isNotBlank((String)wfToken);
        if (Stream.of(isOAuthApp, isCSPAPIToken, isWFToken).filter(auth -> auth).count() != 1L) {
            throw new IllegalArgumentException(BAD_CONFIG);
        }
        if (isOAuthApp) {
            if (!StringUtils.isNotBlank((String)appId) || !StringUtils.isNotBlank((String)appSecret)) throw new IllegalArgumentException("To use server to server oauth, both `cspAppId` and `cspAppSecret` are required.");
            logger.info("TCSP OAuth server to server app credentials for further authentication. For the server " + server);
            TokenWorkerCSP tokenWorkerCSP = new TokenWorkerCSP(appId, appSecret, cspOrgId, server);
        } else if (isCSPAPIToken) {
            logger.info("CSP api token for further authentication. For the server " + server);
            TokenWorkerCSP tokenWorkerCSP = new TokenWorkerCSP(cspAPIToken, server);
        } else {
            logger.info("Wavefront api token for further authentication. For the server " + server);
            TokenWorkerWF tokenWorkerWF = new TokenWorkerWF(wfToken, server);
        }
        TokenManager.addTenant(tenantName, (TenantInfo)var12_15);
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class ProxyConfigOptionDescriptor
    implements Comparable {
        public String name;
        public String description;
        public String value;
        public String modifyBy;
        public int order = 0;

        public int compareTo(@NotNull Object o) {
            ProxyConfigOptionDescriptor other = (ProxyConfigOptionDescriptor)o;
            if (this.order == other.order) {
                return this.name.compareTo(other.name);
            }
            return Integer.compare(this.order, other.order);
        }
    }

    public static class TaskQueueLevelConverter
    implements IStringConverter<TaskQueueLevel> {
        public TaskQueueLevel convert(String value) {
            TaskQueueLevel convertedValue = TaskQueueLevel.fromString(value);
            if (convertedValue == null) {
                throw new ParameterException("Unknown task queue level: " + value);
            }
            return convertedValue;
        }
    }

    public static class TokenValidationMethodConverter
    implements IStringConverter<TokenValidationMethod> {
        public TokenValidationMethod convert(String value) {
            TokenValidationMethod convertedValue = TokenValidationMethod.fromString(value);
            if (convertedValue == null) {
                throw new ParameterException("Unknown token validation method value: " + value);
            }
            return convertedValue;
        }
    }
}

