/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent;

import com.google.common.collect.Maps;
import com.wavefront.agent.TenantInfo;
import com.wavefront.agent.TokenWorker;
import com.wavefront.agent.api.APIContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TokenManager {
    private static final Map<String, TenantInfo> multicastingTenantList = Maps.newHashMap();
    private static List<TokenWorker.Scheduled> scheduledWorkers = new ArrayList<TokenWorker.Scheduled>();
    private static List<TokenWorker.External> externalWorkers = new ArrayList<TokenWorker.External>();

    public static void addTenant(String tenantName, TenantInfo tokenWorker) {
        multicastingTenantList.put(tenantName, tokenWorker);
        if (tokenWorker instanceof TokenWorker.Scheduled) {
            scheduledWorkers.add((TokenWorker.Scheduled)((Object)tokenWorker));
        }
        if (tokenWorker instanceof TokenWorker.External) {
            externalWorkers.add((TokenWorker.External)((Object)tokenWorker));
        }
    }

    public static void start(APIContainer apiContainer) {
        externalWorkers.forEach(external -> external.setAPIContainer(apiContainer));
        scheduledWorkers.forEach(tenantInfo -> tenantInfo.run());
    }

    public static Map<String, TenantInfo> getMulticastingTenantList() {
        return multicastingTenantList;
    }

    public static void reset() {
        externalWorkers.clear();
        scheduledWorkers.clear();
        multicastingTenantList.clear();
    }
}

