/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.wavefront.agent.auth.TokenIntrospectionAuthenticator;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

class HttpGetTokenIntrospectionAuthenticator
extends TokenIntrospectionAuthenticator {
    private final HttpClient httpClient;
    private final String tokenIntrospectionServiceUrl;
    private final String tokenIntrospectionServiceAuthorizationHeader;
    private final Counter accessGrantedResponses = Metrics.newCounter((MetricName)new MetricName("auth", "", "access-granted"));
    private final Counter accessDeniedResponses = Metrics.newCounter((MetricName)new MetricName("auth", "", "access-denied"));

    HttpGetTokenIntrospectionAuthenticator(@Nonnull HttpClient httpClient, @Nonnull String tokenIntrospectionServiceUrl, @Nullable String tokenIntrospectionServiceAuthorizationHeader, int authResponseRefreshInterval, int authResponseMaxTtl) {
        this(httpClient, tokenIntrospectionServiceUrl, tokenIntrospectionServiceAuthorizationHeader, authResponseRefreshInterval, authResponseMaxTtl, System::currentTimeMillis);
    }

    @VisibleForTesting
    HttpGetTokenIntrospectionAuthenticator(@Nonnull HttpClient httpClient, @Nonnull String tokenIntrospectionServiceUrl, @Nullable String tokenIntrospectionServiceAuthorizationHeader, int authResponseRefreshInterval, int authResponseMaxTtl, @Nonnull Supplier<Long> timeSupplier) {
        super(authResponseRefreshInterval, authResponseMaxTtl, timeSupplier);
        Preconditions.checkNotNull((Object)httpClient, (Object)"httpClient must be set");
        Preconditions.checkNotNull((Object)tokenIntrospectionServiceUrl, (Object)"tokenIntrospectionServiceUrl parameter must be set");
        this.httpClient = httpClient;
        this.tokenIntrospectionServiceUrl = tokenIntrospectionServiceUrl;
        this.tokenIntrospectionServiceAuthorizationHeader = tokenIntrospectionServiceAuthorizationHeader;
    }

    @Override
    boolean callAuthService(@Nonnull String token) throws Exception {
        HttpGet request = new HttpGet(this.tokenIntrospectionServiceUrl.replace("{{token}}", token));
        if (this.tokenIntrospectionServiceAuthorizationHeader != null) {
            request.setHeader("Authorization", this.tokenIntrospectionServiceAuthorizationHeader);
        }
        HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
        int status = response.getStatusLine().getStatusCode();
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        if (status >= 200 && status < 300) {
            this.accessGrantedResponses.inc();
            return true;
        }
        this.accessDeniedResponses.inc();
        return false;
    }
}

