/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.handlers;

import com.google.common.util.concurrent.RateLimiter;
import com.wavefront.agent.formatter.DataFormat;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.handlers.SenderTask;
import com.wavefront.common.NamedThreadFactory;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.BurstRateTrackingCounter;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class AbstractReportableEntityHandler<T, U>
implements ReportableEntityHandler<T, U> {
    private static final Logger logger = Logger.getLogger(AbstractReportableEntityHandler.class.getCanonicalName());
    protected static final MetricsRegistry LOCAL_REGISTRY = new MetricsRegistry();
    protected static final String MULTICASTING_TENANT_TAG_KEY = "multicastingTenantName";
    private final Logger blockedItemsLogger;
    final HandlerKey handlerKey;
    protected final Counter receivedCounter;
    protected final Counter attemptedCounter;
    protected Counter blockedCounter;
    protected Counter rejectedCounter;
    final RateLimiter blockedItemsLimiter;
    final Function<T, String> serializer;
    final Map<String, Collection<SenderTask<U>>> senderTaskMap;
    protected final boolean isMulticastingActive;
    final boolean reportReceivedStats;
    final String rateUnit;
    final BurstRateTrackingCounter receivedStats;
    final BurstRateTrackingCounter deliveredStats;
    private final ScheduledThreadPoolExecutor timer;
    private final AtomicLong roundRobinCounter = new AtomicLong();
    protected final MetricsRegistry registry;
    protected final String metricPrefix;
    private final RateLimiter noDataStatsRateLimiter = RateLimiter.create((double)0.016666666666666666);

    AbstractReportableEntityHandler(HandlerKey handlerKey, int blockedItemsPerBatch, Function<T, String> serializer, @Nullable Map<String, Collection<SenderTask<U>>> senderTaskMap, boolean reportReceivedStats, @Nullable BiConsumer<String, Long> receivedRateSink, @Nullable Logger blockedItemsLogger) {
        this.handlerKey = handlerKey;
        this.blockedItemsLimiter = blockedItemsPerBatch == 0 ? null : RateLimiter.create((double)((double)blockedItemsPerBatch / 10.0));
        this.serializer = serializer;
        this.senderTaskMap = senderTaskMap == null ? new HashMap<String, Collection<SenderTask<U>>>() : new HashMap<String, Collection<SenderTask<U>>>(senderTaskMap);
        this.isMulticastingActive = this.senderTaskMap.size() > 1;
        this.reportReceivedStats = reportReceivedStats;
        this.rateUnit = handlerKey.getEntityType().getRateUnit();
        this.blockedItemsLogger = blockedItemsLogger;
        this.registry = reportReceivedStats ? Metrics.defaultRegistry() : LOCAL_REGISTRY;
        this.metricPrefix = handlerKey.toString();
        MetricName receivedMetricName = new MetricName(this.metricPrefix, "", "received");
        MetricName deliveredMetricName = new MetricName(this.metricPrefix, "", "delivered");
        this.receivedCounter = this.registry.newCounter(receivedMetricName);
        this.attemptedCounter = Metrics.newCounter((MetricName)new MetricName(this.metricPrefix, "", "sent"));
        this.receivedStats = new BurstRateTrackingCounter(receivedMetricName, this.registry, 1000);
        this.deliveredStats = new BurstRateTrackingCounter(deliveredMetricName, this.registry, 1000);
        this.registry.newGauge(new MetricName(this.metricPrefix + ".received", "", "max-burst-rate"), (Gauge)new Gauge<Double>(){

            public Double value() {
                return AbstractReportableEntityHandler.this.receivedStats.getMaxBurstRateAndClear();
            }
        });
        this.timer = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("stats-output"));
        if (receivedRateSink != null) {
            this.timer.scheduleAtFixedRate(() -> {
                try {
                    for (String tenantName : senderTaskMap.keySet()) {
                        receivedRateSink.accept(tenantName, this.receivedStats.getCurrentRate());
                    }
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "receivedRateSink", e);
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }
        this.timer.scheduleAtFixedRate(() -> {
            try {
                this.printStats();
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "printStats", e);
            }
        }, 10L, 10L, TimeUnit.SECONDS);
        if (reportReceivedStats) {
            this.timer.scheduleAtFixedRate(() -> {
                try {
                    this.printTotal();
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "printTotal", e);
                }
            }, 1L, 1L, TimeUnit.MINUTES);
        }
    }

    protected void initializeCounters() {
        this.blockedCounter = this.registry.newCounter(new MetricName(this.metricPrefix, "", "blocked"));
        this.rejectedCounter = this.registry.newCounter(new MetricName(this.metricPrefix, "", "rejected"));
    }

    @Override
    public void reject(@Nullable T item, @Nullable String message) {
        this.blockedCounter.inc();
        this.rejectedCounter.inc();
        if (item != null && this.blockedItemsLogger != null) {
            this.blockedItemsLogger.warning(this.serializer.apply(item));
        }
        if (message != null && this.blockedItemsLimiter != null && this.blockedItemsLimiter.tryAcquire()) {
            logger.info("[" + this.handlerKey.getHandle() + "] blocked input: [" + message + "]");
        }
    }

    @Override
    public void reject(@Nonnull String line, @Nullable String message) {
        this.blockedCounter.inc();
        this.rejectedCounter.inc();
        if (this.blockedItemsLogger != null) {
            this.blockedItemsLogger.warning(line);
        }
        if (message != null && this.blockedItemsLimiter != null && this.blockedItemsLimiter.tryAcquire()) {
            logger.info("[" + this.handlerKey.getHandle() + "] blocked input: [" + message + "]");
        }
    }

    @Override
    public void block(T item) {
        this.blockedCounter.inc();
        if (this.blockedItemsLogger != null) {
            this.blockedItemsLogger.info(this.serializer.apply(item));
        }
    }

    @Override
    public void block(@Nullable T item, @Nullable String message) {
        this.blockedCounter.inc();
        if (item != null && this.blockedItemsLogger != null) {
            this.blockedItemsLogger.info(this.serializer.apply(item));
        }
        if (message != null && this.blockedItemsLogger != null) {
            this.blockedItemsLogger.info(message);
        }
    }

    @Override
    public void report(T item) {
        try {
            this.attemptedCounter.inc();
            this.reportInternal(item);
        }
        catch (IllegalArgumentException e) {
            this.reject(item, e.getMessage() + " (" + this.serializer.apply(item) + ")");
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "WF-500 Uncaught exception when handling input (" + this.serializer.apply(item) + ")", ex);
        }
    }

    @Override
    public void shutdown() {
        if (this.timer != null) {
            this.timer.shutdown();
        }
    }

    @Override
    public void setLogFormat(DataFormat format) {
        throw new UnsupportedOperationException();
    }

    abstract void reportInternal(T var1);

    protected Counter getReceivedCounter() {
        return this.receivedCounter;
    }

    protected SenderTask<U> getTask(String tenantName) {
        if (this.senderTaskMap == null) {
            throw new IllegalStateException("getTask() cannot be called on null senderTasks");
        }
        if (!this.senderTaskMap.containsKey(tenantName)) {
            return null;
        }
        ArrayList<SenderTask<U>> senderTasks = new ArrayList<SenderTask<U>>(this.senderTaskMap.get(tenantName));
        int nextTaskId = (int)(this.roundRobinCounter.getAndIncrement() % (long)senderTasks.size());
        long worstScore = 0L;
        int worstTaskId = 0;
        for (int i = 0; i < senderTasks.size(); ++i) {
            long score = ((SenderTask)senderTasks.get(i)).getTaskRelativeScore();
            if (score <= worstScore) continue;
            worstScore = score;
            worstTaskId = i;
        }
        if (nextTaskId == worstTaskId) {
            nextTaskId = (int)(this.roundRobinCounter.getAndIncrement() % (long)senderTasks.size());
        }
        return (SenderTask)senderTasks.get(nextTaskId);
    }

    protected void printStats() {
        if (this.receivedStats.getFiveMinuteCount() == 0L && !this.noDataStatsRateLimiter.tryAcquire()) {
            return;
        }
        if (this.reportReceivedStats) {
            logger.info("[" + this.handlerKey.getHandle() + "] " + this.handlerKey.getEntityType().toCapitalizedString() + " received rate: " + this.receivedStats.getOneMinutePrintableRate() + " " + this.rateUnit + " (1 min), " + this.receivedStats.getFiveMinutePrintableRate() + " " + this.rateUnit + " (5 min), " + this.receivedStats.getCurrentRate() + " " + this.rateUnit + " (current).");
        }
        if (this.deliveredStats.getFiveMinuteCount() == 0L) {
            return;
        }
        logger.info("[" + this.handlerKey.getHandle() + "] " + this.handlerKey.getEntityType().toCapitalizedString() + " delivered rate: " + this.deliveredStats.getOneMinutePrintableRate() + " " + this.rateUnit + " (1 min), " + this.deliveredStats.getFiveMinutePrintableRate() + " " + this.rateUnit + " (5 min)");
    }

    protected void printTotal() {
        logger.info("[" + this.handlerKey.getHandle() + "] " + this.handlerKey.getEntityType().toCapitalizedString() + " processed since start: " + this.attemptedCounter.count() + "; blocked: " + this.blockedCounter.count());
    }
}

