/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.handlers;

import com.wavefront.agent.handlers.AbstractReportableEntityHandler;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.SenderTask;
import com.wavefront.ingester.SpanLogsSerializer;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import wavefront.report.SpanLogs;

public class SpanLogsHandlerImpl
extends AbstractReportableEntityHandler<SpanLogs, String> {
    private final Logger validItemsLogger;

    SpanLogsHandlerImpl(HandlerKey handlerKey, int blockedItemsPerBatch, @Nullable Map<String, Collection<SenderTask<String>>> senderTaskMap, @Nullable BiConsumer<String, Long> receivedRateSink, @Nullable Logger blockedItemLogger, @Nullable Logger validItemsLogger) {
        super(handlerKey, blockedItemsPerBatch, new SpanLogsSerializer(), senderTaskMap, true, receivedRateSink, blockedItemLogger);
        super.initializeCounters();
        this.validItemsLogger = validItemsLogger;
    }

    @Override
    protected void reportInternal(SpanLogs spanLogs) {
        String strSpanLogs = (String)this.serializer.apply(spanLogs);
        if (strSpanLogs != null) {
            this.getTask("central").add(strSpanLogs);
            this.getReceivedCounter().inc();
            if (this.validItemsLogger != null) {
                this.validItemsLogger.info(strSpanLogs);
            }
        }
    }
}

