/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.wavefront.agent.LogsUtil;
import com.wavefront.agent.auth.TokenAuthenticator;
import com.wavefront.agent.channel.ChannelUtils;
import com.wavefront.agent.channel.HealthCheckManager;
import com.wavefront.agent.formatter.DataFormat;
import com.wavefront.agent.listeners.AbstractPortUnificationHandler;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Histogram;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

@ChannelHandler.Sharable
public abstract class AbstractLineDelimitedHandler
extends AbstractPortUnificationHandler {
    public static final ObjectMapper JSON_PARSER = new ObjectMapper();
    public static final String LOG_EVENTS_KEY = "logEvents";

    public AbstractLineDelimitedHandler(@Nullable TokenAuthenticator tokenAuthenticator, @Nullable HealthCheckManager healthCheckManager, @Nullable String handle) {
        super(tokenAuthenticator, healthCheckManager, handle);
    }

    @Override
    protected void handleHttpMessage(ChannelHandlerContext ctx, FullHttpRequest request) {
        HttpResponseStatus status;
        StringBuilder output = new StringBuilder();
        try {
            DataFormat format = this.getFormat(request);
            this.processBatchMetrics(ctx, request, format);
            Iterable<String> lines = format == DataFormat.LOGS_JSON_ARR ? AbstractLineDelimitedHandler.extractLogsWithJsonArrayFormat(request) : (format == DataFormat.LOGS_JSON_LINES ? this.extractLogsWithJsonLinesFormat(request) : (format == DataFormat.LOGS_JSON_CLOUDWATCH ? this.extractLogsWithJsonCloudwatchFormat(request) : this.extractLogsWithDefaultFormat(request)));
            lines.forEach(line -> this.processLine(ctx, (String)line, format));
            status = HttpResponseStatus.ACCEPTED;
        }
        catch (Exception e) {
            status = HttpResponseStatus.BAD_REQUEST;
            output.append(ChannelUtils.errorMessageWithRootCause(e));
            this.logWarning("WF-300: Failed to handle HTTP POST", e, ctx);
        }
        ChannelUtils.writeHttpResponse(ctx, status, (Object)output, (HttpMessage)request);
    }

    private Iterable<String> extractLogsWithDefaultFormat(FullHttpRequest request) {
        return Splitter.on((char)'\n').trimResults().omitEmptyStrings().split((CharSequence)request.content().toString(CharsetUtil.UTF_8));
    }

    private Iterable<String> extractLogsWithJsonCloudwatchFormat(FullHttpRequest request) throws IOException {
        JsonNode node = (JsonNode)JSON_PARSER.readerFor(JsonNode.class).readValue(request.content().toString(CharsetUtil.UTF_8));
        return AbstractLineDelimitedHandler.extractLogsFromArray(node.get(LOG_EVENTS_KEY).toString());
    }

    @NotNull
    private static List<String> extractLogsFromArray(String content) throws JsonProcessingException {
        return ((List)JSON_PARSER.readValue(content, (TypeReference)new TypeReference<List<Map<String, Object>>>(){})).stream().map(json -> {
            try {
                return JSON_PARSER.writeValueAsString(json);
            }
            catch (JsonProcessingException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Iterable<String> extractLogsWithJsonLinesFormat(FullHttpRequest request) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        MappingIterator it = JSON_PARSER.readerFor(JsonNode.class).readValues(request.content().toString(CharsetUtil.UTF_8));
        while (it.hasNextValue()) {
            lines.add(JSON_PARSER.writeValueAsString(it.nextValue()));
        }
        return lines;
    }

    @NotNull
    private static Iterable<String> extractLogsWithJsonArrayFormat(FullHttpRequest request) throws IOException {
        return AbstractLineDelimitedHandler.extractLogsFromArray(request.content().toString(CharsetUtil.UTF_8));
    }

    @Override
    protected void handlePlainTextMessage(ChannelHandlerContext ctx, @Nonnull String message) {
        String trimmedMessage = message.trim();
        if (trimmedMessage.isEmpty()) {
            return;
        }
        this.processLine(ctx, trimmedMessage, null);
    }

    @Nullable
    protected abstract DataFormat getFormat(FullHttpRequest var1);

    protected abstract void processLine(ChannelHandlerContext var1, @Nonnull String var2, @Nullable DataFormat var3);

    protected void processBatchMetrics(ChannelHandlerContext ctx, FullHttpRequest request, @Nullable DataFormat format) {
        if (LogsUtil.LOGS_DATA_FORMATS.contains((Object)format)) {
            Histogram receivedLogsBatches = LogsUtil.getOrCreateLogsHistogramFromRegistry(Metrics.defaultRegistry(), format, "logs." + this.handle, "received.batches");
            receivedLogsBatches.update(request.content().toString(CharsetUtil.UTF_8).length());
        }
    }
}

