/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners;

import com.wavefront.agent.auth.TokenAuthenticator;
import com.wavefront.agent.channel.ChannelUtils;
import com.wavefront.agent.channel.HealthCheckManager;
import com.wavefront.agent.channel.NoopHealthCheckManager;
import com.wavefront.common.TaggedMetricName;
import com.wavefront.common.Utils;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

@ChannelHandler.Sharable
public abstract class AbstractPortUnificationHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger logger = Logger.getLogger(AbstractPortUnificationHandler.class.getCanonicalName());
    protected final Supplier<Histogram> httpRequestHandleDuration;
    protected final Supplier<Counter> requestsDiscarded;
    protected final Supplier<Counter> pointsDiscarded;
    protected final Supplier<Gauge<Long>> httpRequestsInFlightGauge;
    protected final AtomicLong httpRequestsInFlight = new AtomicLong();
    protected final String handle;
    protected final TokenAuthenticator tokenAuthenticator;
    protected final HealthCheckManager healthCheck;

    public AbstractPortUnificationHandler(@Nullable TokenAuthenticator tokenAuthenticator, @Nullable HealthCheckManager healthCheckManager, @Nullable String handle) {
        this.tokenAuthenticator = (TokenAuthenticator)ObjectUtils.firstNonNull((Object[])new TokenAuthenticator[]{tokenAuthenticator, TokenAuthenticator.DUMMY_AUTHENTICATOR});
        this.healthCheck = healthCheckManager == null ? new NoopHealthCheckManager() : healthCheckManager;
        this.handle = (String)ObjectUtils.firstNonNull((Object[])new String[]{handle, "unknown"});
        String portNumber = this.handle.replaceAll("^\\d", "");
        if (NumberUtils.isNumber((String)portNumber)) {
            this.healthCheck.setHealthy(Integer.parseInt(portNumber));
        }
        this.httpRequestHandleDuration = Utils.lazySupplier(() -> Metrics.newHistogram((MetricName)new TaggedMetricName("listeners", "http-requests.duration-nanos", new String[]{"port", this.handle})));
        this.requestsDiscarded = Utils.lazySupplier(() -> Metrics.newCounter((MetricName)new TaggedMetricName("listeners", "http-requests.discarded", new String[]{"port", this.handle})));
        this.pointsDiscarded = Utils.lazySupplier(() -> Metrics.newCounter((MetricName)new TaggedMetricName("listeners", "items-discarded", new String[]{"port", this.handle})));
        this.httpRequestsInFlightGauge = Utils.lazySupplier(() -> Metrics.newGauge((MetricName)new TaggedMetricName("listeners", "http-requests.active", new String[]{"port", this.handle}), (Gauge)new Gauge<Long>(){

            public Long value() {
                return AbstractPortUnificationHandler.this.httpRequestsInFlight.get();
            }
        }));
    }

    protected abstract void handleHttpMessage(ChannelHandlerContext var1, FullHttpRequest var2) throws URISyntaxException;

    protected abstract void handlePlainTextMessage(ChannelHandlerContext var1, @Nonnull String var2);

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof TooLongFrameException) {
            this.logWarning("Received line is too long, consider increasing pushListenerMaxReceivedLength", cause, ctx);
            return;
        }
        if (cause instanceof DecompressionException) {
            this.logWarning("Decompression error", cause, ctx);
            ChannelUtils.writeHttpResponse(ctx, HttpResponseStatus.BAD_REQUEST, (Object)("Decompression error: " + cause.getMessage()), false);
            return;
        }
        if (cause instanceof IOException && cause.getMessage().contains("Connection reset by peer")) {
            return;
        }
        this.logWarning("Handler failed", cause, ctx);
        logger.log(Level.WARNING, "Unexpected error: ", cause);
    }

    protected String extractToken(FullHttpRequest request) {
        String token = ((String)ObjectUtils.firstNonNull((Object[])new String[]{request.headers().getAsString((CharSequence)"X-AUTH-TOKEN"), request.headers().getAsString((CharSequence)"Authorization"), ""})).replaceAll("^Bearer ", "").trim();
        Optional<NameValuePair> tokenParam = URLEncodedUtils.parse((URI)URI.create(request.uri()), (Charset)CharsetUtil.UTF_8).stream().filter(x -> x.getName().equals("t") || x.getName().equals("token") || x.getName().equals("api_key")).findFirst();
        if (tokenParam.isPresent()) {
            token = tokenParam.get().getValue();
        }
        return token;
    }

    protected boolean authorized(ChannelHandlerContext ctx, FullHttpRequest request) {
        String token;
        if (this.tokenAuthenticator.authRequired() && !this.tokenAuthenticator.authorize(token = this.extractToken(request))) {
            ChannelUtils.writeHttpResponse(ctx, HttpResponseStatus.UNAUTHORIZED, (Object)"401 Unauthorized\n", (HttpMessage)request);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, Object message) {
        block16: {
            if (message instanceof String) {
                try {
                    if (this.tokenAuthenticator.authRequired()) {
                        this.pointsDiscarded.get().inc();
                        logger.warning("Input discarded: plaintext protocol is not supported on port " + this.handle + " (authentication enabled)");
                        return;
                    }
                    this.handlePlainTextMessage(ctx, (String)message);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logWarning("Failed to handle message", e, ctx);
                }
            } else if (message instanceof FullHttpRequest) {
                FullHttpRequest request = (FullHttpRequest)message;
                try {
                    HttpResponse healthCheckResponse = this.healthCheck.getHealthCheckResponse(ctx, request);
                    if (healthCheckResponse != null) {
                        ChannelUtils.writeHttpResponse(ctx, healthCheckResponse, (HttpMessage)request);
                        return;
                    }
                    if (!this.getHttpEnabled()) {
                        this.requestsDiscarded.get().inc();
                        logger.warning("Inbound HTTP request discarded: HTTP disabled on port " + this.handle);
                        return;
                    }
                    if (!this.authorized(ctx, request)) break block16;
                    this.httpRequestsInFlightGauge.get();
                    this.httpRequestsInFlight.incrementAndGet();
                    long startTime = System.nanoTime();
                    if (request.method() == HttpMethod.OPTIONS) {
                        ChannelUtils.writeHttpResponse(ctx, (HttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NO_CONTENT, Unpooled.EMPTY_BUFFER), (HttpMessage)request);
                        return;
                    }
                    try {
                        this.handleHttpMessage(ctx, request);
                    }
                    finally {
                        this.httpRequestsInFlight.decrementAndGet();
                    }
                    this.httpRequestHandleDuration.get().update(System.nanoTime() - startTime);
                }
                catch (URISyntaxException e) {
                    ChannelUtils.writeHttpResponse(ctx, HttpResponseStatus.BAD_REQUEST, (Object)ChannelUtils.errorMessageWithRootCause(e), (HttpMessage)request);
                    logger.warning(ChannelUtils.formatErrorMessage("WF-300: Request URI '" + request.uri() + "' cannot be parsed", e, ctx));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logWarning("Failed to handle message", e, ctx);
                }
            } else {
                this.logWarning("Received unexpected message type " + (message == null ? "" : message.getClass().getName()), null, ctx);
            }
        }
    }

    protected boolean getHttpEnabled() {
        return true;
    }

    protected void logWarning(String message, @Nullable Throwable e, @Nullable ChannelHandlerContext ctx) {
        logger.warning(ChannelUtils.formatErrorMessage(message, e, ctx));
    }
}

