/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.wavefront.agent.auth.TokenAuthenticatorBuilder;
import com.wavefront.agent.channel.ChannelUtils;
import com.wavefront.agent.channel.HealthCheckManager;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.handlers.ReportableEntityHandlerFactory;
import com.wavefront.agent.listeners.AbstractHttpOnlyHandler;
import com.wavefront.agent.preprocessor.ReportableEntityPreprocessor;
import com.wavefront.common.Clock;
import com.wavefront.common.NamedThreadFactory;
import com.wavefront.common.TaggedMetricName;
import com.wavefront.data.ReportableEntityType;
import com.wavefront.ingester.ReportPointSerializer;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import datadog.agentpayload.AgentPayload;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import wavefront.report.ReportPoint;

@ChannelHandler.Sharable
public class DataDogPortUnificationHandler
extends AbstractHttpOnlyHandler {
    private static final Logger logger = Logger.getLogger(DataDogPortUnificationHandler.class.getCanonicalName());
    private static final Logger blockedPointsLogger = Logger.getLogger("RawBlockedPoints");
    private static final Pattern INVALID_METRIC_CHARACTERS = Pattern.compile("[^-_\\.\\dA-Za-z]");
    private static final Pattern INVALID_TAG_CHARACTERS = Pattern.compile("[^-_:\\.\\\\/\\dA-Za-z]");
    private static final Map<String, String> SYSTEM_METRICS = ImmutableMap.builder().put((Object)"system.cpu.guest", (Object)"cpuGuest").put((Object)"system.cpu.idle", (Object)"cpuIdle").put((Object)"system.cpu.stolen", (Object)"cpuStolen").put((Object)"system.cpu.system", (Object)"cpuSystem").put((Object)"system.cpu.user", (Object)"cpuUser").put((Object)"system.cpu.wait", (Object)"cpuWait").put((Object)"system.mem.buffers", (Object)"memBuffers").put((Object)"system.mem.cached", (Object)"memCached").put((Object)"system.mem.page_tables", (Object)"memPageTables").put((Object)"system.mem.shared", (Object)"memShared").put((Object)"system.mem.slab", (Object)"memSlab").put((Object)"system.mem.free", (Object)"memPhysFree").put((Object)"system.mem.pct_usable", (Object)"memPhysPctUsable").put((Object)"system.mem.total", (Object)"memPhysTotal").put((Object)"system.mem.usable", (Object)"memPhysUsable").put((Object)"system.mem.used", (Object)"memPhysUsed").put((Object)"system.swap.cached", (Object)"memSwapCached").put((Object)"system.swap.free", (Object)"memSwapFree").put((Object)"system.swap.pct_free", (Object)"memSwapPctFree").put((Object)"system.swap.total", (Object)"memSwapTotal").put((Object)"system.swap.used", (Object)"memSwapUsed").build();
    private final Histogram httpRequestSize;
    private final ReportableEntityHandler<ReportPoint, String> pointHandler;
    private final boolean synchronousMode;
    private final boolean processSystemMetrics;
    private final boolean processServiceChecks;
    @Nullable
    private final HttpClient requestRelayClient;
    @Nullable
    private final String requestRelayTarget;
    @Nullable
    private final Supplier<ReportableEntityPreprocessor> preprocessorSupplier;
    private final ObjectMapper jsonParser;
    private final Cache<String, Map<String, String>> tagsCache = Caffeine.newBuilder().expireAfterWrite(6L, TimeUnit.HOURS).maximumSize(100000L).build();
    private final LoadingCache<Integer, Counter> httpStatusCounterCache;
    private final ScheduledThreadPoolExecutor threadpool;

    public DataDogPortUnificationHandler(String handle, HealthCheckManager healthCheckManager, ReportableEntityHandlerFactory handlerFactory, int fanout, boolean synchronousMode, boolean processSystemMetrics, boolean processServiceChecks, @Nullable HttpClient requestRelayClient, @Nullable String requestRelayTarget, @Nullable Supplier<ReportableEntityPreprocessor> preprocessor) {
        this(handle, healthCheckManager, handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.POINT, handle)), fanout, synchronousMode, processSystemMetrics, processServiceChecks, requestRelayClient, requestRelayTarget, preprocessor);
    }

    @VisibleForTesting
    protected DataDogPortUnificationHandler(String handle, HealthCheckManager healthCheckManager, ReportableEntityHandler<ReportPoint, String> pointHandler, int fanout, boolean synchronousMode, boolean processSystemMetrics, boolean processServiceChecks, @Nullable HttpClient requestRelayClient, @Nullable String requestRelayTarget, @Nullable Supplier<ReportableEntityPreprocessor> preprocessor) {
        super(TokenAuthenticatorBuilder.create().build(), healthCheckManager, handle);
        this.pointHandler = pointHandler;
        this.threadpool = new ScheduledThreadPoolExecutor(fanout, (ThreadFactory)new NamedThreadFactory("dd-relay"));
        this.synchronousMode = synchronousMode;
        this.processSystemMetrics = processSystemMetrics;
        this.processServiceChecks = processServiceChecks;
        this.requestRelayClient = requestRelayClient;
        this.requestRelayTarget = requestRelayTarget;
        this.preprocessorSupplier = preprocessor;
        this.jsonParser = new ObjectMapper();
        this.httpRequestSize = Metrics.newHistogram((MetricName)new TaggedMetricName("listeners", "http-requests.payload-points", new String[]{"port", handle}));
        this.httpStatusCounterCache = Caffeine.newBuilder().build(status -> Metrics.newCounter((MetricName)new TaggedMetricName("listeners", "http-relay.status." + status + ".count", new String[]{"port", handle})));
        Metrics.newGauge((MetricName)new TaggedMetricName("listeners", "tags-cache-size", new String[]{"port", handle}), (Gauge)new Gauge<Long>(){

            public Long value() {
                return DataDogPortUnificationHandler.this.tagsCache.estimatedSize();
            }
        });
        Metrics.newGauge((MetricName)new TaggedMetricName("listeners", "http-relay.threadpool.queue-size", new String[]{"port", handle}), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return DataDogPortUnificationHandler.this.threadpool.getQueue().size();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleHttpMessage(ChannelHandlerContext ctx, FullHttpRequest request) throws URISyntaxException {
        String path;
        StringBuilder output = new StringBuilder();
        AtomicInteger pointsPerRequest = new AtomicInteger();
        URI uri = new URI(request.uri());
        HttpResponseStatus status = HttpResponseStatus.ACCEPTED;
        byte[] bodyBytes = new byte[request.content().readableBytes()];
        request.content().readBytes(bodyBytes);
        if (this.requestRelayClient != null && this.requestRelayTarget != null && request.method() == HttpMethod.POST) {
            Histogram requestRelayDuration = Metrics.newHistogram((MetricName)new TaggedMetricName("listeners", "http-relay.duration-nanos", new String[]{"port", this.handle}));
            long startNanos = System.nanoTime();
            try {
                String outgoingUrl = this.requestRelayTarget.replaceFirst("/*$", "") + request.uri();
                HttpPost outgoingRequest = new HttpPost(outgoingUrl);
                request.headers().forEach(header -> {
                    if (!((String)header.getKey()).equalsIgnoreCase("Content-Length")) {
                        outgoingRequest.addHeader((String)header.getKey(), (String)header.getValue());
                    }
                });
                outgoingRequest.setEntity((HttpEntity)new ByteArrayEntity(bodyBytes));
                if (this.synchronousMode) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Relaying incoming HTTP request to " + outgoingUrl);
                    }
                    HttpResponse response = this.requestRelayClient.execute((HttpUriRequest)outgoingRequest);
                    int httpStatusCode = response.getStatusLine().getStatusCode();
                    ((Counter)this.httpStatusCounterCache.get((Object)httpStatusCode)).inc();
                    if (httpStatusCode < 200 || httpStatusCode >= 300) {
                        ChannelUtils.writeHttpResponse(ctx, HttpResponseStatus.valueOf((int)httpStatusCode), (Object)EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"), (HttpMessage)request);
                        return;
                    }
                } else {
                    this.threadpool.submit(() -> {
                        try {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Relaying incoming HTTP request (async) to " + outgoingUrl);
                            }
                            HttpResponse response = this.requestRelayClient.execute((HttpUriRequest)outgoingRequest);
                            int httpStatusCode = response.getStatusLine().getStatusCode();
                            ((Counter)this.httpStatusCounterCache.get((Object)httpStatusCode)).inc();
                            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, "Unable to relay request to " + this.requestRelayTarget + ": " + e.getMessage(), e);
                            Metrics.newCounter((MetricName)new TaggedMetricName("listeners", "http-relay.failed", new String[]{"port", this.handle})).inc();
                        }
                    });
                }
            }
            catch (IOException e) {
                logger.warning("Unable to relay request to " + this.requestRelayTarget + ": " + e.getMessage());
                Metrics.newCounter((MetricName)new TaggedMetricName("listeners", "http-relay.failed", new String[]{"port", this.handle})).inc();
                ChannelUtils.writeHttpResponse(ctx, HttpResponseStatus.BAD_GATEWAY, (Object)("Unable to relay request: " + e.getMessage()), (HttpMessage)request);
                return;
            }
            finally {
                requestRelayDuration.update(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos));
            }
        }
        switch (path = uri.getPath().endsWith("/") ? uri.getPath() : uri.getPath() + "/") {
            case "/api/v2/series/": {
                try {
                    AgentPayload.MetricPayload obj = AgentPayload.MetricPayload.parseFrom(bodyBytes);
                    this.reportMetrics(obj, pointsPerRequest, output::append);
                }
                catch (IOException e) {
                    ChannelUtils.writeHttpResponse(ctx, HttpResponseStatus.BAD_REQUEST, (Object)output, (HttpMessage)request);
                    throw new RuntimeException(e);
                }
                ChannelUtils.writeHttpResponse(ctx, status, (Object)output, (HttpMessage)request);
                break;
            }
            case "/api/v1/series/": {
                String requestBody;
                try {
                    requestBody = new String(bodyBytes, StandardCharsets.UTF_8);
                    status = this.reportMetrics(this.jsonParser.readTree(requestBody), pointsPerRequest, output::append);
                }
                catch (Exception e) {
                    status = HttpResponseStatus.BAD_REQUEST;
                    output.append(ChannelUtils.errorMessageWithRootCause(e));
                    this.logWarning("WF-300: Failed to handle /api/v1/series request", e, ctx);
                }
                this.httpRequestSize.update(pointsPerRequest.intValue());
                ChannelUtils.writeHttpResponse(ctx, status, (Object)output, (HttpMessage)request);
                break;
            }
            case "/api/v1/check_run/": {
                String requestBody;
                if (!this.processServiceChecks) {
                    Metrics.newCounter((MetricName)new TaggedMetricName("listeners", "http-requests.ignored", new String[]{"port", this.handle})).inc();
                    ChannelUtils.writeHttpResponse(ctx, HttpResponseStatus.ACCEPTED, (Object)output, (HttpMessage)request);
                    return;
                }
                try {
                    requestBody = new String(bodyBytes, StandardCharsets.UTF_8);
                    this.reportChecks(this.jsonParser.readTree(requestBody), pointsPerRequest, output::append);
                }
                catch (Exception e) {
                    status = HttpResponseStatus.BAD_REQUEST;
                    output.append(ChannelUtils.errorMessageWithRootCause(e));
                    this.logWarning("WF-300: Failed to handle /api/v1/check_run request", e, ctx);
                }
                ChannelUtils.writeHttpResponse(ctx, status, (Object)output, (HttpMessage)request);
                break;
            }
            case "/api/v1/validate/": {
                ChannelUtils.writeHttpResponse(ctx, HttpResponseStatus.OK, (Object)output, (HttpMessage)request);
                break;
            }
            case "/intake/": {
                String requestBody;
                try {
                    requestBody = new String(bodyBytes, StandardCharsets.UTF_8);
                    status = this.processMetadataAndSystemMetrics(this.jsonParser.readTree(requestBody), this.processSystemMetrics, pointsPerRequest, output::append);
                }
                catch (Exception e) {
                    status = HttpResponseStatus.BAD_REQUEST;
                    output.append(ChannelUtils.errorMessageWithRootCause(e));
                    this.logWarning("WF-300: Failed to handle /intake request", e, ctx);
                }
                this.httpRequestSize.update(pointsPerRequest.intValue());
                ChannelUtils.writeHttpResponse(ctx, status, (Object)output, (HttpMessage)request);
                break;
            }
            default: {
                ChannelUtils.writeHttpResponse(ctx, HttpResponseStatus.NO_CONTENT, (Object)output, (HttpMessage)request);
                this.logWarning("WF-300: Unexpected path '" + request.uri() + "', returning HTTP 204", null, ctx);
            }
        }
    }

    private HttpResponseStatus reportMetrics(AgentPayload.MetricPayload payload, AtomicInteger pointCounter, Consumer<String> outputConsumer) {
        HttpResponseStatus worstStatus = HttpResponseStatus.ACCEPTED;
        for (AgentPayload.MetricPayload.MetricSeries metric : payload.getSeriesList()) {
            HttpResponseStatus latestStatus = this.reportMetric(metric, pointCounter, outputConsumer);
            if (latestStatus.compareTo(worstStatus) <= 0) continue;
            worstStatus = latestStatus;
        }
        return worstStatus;
    }

    private HttpResponseStatus reportMetric(AgentPayload.MetricPayload.MetricSeries metric, AtomicInteger pointCounter, Consumer<String> outputConsumer) {
        if (metric == null) {
            this.error("Skipping - series object null.", outputConsumer);
            return HttpResponseStatus.BAD_REQUEST;
        }
        try {
            HashMap<String, String> tags = new HashMap<String, String>();
            String metricName = INVALID_METRIC_CHARACTERS.matcher(metric.getMetric()).replaceAll("_");
            String hostName = "unknown";
            for (AgentPayload.MetricPayload.Resource resource : metric.getResourcesList()) {
                if (resource.getType().equalsIgnoreCase("host")) {
                    hostName = resource.getName();
                    continue;
                }
                if (!resource.getType().equalsIgnoreCase("device")) continue;
                tags.put("device", resource.getName());
            }
            Map systemTags = (Map)this.tagsCache.getIfPresent((Object)hostName);
            if (systemTags != null) {
                tags.putAll(systemTags);
            }
            metric.getTagsList().stream().forEach(tag -> this.extractTag((String)tag, (Map<String, String>)tags));
            int interval = 1;
            if (metric.getTypeValue() == 2) {
                interval = Math.toIntExact(metric.getInterval());
            }
            for (AgentPayload.MetricPayload.MetricPoint point : metric.getPointsList()) {
                this.reportValue(metricName, hostName, tags, point.getValue(), point.getTimestamp() * 1000L, pointCounter, interval);
            }
            return HttpResponseStatus.ACCEPTED;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to add metric", e);
            outputConsumer.accept("Failed to add metric");
            return HttpResponseStatus.BAD_REQUEST;
        }
    }

    private HttpResponseStatus reportMetrics(JsonNode metrics, @Nullable AtomicInteger pointCounter, Consumer<String> outputConsumer) {
        if (metrics == null || !metrics.isObject()) {
            this.error("Empty or malformed /api/v1/series payload - ignoring", outputConsumer);
            return HttpResponseStatus.BAD_REQUEST;
        }
        if (!metrics.has("series")) {
            this.error("/api/v1/series payload missing 'series' field", outputConsumer);
            return HttpResponseStatus.BAD_REQUEST;
        }
        JsonNode series = metrics.get("series");
        if (!series.isArray()) {
            this.error("'series' field must be an array", outputConsumer);
            return HttpResponseStatus.BAD_REQUEST;
        }
        HttpResponseStatus worstStatus = HttpResponseStatus.ACCEPTED;
        for (JsonNode metric : series) {
            HttpResponseStatus latestStatus = this.reportMetric(metric, pointCounter, outputConsumer);
            if (latestStatus.compareTo(worstStatus) <= 0) continue;
            worstStatus = latestStatus;
        }
        return worstStatus;
    }

    private HttpResponseStatus reportMetric(JsonNode metric, @Nullable AtomicInteger pointCounter, Consumer<String> outputConsumer) {
        if (metric == null) {
            this.error("Skipping - series object null.", outputConsumer);
            return HttpResponseStatus.BAD_REQUEST;
        }
        try {
            JsonNode pointsNode;
            JsonNode jsonInterval;
            if (metric.get("metric") == null) {
                this.error("Skipping - 'metric' field missing.", outputConsumer);
                return HttpResponseStatus.BAD_REQUEST;
            }
            String metricName = INVALID_METRIC_CHARACTERS.matcher(metric.get("metric").textValue()).replaceAll("_");
            String hostName = metric.get("host") == null ? "unknown" : metric.get("host").textValue().toLowerCase();
            JsonNode tagsNode = metric.get("tags");
            HashMap<String, String> tags = new HashMap<String, String>();
            Map systemTags = (Map)this.tagsCache.getIfPresent((Object)hostName);
            if (systemTags != null) {
                tags.putAll(systemTags);
            }
            this.extractTags(tagsNode, tags);
            JsonNode deviceNode = metric.get("device");
            if (deviceNode != null) {
                tags.put("device", deviceNode.textValue());
            }
            int interval = 1;
            JsonNode type = metric.get("type");
            if (type != null && type.textValue().equals("rate") && (jsonInterval = metric.get("interval")) != null && jsonInterval.isNumber()) {
                interval = jsonInterval.intValue();
            }
            if ((pointsNode = metric.get("points")) == null) {
                this.error("Skipping - 'points' field missing.", outputConsumer);
                return HttpResponseStatus.BAD_REQUEST;
            }
            for (JsonNode node : pointsNode) {
                if (node.size() == 2) {
                    this.reportValue(metricName, hostName, tags, node.get(1), node.get(0).longValue() * 1000L, pointCounter, interval);
                    continue;
                }
                this.error("Inconsistent point value size (expected: 2)", outputConsumer);
            }
            return HttpResponseStatus.ACCEPTED;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to add metric", e);
            outputConsumer.accept("Failed to add metric");
            return HttpResponseStatus.BAD_REQUEST;
        }
    }

    private void reportChecks(JsonNode checkNode, @Nullable AtomicInteger pointCounter, Consumer<String> outputConsumer) {
        if (checkNode == null) {
            this.error("Empty or malformed /api/v1/check_run payload - ignoring", outputConsumer);
            return;
        }
        if (checkNode.isArray()) {
            for (JsonNode check : checkNode) {
                this.reportCheck(check, pointCounter, outputConsumer);
            }
        } else {
            this.reportCheck(checkNode, pointCounter, outputConsumer);
        }
    }

    private void reportCheck(JsonNode check, @Nullable AtomicInteger pointCounter, Consumer<String> outputConsumer) {
        try {
            if (check.get("check") == null) {
                this.error("Skipping - 'check' field missing.", outputConsumer);
                return;
            }
            if (check.get("host_name") == null) {
                this.error("Skipping - 'host_name' field missing.", outputConsumer);
                return;
            }
            if (check.get("status") == null) {
                return;
            }
            String metricName = INVALID_METRIC_CHARACTERS.matcher(check.get("check").textValue()).replaceAll("_");
            String hostName = check.get("host_name").textValue().toLowerCase();
            JsonNode tagsNode = check.get("tags");
            HashMap<String, String> tags = new HashMap<String, String>();
            Map systemTags = (Map)this.tagsCache.getIfPresent((Object)hostName);
            if (systemTags != null) {
                tags.putAll(systemTags);
            }
            this.extractTags(tagsNode, tags);
            long timestamp = check.get("timestamp") == null ? Clock.now() : check.get("timestamp").asLong() * 1000L;
            this.reportValue(metricName, hostName, tags, check.get("status"), timestamp, pointCounter);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "WF-300: Failed to add metric", e);
        }
    }

    private HttpResponseStatus processMetadataAndSystemMetrics(JsonNode metrics, boolean reportSystemMetrics, @Nullable AtomicInteger pointCounter, Consumer<String> outputConsumer) {
        if (metrics == null || !metrics.isObject()) {
            this.error("Empty or malformed /intake payload", outputConsumer);
            return HttpResponseStatus.BAD_REQUEST;
        }
        if (!metrics.has("internalHostname")) {
            this.error("Payload missing 'internalHostname' field, ignoring", outputConsumer);
            return HttpResponseStatus.ACCEPTED;
        }
        String hostName = metrics.get("internalHostname").textValue().toLowerCase();
        HashMap<String, String> systemTags = new HashMap<String, String>();
        if (metrics.has("host-tags") && metrics.get("host-tags").get("system") != null) {
            this.extractTags(metrics.get("host-tags").get("system"), systemTags);
            this.tagsCache.put((Object)hostName, systemTags);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Cached system tags for " + hostName + ": " + systemTags.toString());
            }
        } else {
            Map cachedTags = (Map)this.tagsCache.getIfPresent((Object)hostName);
            if (cachedTags != null) {
                systemTags.clear();
                systemTags.putAll(cachedTags);
            }
        }
        if (!reportSystemMetrics) {
            Metrics.newCounter((MetricName)new TaggedMetricName("listeners", "http-requests.ignored", new String[]{"port", this.handle})).inc();
            return HttpResponseStatus.ACCEPTED;
        }
        if (metrics.has("collection_timestamp")) {
            long timestamp = metrics.get("collection_timestamp").asLong() * 1000L;
            JsonNode ioStats = metrics.get("ioStats");
            if (ioStats != null && ioStats.isObject()) {
                ioStats.fields().forEachRemaining(entry -> {
                    ImmutableMap deviceTags = ImmutableMap.builder().putAll((Map)systemTags).put((Object)"device", (Object)((String)entry.getKey())).build();
                    if (entry.getValue() != null && ((JsonNode)entry.getValue()).isObject()) {
                        ((JsonNode)entry.getValue()).fields().forEachRemaining(arg_0 -> this.lambda$processMetadataAndSystemMetrics$4(hostName, (Map)deviceTags, timestamp, pointCounter, arg_0));
                    }
                });
            }
            metrics.fields().forEachRemaining(entry -> {
                if (((String)entry.getKey()).startsWith("system.")) {
                    this.reportValue((String)entry.getKey(), hostName, systemTags, (JsonNode)entry.getValue(), timestamp, pointCounter);
                }
            });
            SYSTEM_METRICS.forEach((key, value) -> this.reportValue((String)key, hostName, (Map<String, String>)systemTags, metrics.get(value), timestamp, pointCounter));
        }
        return HttpResponseStatus.ACCEPTED;
    }

    private void reportValue(String metricName, String hostName, Map<String, String> tags, JsonNode valueNode, long timestamp, AtomicInteger pointCounter) {
        this.reportValue(metricName, hostName, tags, valueNode, timestamp, pointCounter, 1);
    }

    private void reportValue(String metricName, String hostName, Map<String, String> tags, JsonNode valueNode, long timestamp, AtomicInteger pointCounter, int interval) {
        double value;
        if (valueNode == null || valueNode.isNull()) {
            return;
        }
        if (valueNode.isTextual()) {
            try {
                value = Double.parseDouble(valueNode.textValue());
            }
            catch (NumberFormatException nfe) {
                return;
            }
        } else {
            value = valueNode.isBoolean() ? (valueNode.asBoolean() ? 1.0 : 0.0) : (valueNode.isDouble() ? valueNode.asDouble() : (double)valueNode.asLong());
        }
        this.reportValue(metricName, hostName, tags, value, timestamp, pointCounter, interval);
    }

    private void reportValue(String metricName, String hostName, Map<String, String> tags, double value, long timestamp, AtomicInteger pointCounter, int interval) {
        ReportPoint point = ReportPoint.newBuilder().setTable("dummy").setMetric(metricName).setHost(hostName).setTimestamp(timestamp).setAnnotations(tags).setValue(value *= (double)interval).build();
        if (pointCounter != null) {
            pointCounter.incrementAndGet();
        }
        if (this.preprocessorSupplier != null) {
            ReportableEntityPreprocessor preprocessor = this.preprocessorSupplier.get();
            String[] messageHolder = new String[1];
            preprocessor.forReportPoint().transform(point);
            if (!preprocessor.forReportPoint().filter(point, messageHolder)) {
                if (messageHolder[0] != null) {
                    blockedPointsLogger.warning(ReportPointSerializer.pointToString((ReportPoint)point));
                    this.pointHandler.reject(point, messageHolder[0]);
                } else {
                    blockedPointsLogger.info(ReportPointSerializer.pointToString((ReportPoint)point));
                    this.pointHandler.block(point);
                }
                return;
            }
        }
        this.pointHandler.report(point);
    }

    private void extractTags(JsonNode tagsNode, Map<String, String> tags) {
        if (tagsNode != null) {
            for (JsonNode tag : tagsNode) {
                String tagKv = tag.asText();
                if (tagKv.indexOf(44) > 0) {
                    for (String item : tagKv.split(",")) {
                        this.extractTag(item, tags);
                    }
                    continue;
                }
                this.extractTag(tagKv, tags);
            }
        }
    }

    private void extractTag(String input, Map<String, String> tags) {
        int tagKvIndex = input.indexOf(58);
        if (tagKvIndex > 0) {
            String tagK = input.substring(0, tagKvIndex);
            if (tagK.toLowerCase().equals("source")) {
                tags.put("_source", input.substring(tagKvIndex + 1));
            } else {
                tags.put(INVALID_TAG_CHARACTERS.matcher(tagK).replaceAll("_"), input.substring(tagKvIndex + 1));
            }
        }
    }

    private void error(String msg, Consumer<String> outputConsumer) {
        this.pointHandler.reject((ReportPoint)null, msg);
        outputConsumer.accept(msg);
        outputConsumer.accept("\n");
    }

    private /* synthetic */ void lambda$processMetadataAndSystemMetrics$4(String hostName, Map deviceTags, long timestamp, AtomicInteger pointCounter, Map.Entry metricEntry) {
        String metric = "system.io." + ((String)metricEntry.getKey()).replace('%', ' ').replace('/', '_').trim();
        this.reportValue(metric, hostName, deviceTags, (JsonNode)metricEntry.getValue(), timestamp, pointCounter);
    }
}

