/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners;

import com.wavefront.common.logger.MessageDedupingLogger;
import com.yammer.metrics.core.Counter;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.util.CharsetUtil;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class FeatureCheckUtils {
    private static final Logger logger = Logger.getLogger(FeatureCheckUtils.class.getCanonicalName());
    private static final Logger featureDisabledLogger = new MessageDedupingLogger(logger, 3L, 0.2);
    public static final String HISTO_DISABLED = "Ingested point discarded because histogram feature has not been enabled for your account";
    public static final String SPAN_DISABLED = "Ingested span discarded because distributed tracing feature has not been enabled for your account.";
    public static final String SPANLOGS_DISABLED = "Ingested span log discarded because this feature has not been enabled for your account.";
    public static final String LOGS_DISABLED = "Ingested logs discarded because this feature has not been enabled for your account.";
    public static final String LOGS_SERVER_DETAILS_MISSING = "Ingested logs discarded because the configuration is missing either logServerIngestionToken/logServerIngestionURL or both.";

    public static boolean isFeatureDisabled(Supplier<Boolean> featureDisabledFlag, String message, @Nullable Counter discardedCounter) {
        return FeatureCheckUtils.isFeatureDisabled(featureDisabledFlag, message, discardedCounter, null, null);
    }

    public static boolean isFeatureDisabled(Supplier<Boolean> featureDisabledFlag, String message, @Nullable Counter discardedCounter, @Nullable StringBuilder output) {
        return FeatureCheckUtils.isFeatureDisabled(featureDisabledFlag, message, discardedCounter, output, null);
    }

    public static boolean isFeatureDisabled(Supplier<Boolean> featureDisabledFlag, String message, @Nullable Counter discardedCounter, @Nullable StringBuilder output, @Nullable FullHttpRequest request) {
        return FeatureCheckUtils.isFeatureDisabled(featureDisabledFlag, message, discardedCounter, 1L, output, request);
    }

    public static boolean isFeatureDisabled(Supplier<Boolean> featureDisabledFlag, String message, Counter discardedCounter, long increment) {
        return FeatureCheckUtils.isFeatureDisabled(featureDisabledFlag, message, discardedCounter, increment, null, null);
    }

    public static boolean isFeatureDisabled(Supplier<Boolean> featureDisabledFlag, String message, @Nullable Counter discardedCounter, long increment, @Nullable StringBuilder output, @Nullable FullHttpRequest request) {
        if (featureDisabledFlag.get().booleanValue()) {
            featureDisabledLogger.warning(message);
            if (output != null) {
                output.append(message);
            }
            if (discardedCounter != null) {
                discardedCounter.inc(request == null ? increment : (long)(StringUtils.countMatches((CharSequence)request.content().toString(CharsetUtil.UTF_8), (CharSequence)"\n") + 1));
            }
            return true;
        }
        return false;
    }

    public static boolean isMissingLogServerInfoForAConvergedCSPTenant(boolean receivedLogServerDetails, boolean enableHyperlogsConvergedCsp, String message, @Nullable Counter discardedCounter) {
        if (enableHyperlogsConvergedCsp && !receivedLogServerDetails) {
            featureDisabledLogger.warning(message);
            if (discardedCounter != null) {
                discardedCounter.inc();
            }
            return true;
        }
        return false;
    }
}

