/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.wavefront.agent.auth.TokenAuthenticator;
import com.wavefront.agent.channel.ChannelUtils;
import com.wavefront.agent.channel.HealthCheckManager;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.handlers.ReportableEntityHandlerFactory;
import com.wavefront.agent.listeners.AbstractPortUnificationHandler;
import com.wavefront.agent.listeners.WavefrontPortUnificationHandler;
import com.wavefront.agent.preprocessor.ReportableEntityPreprocessor;
import com.wavefront.common.Clock;
import com.wavefront.data.ReportableEntityType;
import com.wavefront.ingester.ReportableEntityDecoder;
import com.wavefront.metrics.JsonMetricsParser;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.ReportPoint;

public class OpenTSDBPortUnificationHandler
extends AbstractPortUnificationHandler {
    private final ReportableEntityHandler<ReportPoint, String> pointHandler;
    private final ReportableEntityDecoder<String, ReportPoint> decoder;
    @Nullable
    private final Supplier<ReportableEntityPreprocessor> preprocessorSupplier;
    @Nullable
    private final Function<InetAddress, String> resolver;

    public OpenTSDBPortUnificationHandler(String handle, TokenAuthenticator tokenAuthenticator, HealthCheckManager healthCheckManager, ReportableEntityDecoder<String, ReportPoint> decoder, ReportableEntityHandlerFactory handlerFactory, @Nullable Supplier<ReportableEntityPreprocessor> preprocessor, @Nullable Function<InetAddress, String> resolver) {
        super(tokenAuthenticator, healthCheckManager, handle);
        this.decoder = decoder;
        this.pointHandler = handlerFactory.getHandler(ReportableEntityType.POINT, handle);
        this.preprocessorSupplier = preprocessor;
        this.resolver = resolver;
    }

    @Override
    protected void handleHttpMessage(ChannelHandlerContext ctx, FullHttpRequest request) throws URISyntaxException {
        StringBuilder output = new StringBuilder();
        URI uri = new URI(request.uri());
        switch (uri.getPath()) {
            case "/api/put": {
                HttpResponseStatus status;
                ObjectMapper jsonTree = new ObjectMapper();
                try {
                    JsonNode metrics = jsonTree.readTree(request.content().toString(CharsetUtil.UTF_8));
                    if (this.reportMetrics(metrics, ctx)) {
                        status = HttpResponseStatus.NO_CONTENT;
                    } else {
                        status = HttpResponseStatus.BAD_REQUEST;
                        output.append("At least one data point had error.");
                    }
                }
                catch (Exception e) {
                    status = HttpResponseStatus.BAD_REQUEST;
                    output.append(ChannelUtils.errorMessageWithRootCause(e));
                    this.logWarning("WF-300: Failed to handle /api/put request", e, ctx);
                }
                ChannelUtils.writeHttpResponse(ctx, status, (Object)output, (HttpMessage)request);
                break;
            }
            case "/api/version": {
                ObjectNode node = JsonNodeFactory.instance.objectNode();
                node.put("version", ResourceBundle.getBundle("build").getString("build.version"));
                ChannelUtils.writeHttpResponse(ctx, HttpResponseStatus.OK, (Object)node, (HttpMessage)request);
                break;
            }
            default: {
                ChannelUtils.writeHttpResponse(ctx, HttpResponseStatus.BAD_REQUEST, (Object)"Unsupported path", (HttpMessage)request);
                this.logWarning("WF-300: Unexpected path '" + request.uri() + "'", null, ctx);
            }
        }
    }

    @Override
    protected void handlePlainTextMessage(ChannelHandlerContext ctx, @Nonnull String message) {
        if (message.startsWith("version")) {
            ChannelFuture f = ctx.writeAndFlush((Object)"Wavefront OpenTSDB Endpoint\n");
            if (!f.isSuccess()) {
                throw new RuntimeException("Failed to write version response", f.cause());
            }
        } else {
            WavefrontPortUnificationHandler.preprocessAndHandlePoint(message, this.decoder, this.pointHandler, this.preprocessorSupplier, ctx, "OpenTSDB metric");
        }
    }

    private boolean reportMetrics(JsonNode metrics, ChannelHandlerContext ctx) {
        if (!metrics.isArray()) {
            return this.reportMetric(metrics, ctx);
        }
        boolean successful = true;
        for (JsonNode metric : metrics) {
            if (this.reportMetric(metric, ctx)) continue;
            successful = false;
        }
        return successful;
    }

    private boolean reportMetric(JsonNode metric, ChannelHandlerContext ctx) {
        try {
            String metricName = metric.get("metric").textValue();
            JsonNode tags = metric.get("tags");
            Map wftags = JsonMetricsParser.makeTags((JsonNode)tags);
            String hostName = wftags.containsKey("host") ? (String)wftags.get("host") : (wftags.containsKey("source") ? (String)wftags.get("source") : (this.resolver == null ? "unknown" : this.resolver.apply(ChannelUtils.getRemoteAddress(ctx))));
            HashMap<String, String> wftags2 = new HashMap<String, String>();
            for (Map.Entry wftag : wftags.entrySet()) {
                if (((String)wftag.getKey()).equalsIgnoreCase("host") || ((String)wftag.getKey()).equalsIgnoreCase("source")) continue;
                wftags2.put((String)wftag.getKey(), (String)wftag.getValue());
            }
            ReportPoint.Builder builder = ReportPoint.newBuilder();
            builder.setMetric(metricName);
            JsonNode time = metric.get("timestamp");
            long ts = Clock.now();
            if (time != null) {
                int timestampSize = Long.toString(time.asLong()).length();
                ts = timestampSize == 19 ? time.asLong() / 1000000L : (timestampSize == 16 ? time.asLong() / 1000L : (timestampSize == 13 ? time.asLong() : time.asLong() * 1000L));
            }
            builder.setTimestamp(ts);
            JsonNode value = metric.get("value");
            if (value == null) {
                this.pointHandler.reject((ReportPoint)null, "Skipping.  Missing 'value' in JSON node.");
                return false;
            }
            if (value.isDouble()) {
                builder.setValue(value.asDouble());
            } else {
                builder.setValue(value.asLong());
            }
            builder.setAnnotations(wftags2);
            builder.setTable("dummy");
            builder.setHost(hostName);
            ReportPoint point = builder.build();
            ReportableEntityPreprocessor preprocessor = this.preprocessorSupplier == null ? null : this.preprocessorSupplier.get();
            String[] messageHolder = new String[1];
            if (preprocessor != null) {
                preprocessor.forReportPoint().transform(point);
                if (!preprocessor.forReportPoint().filter(point, messageHolder)) {
                    if (messageHolder[0] != null) {
                        this.pointHandler.reject(point, messageHolder[0]);
                        return false;
                    }
                    this.pointHandler.block(point);
                    return true;
                }
            }
            this.pointHandler.report(point);
            return true;
        }
        catch (Exception e) {
            this.logWarning("WF-300: Failed to add metric", e, null);
            return false;
        }
    }
}

