/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.wavefront.agent.ProxyConfig;
import com.wavefront.agent.TokenManager;
import com.wavefront.agent.api.APIContainer;
import com.wavefront.agent.auth.TokenAuthenticator;
import com.wavefront.agent.channel.ChannelUtils;
import com.wavefront.agent.channel.HealthCheckManager;
import com.wavefront.agent.channel.SharedGraphiteHostAnnotator;
import com.wavefront.agent.formatter.DataFormat;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.handlers.ReportableEntityHandlerFactory;
import com.wavefront.agent.listeners.AbstractHttpOnlyHandler;
import com.wavefront.agent.listeners.FeatureCheckUtils;
import com.wavefront.agent.listeners.WavefrontPortUnificationHandler;
import com.wavefront.agent.preprocessor.ReportableEntityPreprocessor;
import com.wavefront.api.agent.AgentConfiguration;
import com.wavefront.common.TaggedMetricName;
import com.wavefront.common.Utils;
import com.wavefront.data.ReportableEntityType;
import com.wavefront.ingester.ReportableEntityDecoder;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.ws.rs.ProcessingException;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import wavefront.report.ReportPoint;
import wavefront.report.Span;
import wavefront.report.SpanLogs;

@ChannelHandler.Sharable
public class RelayPortUnificationHandler
extends AbstractHttpOnlyHandler {
    private static final Logger logger = Logger.getLogger(RelayPortUnificationHandler.class.getCanonicalName());
    private static final ObjectMapper JSON_PARSER = new ObjectMapper();
    private final Map<ReportableEntityType, ReportableEntityDecoder<?, ?>> decoders;
    private final ReportableEntityDecoder<String, ReportPoint> wavefrontDecoder;
    private ProxyConfig proxyConfig;
    private final ReportableEntityHandler<ReportPoint, String> wavefrontHandler;
    private final Supplier<ReportableEntityHandler<ReportPoint, String>> histogramHandlerSupplier;
    private final Supplier<ReportableEntityHandler<Span, String>> spanHandlerSupplier;
    private final Supplier<ReportableEntityHandler<SpanLogs, String>> spanLogsHandlerSupplier;
    private final Supplier<ReportableEntityPreprocessor> preprocessorSupplier;
    private final SharedGraphiteHostAnnotator annotator;
    private final Supplier<Boolean> histogramDisabled;
    private final Supplier<Boolean> traceDisabled;
    private final Supplier<Boolean> spanLogsDisabled;
    private final Supplier<Boolean> logsDisabled;
    private final Supplier<Counter> discardedHistograms;
    private final Supplier<Counter> discardedSpans;
    private final Supplier<Counter> discardedSpanLogs;
    private final Supplier<Counter> receivedSpansTotal;
    private final APIContainer apiContainer;

    public RelayPortUnificationHandler(String handle, TokenAuthenticator tokenAuthenticator, HealthCheckManager healthCheckManager, Map<ReportableEntityType, ReportableEntityDecoder<?, ?>> decoders, ReportableEntityHandlerFactory handlerFactory, @Nullable Supplier<ReportableEntityPreprocessor> preprocessorSupplier, @Nullable SharedGraphiteHostAnnotator annotator, Supplier<Boolean> histogramDisabled, Supplier<Boolean> traceDisabled, Supplier<Boolean> spanLogsDisabled, Supplier<Boolean> logsDisabled, APIContainer apiContainer, ProxyConfig proxyConfig) {
        super(tokenAuthenticator, healthCheckManager, handle);
        this.decoders = decoders;
        this.wavefrontDecoder = decoders.get(ReportableEntityType.POINT);
        this.proxyConfig = proxyConfig;
        this.wavefrontHandler = handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.POINT, handle));
        this.histogramHandlerSupplier = Utils.lazySupplier(() -> handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.HISTOGRAM, handle)));
        this.spanHandlerSupplier = Utils.lazySupplier(() -> handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.TRACE, handle)));
        this.spanLogsHandlerSupplier = Utils.lazySupplier(() -> handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.TRACE_SPAN_LOGS, handle)));
        this.receivedSpansTotal = Utils.lazySupplier(() -> Metrics.newCounter((MetricName)new MetricName("spans." + handle, "", "received.total")));
        this.preprocessorSupplier = preprocessorSupplier;
        this.annotator = annotator;
        this.histogramDisabled = histogramDisabled;
        this.traceDisabled = traceDisabled;
        this.spanLogsDisabled = spanLogsDisabled;
        this.logsDisabled = logsDisabled;
        this.discardedHistograms = Utils.lazySupplier(() -> Metrics.newCounter((MetricName)new MetricName("histogram", "", "discarded_points")));
        this.discardedSpans = Utils.lazySupplier(() -> Metrics.newCounter((MetricName)new MetricName("spans." + handle, "", "discarded")));
        this.discardedSpanLogs = Utils.lazySupplier(() -> Metrics.newCounter((MetricName)new MetricName("spanLogs." + handle, "", "discarded")));
        this.apiContainer = apiContainer;
    }

    @Override
    protected void handleHttpMessage(ChannelHandlerContext ctx, FullHttpRequest request) {
        HttpResponseStatus status;
        URI uri = URI.create(request.uri());
        StringBuilder output = new StringBuilder();
        String path = uri.getPath();
        if (path.endsWith("/checkin") && (path.startsWith("/api/daemon") || path.contains("wfproxy"))) {
            JsonNode agentMetrics;
            Map<String, String> query = URLEncodedUtils.parse((URI)uri, (Charset)Charset.forName("UTF-8")).stream().collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
            String agentMetricsStr = request.content().toString(CharsetUtil.UTF_8);
            try {
                agentMetrics = JSON_PARSER.readTree(agentMetricsStr);
            }
            catch (JsonProcessingException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.WARNING, "Exception: ", e);
                }
                agentMetrics = JsonNodeFactory.instance.objectNode();
            }
            try {
                AgentConfiguration agentConfiguration = this.apiContainer.getProxyV2APIForTenant("central").proxyCheckin(UUID.fromString(request.headers().get("X-WF-PROXY-ID")), "Bearer " + TokenManager.getMulticastingTenantList().get("central").getBearerToken(), query.get("hostname"), query.get("proxyname"), query.get("version"), Long.valueOf(Long.parseLong(query.get("currentMillis"))), agentMetrics, Boolean.valueOf(Boolean.parseBoolean(query.get("ephemeral"))));
                JsonNode node = JSON_PARSER.valueToTree((Object)agentConfiguration);
                ChannelUtils.writeHttpResponse(ctx, HttpResponseStatus.OK, (Object)node, (HttpMessage)request);
            }
            catch (ProcessingException e) {
                logger.warning("Problem while checking a chained proxy: " + (Object)((Object)e));
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.WARNING, "Exception: ", e);
                }
                Throwable rootCause = Throwables.getRootCause((Throwable)e);
                String error = "Request processing error: Unable to retrieve proxy configuration from '" + this.proxyConfig.getServer() + "' :" + rootCause;
                ChannelUtils.writeHttpResponse(ctx, new HttpResponseStatus(444, error), (Object)error, (HttpMessage)request);
            }
            catch (Throwable e) {
                logger.warning("Problem while checking a chained proxy: " + e);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.WARNING, "Exception: ", e);
                }
                String error = "Request processing error: Unable to retrieve proxy configuration from '" + this.proxyConfig.getServer() + "'";
                ChannelUtils.writeHttpResponse(ctx, new HttpResponseStatus(500, error), (Object)error, (HttpMessage)request);
            }
            return;
        }
        String format = URLEncodedUtils.parse((URI)uri, (Charset)CharsetUtil.UTF_8).stream().filter(x -> x.getName().equals("format") || x.getName().equals("f")).map(NameValuePair::getValue).findFirst().orElse("wavefront");
        boolean isDirectIngestion = path.startsWith("/report");
        HttpResponseStatus okStatus = isDirectIngestion ? HttpResponseStatus.ACCEPTED : (path.contains("/pushdata/") || path.contains("wfproxy/report") ? HttpResponseStatus.OK : HttpResponseStatus.NO_CONTENT);
        switch (format) {
            case "histogram": {
                if (FeatureCheckUtils.isFeatureDisabled(this.histogramDisabled, "Ingested point discarded because histogram feature has not been enabled for your account", this.discardedHistograms.get(), output, request)) {
                    status = HttpResponseStatus.FORBIDDEN;
                    break;
                }
            }
            case "wavefront": 
            case "graphite_v2": {
                AtomicBoolean hasSuccessfulPoints = new AtomicBoolean(false);
                try {
                    ReportableEntityDecoder<?, ?> histogramDecoder = this.decoders.get(ReportableEntityType.HISTOGRAM);
                    Splitter.on((char)'\n').trimResults().omitEmptyStrings().split((CharSequence)request.content().toString(CharsetUtil.UTF_8)).forEach(message -> {
                        DataFormat dataFormat = DataFormat.autodetect(message);
                        switch (dataFormat) {
                            case EVENT: {
                                this.wavefrontHandler.reject((String)message, "Relay port does not support event-formatted data!");
                                break;
                            }
                            case SOURCE_TAG: {
                                this.wavefrontHandler.reject((String)message, "Relay port does not support sourceTag-formatted data!");
                                break;
                            }
                            case HISTOGRAM: {
                                if (FeatureCheckUtils.isFeatureDisabled(this.histogramDisabled, "Ingested point discarded because histogram feature has not been enabled for your account", this.discardedHistograms.get(), output)) break;
                                WavefrontPortUnificationHandler.preprocessAndHandlePoint(message, (ReportableEntityDecoder<String, ReportPoint>)histogramDecoder, this.histogramHandlerSupplier.get(), this.preprocessorSupplier, ctx, "histogram");
                                hasSuccessfulPoints.set(true);
                                break;
                            }
                            default: {
                                message = this.annotator != null && isDirectIngestion ? this.annotator.apply(ctx, (String)message) : message;
                                WavefrontPortUnificationHandler.preprocessAndHandlePoint(message, this.wavefrontDecoder, this.wavefrontHandler, this.preprocessorSupplier, ctx, "metric");
                                hasSuccessfulPoints.set(true);
                            }
                        }
                    });
                    status = hasSuccessfulPoints.get() ? okStatus : HttpResponseStatus.BAD_REQUEST;
                }
                catch (Exception e) {
                    status = HttpResponseStatus.BAD_REQUEST;
                    output.append(ChannelUtils.errorMessageWithRootCause(e));
                    this.logWarning("WF-300: Failed to handle HTTP POST", e, ctx);
                }
                break;
            }
            case "trace": {
                if (FeatureCheckUtils.isFeatureDisabled(this.traceDisabled, "Ingested span discarded because distributed tracing feature has not been enabled for your account.", this.discardedSpans.get(), output, request)) {
                    this.receivedSpansTotal.get().inc(this.discardedSpans.get().count());
                    status = HttpResponseStatus.FORBIDDEN;
                    break;
                }
                ArrayList spans = new ArrayList();
                ReportableEntityDecoder<?, ?> spanDecoder = this.decoders.get(ReportableEntityType.TRACE);
                ReportableEntityHandler<Span, String> spanHandler = this.spanHandlerSupplier.get();
                Splitter.on((char)'\n').trimResults().omitEmptyStrings().split((CharSequence)request.content().toString(CharsetUtil.UTF_8)).forEach(line -> {
                    try {
                        this.receivedSpansTotal.get().inc();
                        spanDecoder.decode(line, spans, "dummy");
                    }
                    catch (Exception e) {
                        spanHandler.reject((String)line, ChannelUtils.formatErrorMessage(line, e, ctx));
                    }
                });
                spans.forEach(spanHandler::report);
                status = okStatus;
                break;
            }
            case "spanLogs": {
                if (FeatureCheckUtils.isFeatureDisabled(this.spanLogsDisabled, "Ingested span log discarded because this feature has not been enabled for your account.", this.discardedSpanLogs.get(), output, request)) {
                    status = HttpResponseStatus.FORBIDDEN;
                    break;
                }
                ArrayList spanLogs = new ArrayList();
                ReportableEntityDecoder<?, ?> spanLogDecoder = this.decoders.get(ReportableEntityType.TRACE_SPAN_LOGS);
                ReportableEntityHandler<SpanLogs, String> spanLogsHandler = this.spanLogsHandlerSupplier.get();
                Splitter.on((char)'\n').trimResults().omitEmptyStrings().split((CharSequence)request.content().toString(CharsetUtil.UTF_8)).forEach(line -> {
                    try {
                        spanLogDecoder.decode((Object)JSON_PARSER.readTree(line), spanLogs, "dummy");
                    }
                    catch (Exception e) {
                        spanLogsHandler.reject((String)line, ChannelUtils.formatErrorMessage(line, e, ctx));
                    }
                });
                spanLogs.forEach(spanLogsHandler::report);
                status = okStatus;
                break;
            }
            case "logs_json_arr": 
            case "logs_json_lines": 
            case "logs_json_cloudwatch": {
                Supplier<Counter> discardedLogs = Utils.lazySupplier(() -> Metrics.newCounter((MetricName)new TaggedMetricName("logs." + this.handle, "discarded", new String[]{"format", format})));
                if (FeatureCheckUtils.isFeatureDisabled(this.logsDisabled, "Ingested logs discarded because this feature has not been enabled for your account.", discardedLogs.get(), output, request)) {
                    status = HttpResponseStatus.FORBIDDEN;
                    break;
                }
            }
            default: {
                status = HttpResponseStatus.BAD_REQUEST;
                logger.warning("Unexpected format for incoming HTTP request: " + format);
            }
        }
        ChannelUtils.writeHttpResponse(ctx, status, (Object)output, (HttpMessage)request);
    }
}

