/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.listeners.tracing;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.wavefront.agent.auth.TokenAuthenticator;
import com.wavefront.agent.channel.HealthCheckManager;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.handlers.ReportableEntityHandlerFactory;
import com.wavefront.agent.listeners.tracing.TracePortUnificationHandler;
import com.wavefront.agent.preprocessor.ReportableEntityPreprocessor;
import com.wavefront.agent.sampler.SpanSampler;
import com.wavefront.data.ReportableEntityType;
import com.wavefront.ingester.ReportableEntityDecoder;
import com.wavefront.internal.SpanDerivedMetricsUtils;
import com.wavefront.internal.reporter.WavefrontInternalReporter;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.WavefrontSender;
import io.netty.channel.ChannelHandler;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import wavefront.report.Annotation;
import wavefront.report.Span;
import wavefront.report.SpanLogs;

@ChannelHandler.Sharable
public class CustomTracingPortUnificationHandler
extends TracePortUnificationHandler {
    private static final Logger logger = Logger.getLogger(CustomTracingPortUnificationHandler.class.getCanonicalName());
    @Nullable
    private final WavefrontSender wfSender;
    private final WavefrontInternalReporter wfInternalReporter;
    private final Set<Pair<Map<String, String>, String>> discoveredHeartbeatMetrics;
    private final Set<String> traceDerivedCustomTagKeys;
    private final String proxyLevelApplicationName;
    private final String proxyLevelServiceName;

    public CustomTracingPortUnificationHandler(String handle, TokenAuthenticator tokenAuthenticator, HealthCheckManager healthCheckManager, ReportableEntityDecoder<String, Span> traceDecoder, ReportableEntityDecoder<JsonNode, SpanLogs> spanLogsDecoder, @Nullable Supplier<ReportableEntityPreprocessor> preprocessor, ReportableEntityHandlerFactory handlerFactory, SpanSampler sampler, Supplier<Boolean> traceDisabled, Supplier<Boolean> spanLogsDisabled, @Nullable WavefrontSender wfSender, @Nullable WavefrontInternalReporter wfInternalReporter, Set<String> traceDerivedCustomTagKeys, @Nullable String customTracingApplicationName, @Nullable String customTracingServiceName) {
        this(handle, tokenAuthenticator, healthCheckManager, traceDecoder, spanLogsDecoder, preprocessor, handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.TRACE, handle)), handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.TRACE_SPAN_LOGS, handle)), sampler, traceDisabled, spanLogsDisabled, wfSender, wfInternalReporter, traceDerivedCustomTagKeys, customTracingApplicationName, customTracingServiceName);
    }

    @VisibleForTesting
    public CustomTracingPortUnificationHandler(String handle, TokenAuthenticator tokenAuthenticator, HealthCheckManager healthCheckManager, ReportableEntityDecoder<String, Span> traceDecoder, ReportableEntityDecoder<JsonNode, SpanLogs> spanLogsDecoder, @Nullable Supplier<ReportableEntityPreprocessor> preprocessor, ReportableEntityHandler<Span, String> handler, ReportableEntityHandler<SpanLogs, String> spanLogsHandler, SpanSampler sampler, Supplier<Boolean> traceDisabled, Supplier<Boolean> spanLogsDisabled, @Nullable WavefrontSender wfSender, @Nullable WavefrontInternalReporter wfInternalReporter, Set<String> traceDerivedCustomTagKeys, @Nullable String customTracingApplicationName, @Nullable String customTracingServiceName) {
        super(handle, tokenAuthenticator, healthCheckManager, traceDecoder, spanLogsDecoder, preprocessor, handler, spanLogsHandler, sampler, traceDisabled, spanLogsDisabled);
        this.wfSender = wfSender;
        this.wfInternalReporter = wfInternalReporter;
        this.discoveredHeartbeatMetrics = Sets.newConcurrentHashSet();
        this.traceDerivedCustomTagKeys = traceDerivedCustomTagKeys;
        this.proxyLevelApplicationName = StringUtils.isBlank((String)customTracingApplicationName) ? "defaultApp" : customTracingApplicationName;
        this.proxyLevelServiceName = StringUtils.isBlank((String)customTracingServiceName) ? "defaultService" : customTracingServiceName;
    }

    @Override
    protected void report(Span object) {
        String applicationName = null;
        String serviceName = null;
        String cluster = "none";
        String shard = "none";
        String componentTagValue = "none";
        String isError = "false";
        List annotations = object.getAnnotations();
        block18: for (Annotation annotation : annotations) {
            switch (annotation.getKey()) {
                case "application": {
                    applicationName = annotation.getValue();
                    continue block18;
                }
                case "service": {
                    serviceName = annotation.getValue();
                    continue block18;
                }
                case "cluster": {
                    cluster = annotation.getValue();
                    continue block18;
                }
                case "shard": {
                    shard = annotation.getValue();
                    continue block18;
                }
                case "component": {
                    componentTagValue = annotation.getValue();
                    continue block18;
                }
                case "error": {
                    isError = annotation.getValue();
                    continue block18;
                }
            }
        }
        if (applicationName == null || serviceName == null) {
            logger.warning("Ingested spans discarded because span application/service name is missing.");
            this.discardedSpans.inc();
            return;
        }
        this.handler.report(object);
        applicationName = (String)ObjectUtils.firstNonNull((Object[])new String[]{applicationName, this.proxyLevelApplicationName});
        serviceName = (String)ObjectUtils.firstNonNull((Object[])new String[]{serviceName, this.proxyLevelServiceName});
        if (this.wfInternalReporter != null) {
            List spanTags = annotations.stream().map(a -> new Pair((Object)a.getKey(), (Object)a.getValue())).collect(Collectors.toList());
            this.discoveredHeartbeatMetrics.add((Pair<Map<String, String>, String>)SpanDerivedMetricsUtils.reportWavefrontGeneratedData((WavefrontInternalReporter)this.wfInternalReporter, (String)object.getName(), (String)applicationName, (String)serviceName, (String)cluster, (String)shard, (String)object.getSource(), (String)componentTagValue, (boolean)Boolean.parseBoolean(isError), (long)this.millisToMicros(object.getDuration()), this.traceDerivedCustomTagKeys, spanTags, (boolean)true));
            try {
                SpanDerivedMetricsUtils.reportHeartbeats((WavefrontSender)this.wfSender, this.discoveredHeartbeatMetrics, (String)"wavefront-generated");
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Cannot report heartbeat metric to wavefront");
            }
        }
    }

    private long millisToMicros(long millis) {
        return millis * 1000L;
    }
}

