/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.logsharvesting;

import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.common.MetricConstants;
import java.util.function.Supplier;
import wavefront.report.Histogram;
import wavefront.report.ReportPoint;
import wavefront.report.TimeSeries;

public class FlushProcessorContext {
    private final long timestamp;
    private final TimeSeries timeSeries;
    private final Supplier<ReportableEntityHandler<ReportPoint, String>> pointHandlerSupplier;
    private final Supplier<ReportableEntityHandler<ReportPoint, String>> histogramHandlerSupplier;
    private final String prefix;

    FlushProcessorContext(TimeSeries timeSeries, String prefix, Supplier<ReportableEntityHandler<ReportPoint, String>> pointHandlerSupplier, Supplier<ReportableEntityHandler<ReportPoint, String>> histogramHandlerSupplier) {
        this.timeSeries = TimeSeries.newBuilder((TimeSeries)timeSeries).build();
        this.prefix = prefix;
        this.pointHandlerSupplier = pointHandlerSupplier;
        this.histogramHandlerSupplier = histogramHandlerSupplier;
        this.timestamp = System.currentTimeMillis();
    }

    String getMetricName() {
        return this.timeSeries.getMetric();
    }

    private ReportPoint.Builder reportPointBuilder(long timestamp) {
        String newName = this.timeSeries.getMetric();
        newName = this.prefix != null && (newName.startsWith(MetricConstants.DELTA_PREFIX) || newName.startsWith(MetricConstants.DELTA_PREFIX_2)) ? MetricConstants.DELTA_PREFIX + this.prefix + "." + newName.substring(MetricConstants.DELTA_PREFIX.length()) : (this.prefix == null ? this.timeSeries.getMetric() : this.prefix + "." + this.timeSeries.getMetric());
        return ReportPoint.newBuilder().setHost(this.timeSeries.getHost()).setAnnotations(this.timeSeries.getAnnotations()).setTimestamp(timestamp).setMetric(newName);
    }

    void report(ReportPoint reportPoint) {
        this.pointHandlerSupplier.get().report(reportPoint);
    }

    void report(double value) {
        this.report(this.reportPointBuilder(this.timestamp).setValue(value).build());
    }

    void report(long value) {
        this.report(this.reportPointBuilder(this.timestamp).setValue(value).build());
    }

    void report(Histogram value, long timestamp) {
        this.histogramHandlerSupplier.get().report(this.reportPointBuilder(timestamp).setValue(value).build());
    }

    void reportSubMetric(double value, String subMetric) {
        ReportPoint.Builder builder = this.reportPointBuilder(this.timestamp);
        this.report(builder.setValue(value).setMetric(builder.getMetric() + "." + subMetric).build());
    }
}

