/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.logsharvesting;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.annotations.VisibleForTesting;
import com.wavefront.agent.config.ConfigurationException;
import com.wavefront.agent.config.LogsIngestionConfig;
import com.wavefront.agent.config.MetricMatcher;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogsIngestionConfigManager {
    protected static final Logger logger = Logger.getLogger(LogsIngestionConfigManager.class.getCanonicalName());
    private static final Counter configReloads = Metrics.newCounter((MetricName)new MetricName("logsharvesting", "", "config-reloads.successful"));
    private static final Counter failedConfigReloads = Metrics.newCounter((MetricName)new MetricName("logsharvesting", "", "config-reloads.failed"));
    private LogsIngestionConfig lastParsedConfig;
    private final LoadingCache<Boolean, LogsIngestionConfig> logsIngestionConfigLoadingCache;
    private final Consumer<MetricMatcher> removalListener;

    public LogsIngestionConfigManager(Supplier<LogsIngestionConfig> logsIngestionConfigSupplier, Consumer<MetricMatcher> removalListener) throws ConfigurationException {
        this.removalListener = removalListener;
        this.lastParsedConfig = logsIngestionConfigSupplier.get();
        if (this.lastParsedConfig == null) {
            throw new ConfigurationException("Could not load initial config.");
        }
        this.lastParsedConfig.verifyAndInit();
        this.logsIngestionConfigLoadingCache = Caffeine.newBuilder().expireAfterWrite((long)this.lastParsedConfig.configReloadIntervalSeconds, TimeUnit.SECONDS).build(ignored -> {
            LogsIngestionConfig nextConfig = (LogsIngestionConfig)logsIngestionConfigSupplier.get();
            if (nextConfig == null) {
                logger.warning("Unable to reload logs ingestion config file!");
                failedConfigReloads.inc();
            } else if (!this.lastParsedConfig.equals(nextConfig)) {
                nextConfig.verifyAndInit();
                this.processConfigChange(nextConfig);
                logger.info("Loaded new config: " + this.lastParsedConfig.toString());
                configReloads.inc();
            }
            return this.lastParsedConfig;
        });
        new Timer("Timer-logsingestion-configmanager").schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    LogsIngestionConfigManager.this.logsIngestionConfigLoadingCache.get((Object)true);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Cannot load a new logs ingestion config.", e);
                }
            }
        }, this.lastParsedConfig.aggregationIntervalSeconds.intValue(), (long)this.lastParsedConfig.aggregationIntervalSeconds.intValue());
    }

    public LogsIngestionConfig getConfig() {
        return (LogsIngestionConfig)this.logsIngestionConfigLoadingCache.get((Object)true);
    }

    @VisibleForTesting
    public void forceConfigReload() {
        this.logsIngestionConfigLoadingCache.invalidate((Object)true);
    }

    private void processConfigChange(LogsIngestionConfig nextConfig) {
        if (nextConfig.useWavefrontHistograms != this.lastParsedConfig.useWavefrontHistograms) {
            logger.warning("useWavefrontHistograms property cannot be changed at runtime, proxy restart required!");
        }
        if (nextConfig.useDeltaCounters != this.lastParsedConfig.useDeltaCounters) {
            logger.warning("useDeltaCounters property cannot be changed at runtime, proxy restart required!");
        }
        if (nextConfig.reportEmptyHistogramStats != this.lastParsedConfig.reportEmptyHistogramStats) {
            logger.warning("reportEmptyHistogramStats property cannot be changed at runtime, proxy restart required!");
        }
        if (!nextConfig.aggregationIntervalSeconds.equals(this.lastParsedConfig.aggregationIntervalSeconds)) {
            logger.warning("aggregationIntervalSeconds property cannot be changed at runtime, proxy restart required!");
        }
        if (nextConfig.configReloadIntervalSeconds != this.lastParsedConfig.configReloadIntervalSeconds) {
            logger.warning("configReloadIntervalSeconds property cannot be changed at runtime, proxy restart required!");
        }
        if (nextConfig.expiryMillis != this.lastParsedConfig.expiryMillis) {
            logger.warning("expiryMillis property cannot be changed at runtime, proxy restart required!");
        }
        for (MetricMatcher oldMatcher : this.lastParsedConfig.counters) {
            if (nextConfig.counters.contains(oldMatcher)) continue;
            this.removalListener.accept(oldMatcher);
        }
        for (MetricMatcher oldMatcher : this.lastParsedConfig.gauges) {
            if (nextConfig.gauges.contains(oldMatcher)) continue;
            this.removalListener.accept(oldMatcher);
        }
        for (MetricMatcher oldMatcher : this.lastParsedConfig.histograms) {
            if (nextConfig.histograms.contains(oldMatcher)) continue;
            this.removalListener.accept(oldMatcher);
        }
        this.lastParsedConfig = nextConfig;
    }
}

