/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.wavefront.agent.ProxyCheckInScheduler;
import com.wavefront.agent.preprocessor.CountTransformer;
import com.wavefront.agent.preprocessor.LengthLimitActionType;
import com.wavefront.agent.preprocessor.LineBasedAllowFilter;
import com.wavefront.agent.preprocessor.LineBasedBlockFilter;
import com.wavefront.agent.preprocessor.LineBasedReplaceRegexTransformer;
import com.wavefront.agent.preprocessor.MetricsFilter;
import com.wavefront.agent.preprocessor.Predicates;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import com.wavefront.agent.preprocessor.PreprocessorUtil;
import com.wavefront.agent.preprocessor.ReportLogAddTagIfNotExistsTransformer;
import com.wavefront.agent.preprocessor.ReportLogAddTagTransformer;
import com.wavefront.agent.preprocessor.ReportLogAllowFilter;
import com.wavefront.agent.preprocessor.ReportLogAllowTagTransformer;
import com.wavefront.agent.preprocessor.ReportLogBlockFilter;
import com.wavefront.agent.preprocessor.ReportLogDropTagTransformer;
import com.wavefront.agent.preprocessor.ReportLogExtractTagIfNotExistsTransformer;
import com.wavefront.agent.preprocessor.ReportLogExtractTagTransformer;
import com.wavefront.agent.preprocessor.ReportLogForceLowercaseTransformer;
import com.wavefront.agent.preprocessor.ReportLogLimitLengthTransformer;
import com.wavefront.agent.preprocessor.ReportLogRenameTagTransformer;
import com.wavefront.agent.preprocessor.ReportLogReplaceRegexTransformer;
import com.wavefront.agent.preprocessor.ReportPointAddTagIfNotExistsTransformer;
import com.wavefront.agent.preprocessor.ReportPointAddTagTransformer;
import com.wavefront.agent.preprocessor.ReportPointAllowFilter;
import com.wavefront.agent.preprocessor.ReportPointBlockFilter;
import com.wavefront.agent.preprocessor.ReportPointDropTagTransformer;
import com.wavefront.agent.preprocessor.ReportPointExtractTagIfNotExistsTransformer;
import com.wavefront.agent.preprocessor.ReportPointExtractTagTransformer;
import com.wavefront.agent.preprocessor.ReportPointForceLowercaseTransformer;
import com.wavefront.agent.preprocessor.ReportPointLimitLengthTransformer;
import com.wavefront.agent.preprocessor.ReportPointRenameTagTransformer;
import com.wavefront.agent.preprocessor.ReportPointReplaceRegexTransformer;
import com.wavefront.agent.preprocessor.ReportableEntityPreprocessor;
import com.wavefront.agent.preprocessor.SpanAddAnnotationIfNotExistsTransformer;
import com.wavefront.agent.preprocessor.SpanAddAnnotationTransformer;
import com.wavefront.agent.preprocessor.SpanAllowAnnotationTransformer;
import com.wavefront.agent.preprocessor.SpanAllowFilter;
import com.wavefront.agent.preprocessor.SpanBlockFilter;
import com.wavefront.agent.preprocessor.SpanDropAnnotationTransformer;
import com.wavefront.agent.preprocessor.SpanExtractAnnotationIfNotExistsTransformer;
import com.wavefront.agent.preprocessor.SpanExtractAnnotationTransformer;
import com.wavefront.agent.preprocessor.SpanForceLowercaseTransformer;
import com.wavefront.agent.preprocessor.SpanLimitLengthTransformer;
import com.wavefront.agent.preprocessor.SpanRenameAnnotationTransformer;
import com.wavefront.agent.preprocessor.SpanReplaceRegexTransformer;
import com.wavefront.common.TaggedMetricName;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.yaml.snakeyaml.Yaml;
import wavefront.report.ReportLog;
import wavefront.report.ReportPoint;
import wavefront.report.Span;

public class PreprocessorConfigManager {
    private static final Logger logger = Logger.getLogger(PreprocessorConfigManager.class.getCanonicalName());
    private static final Counter configReloads = Metrics.newCounter((MetricName)new MetricName("preprocessor", "", "config-reloads.successful"));
    private static final Counter failedConfigReloads = Metrics.newCounter((MetricName)new MetricName("preprocessor", "", "config-reloads.failed"));
    private static final String GLOBAL_PORT_KEY = "global";
    private static final String RULE = "rule";
    private static final String ACTION = "action";
    private static final String SCOPE = "scope";
    private static final String SEARCH = "search";
    private static final String REPLACE = "replace";
    private static final String MATCH = "match";
    private static final String TAG = "tag";
    private static final String KEY = "key";
    private static final String NEWTAG = "newtag";
    private static final String NEWKEY = "newkey";
    private static final String VALUE = "value";
    private static final String SOURCE = "source";
    private static final String INPUT = "input";
    private static final String ITERATIONS = "iterations";
    private static final String REPLACE_SOURCE = "replaceSource";
    private static final String REPLACE_INPUT = "replaceInput";
    private static final String ACTION_SUBTYPE = "actionSubtype";
    private static final String MAX_LENGTH = "maxLength";
    private static final String FIRST_MATCH_ONLY = "firstMatchOnly";
    private static final String ALLOW = "allow";
    private static final String IF = "if";
    public static final String NAMES = "names";
    public static final String FUNC = "function";
    public static final String OPTS = "opts";
    private static final Set<String> ALLOWED_RULE_ARGUMENTS = ImmutableSet.of((Object)"rule", (Object)"action");
    public static final String POINT_ALTER = "pointAltering";
    public static final String POINT_FILTER = "pointFiltering";
    public static final String POINT_COUNT = "pointCount";
    public static final String SPAN_ALTER = "spanAltering";
    public static final String SPAN_FILTER = "spanFiltering";
    public static final String SPAN_COUNT = "spanCount";
    public static final String LOG_ALTER = "logAltering";
    public static final String LOG_FILTER = "logFiltering";
    public static final String LOG_COUNT = "logCount";
    private final Supplier<Long> timeSupplier;
    private final Map<String, ReportableEntityPreprocessor> systemPreprocessors = new HashMap<String, ReportableEntityPreprocessor>();
    @VisibleForTesting
    public Map<String, ReportableEntityPreprocessor> userPreprocessors;
    private Map<String, ReportableEntityPreprocessor> preprocessors = null;
    private volatile long systemPreprocessorsTs = Long.MIN_VALUE;
    private volatile long userPreprocessorsTs;
    private volatile long lastBuild = Long.MIN_VALUE;
    private String lastProcessedRules = "";
    private static Map<String, Object> ruleNode = new HashMap<String, Object>();
    @VisibleForTesting
    int totalInvalidRules = 0;
    @VisibleForTesting
    int totalValidRules = 0;
    private final Map<String, MetricsFilter> lockMetricsFilter = new WeakHashMap<String, MetricsFilter>();

    public PreprocessorConfigManager() {
        this(System::currentTimeMillis);
    }

    @VisibleForTesting
    PreprocessorConfigManager(@Nonnull Supplier<Long> timeSupplier) {
        this.timeSupplier = timeSupplier;
        this.userPreprocessorsTs = timeSupplier.get();
        this.userPreprocessors = Collections.emptyMap();
    }

    public void setUpConfigFileMonitoring(final String fileName, int fileCheckIntervalMillis) {
        new Timer("Timer-preprocessor-configmanager").schedule(new TimerTask(){

            @Override
            public void run() {
                PreprocessorConfigManager.this.loadFileIfModified(fileName);
            }
        }, fileCheckIntervalMillis, (long)fileCheckIntervalMillis);
    }

    public ReportableEntityPreprocessor getSystemPreprocessor(String key) {
        this.systemPreprocessorsTs = this.timeSupplier.get();
        return this.systemPreprocessors.computeIfAbsent(key, x -> new ReportableEntityPreprocessor());
    }

    public Supplier<ReportableEntityPreprocessor> get(String handle) {
        return () -> this.getPreprocessor(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReportableEntityPreprocessor getPreprocessor(String key) {
        if ((this.lastBuild < this.userPreprocessorsTs || this.lastBuild < this.systemPreprocessorsTs) && this.userPreprocessors != null) {
            PreprocessorConfigManager preprocessorConfigManager = this;
            synchronized (preprocessorConfigManager) {
                if ((this.lastBuild < this.userPreprocessorsTs || this.lastBuild < this.systemPreprocessorsTs) && this.userPreprocessors != null) {
                    this.preprocessors = Stream.of(this.systemPreprocessors, this.userPreprocessors).flatMap(x -> x.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, ReportableEntityPreprocessor::merge));
                    this.lastBuild = this.timeSupplier.get();
                }
            }
        }
        return this.preprocessors.computeIfAbsent(key, x -> new ReportableEntityPreprocessor());
    }

    private void requireArguments(@Nonnull Map<String, Object> rule, String ... arguments) {
        if (rule.isEmpty()) {
            throw new IllegalArgumentException("Rule is empty");
        }
        for (String argument : arguments) {
            if (rule.get(argument) != null && (!(rule.get(argument) instanceof String) || !((String)rule.get(argument)).replaceAll("[^a-z0-9_-]", "").isEmpty())) continue;
            throw new IllegalArgumentException("'" + argument + "' is missing or empty");
        }
    }

    private void allowArguments(@Nonnull Map<String, Object> rule, String ... arguments) {
        Sets.SetView invalidArguments = Sets.difference(rule.keySet(), (Set)Sets.union(ALLOWED_RULE_ARGUMENTS, (Set)Sets.newHashSet((Object[])arguments)));
        if (invalidArguments.size() > 0) {
            throw new IllegalArgumentException("Invalid or not applicable argument(s): " + StringUtils.join((Collection)invalidArguments, (String)","));
        }
    }

    @VisibleForTesting
    void loadFileIfModified(String fileName) {
        try {
            File file = new File(fileName);
            long lastModified = file.lastModified();
            if (lastModified > this.userPreprocessorsTs) {
                logger.info("File " + file + " has been modified on disk, reloading preprocessor rules");
                this.loadFile(fileName);
                configReloads.inc();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to load preprocessor rules", e);
            failedConfigReloads.inc();
        }
    }

    public void loadFile(String filename) throws FileNotFoundException {
        File file = new File(filename);
        this.loadFromStream(new FileInputStream(file));
        ruleNode.put("path", file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void loadFromStream(InputStream stream) {
        this.totalValidRules = 0;
        this.totalInvalidRules = 0;
        Yaml yaml = new Yaml();
        HashMap<String, ReportableEntityPreprocessor> portMap = new HashMap<String, ReportableEntityPreprocessor>();
        this.lockMetricsFilter.clear();
        try {
            Map rulesByPort = (Map)yaml.load(stream);
            ArrayList validRulesList = new ArrayList();
            if (rulesByPort == null || rulesByPort.isEmpty()) {
                logger.warning("Empty preprocessor rule file detected!");
                logger.info("Total 0 rules loaded");
                PreprocessorConfigManager preprocessorConfigManager = this;
                synchronized (preprocessorConfigManager) {
                    this.userPreprocessorsTs = this.timeSupplier.get();
                    this.userPreprocessors = Collections.emptyMap();
                }
                return;
            }
            for (String strPortKey : rulesByPort.keySet()) {
                List<Object> strPortList = strPortKey.equalsIgnoreCase(GLOBAL_PORT_KEY) ? new ArrayList(portMap.keySet()) : Arrays.asList(strPortKey.trim().split("\\s*,\\s*"));
                for (String string : strPortList) {
                    portMap.putIfAbsent(string, new ReportableEntityPreprocessor());
                    int validRules = 0;
                    List rules = (List)rulesByPort.get(strPortKey);
                    for (Map rule : rules) {
                        try {
                            this.requireArguments(rule, RULE, ACTION);
                            this.allowArguments(rule, SCOPE, SEARCH, REPLACE, MATCH, TAG, KEY, NEWTAG, NEWKEY, VALUE, SOURCE, INPUT, ITERATIONS, REPLACE_SOURCE, REPLACE_INPUT, ACTION_SUBTYPE, MAX_LENGTH, FIRST_MATCH_ONLY, ALLOW, IF, NAMES, FUNC, OPTS);
                            String ruleName = Objects.requireNonNull(PreprocessorUtil.getString(rule, RULE)).replaceAll("[^a-z0-9_-]", "");
                            PreprocessorRuleMetrics ruleMetrics = new PreprocessorRuleMetrics(Metrics.newCounter((MetricName)new TaggedMetricName("preprocessor." + ruleName, "count", new String[]{"port", string})), Metrics.newCounter((MetricName)new TaggedMetricName("preprocessor." + ruleName, "cpu_nanos", new String[]{"port", string})), Metrics.newCounter((MetricName)new TaggedMetricName("preprocessor." + ruleName, "checked-count", new String[]{"port", string})));
                            HashMap<String, String> saveRule = new HashMap<String, String>();
                            saveRule.put("port", string);
                            String scope = PreprocessorUtil.getString(rule, SCOPE);
                            if ("pointLine".equals(scope) || "inputText".equals(scope)) {
                                if (Predicates.getPredicate(rule) != null) {
                                    throw new IllegalArgumentException("Argument [if] is not allowed in [scope] = " + scope);
                                }
                                switch (Objects.requireNonNull(PreprocessorUtil.getString(rule, ACTION))) {
                                    case "replaceRegex": {
                                        this.allowArguments(rule, SCOPE, SEARCH, REPLACE, MATCH, ITERATIONS);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forPointLine().addTransformer((Function<String, String>)((Object)new LineBasedReplaceRegexTransformer(PreprocessorUtil.getString(rule, SEARCH), PreprocessorUtil.getString(rule, REPLACE), PreprocessorUtil.getString(rule, MATCH), PreprocessorUtil.getInteger(rule, ITERATIONS, 1), ruleMetrics)));
                                        saveRule.put("type", POINT_ALTER);
                                        break;
                                    }
                                    case "blacklistRegex": 
                                    case "block": {
                                        this.allowArguments(rule, SCOPE, MATCH);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forPointLine().addFilter(new LineBasedBlockFilter(PreprocessorUtil.getString(rule, MATCH), ruleMetrics));
                                        saveRule.put("type", POINT_FILTER);
                                        break;
                                    }
                                    case "whitelistRegex": 
                                    case "allow": {
                                        this.allowArguments(rule, SCOPE, MATCH);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forPointLine().addFilter(new LineBasedAllowFilter(PreprocessorUtil.getString(rule, MATCH), ruleMetrics));
                                        saveRule.put("type", POINT_FILTER);
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Action '" + PreprocessorUtil.getString(rule, ACTION) + "' is not valid or cannot be applied to pointLine");
                                    }
                                }
                            } else {
                                String action;
                                switch (action = Objects.requireNonNull(PreprocessorUtil.getString(rule, ACTION))) {
                                    case "metricsFilter": {
                                        this.lockMetricsFilter.computeIfPresent(string, (s, metricsFilter) -> {
                                            throw new IllegalArgumentException("Only one 'MetricsFilter' is allow per port");
                                        });
                                        this.allowArguments(rule, NAMES, FUNC, OPTS);
                                        MetricsFilter mf = new MetricsFilter(rule, ruleMetrics, ruleName, string);
                                        this.lockMetricsFilter.put(string, mf);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forPointLine().addFilter(mf);
                                        saveRule.put("type", POINT_FILTER);
                                        break;
                                    }
                                    case "replaceRegex": {
                                        this.allowArguments(rule, SCOPE, SEARCH, REPLACE, MATCH, ITERATIONS, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportPoint().addTransformer((Function<ReportPoint, ReportPoint>)((Object)new ReportPointReplaceRegexTransformer(scope, PreprocessorUtil.getString(rule, SEARCH), PreprocessorUtil.getString(rule, REPLACE), PreprocessorUtil.getString(rule, MATCH), PreprocessorUtil.getInteger(rule, ITERATIONS, 1), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", POINT_ALTER);
                                        break;
                                    }
                                    case "forceLowercase": {
                                        this.allowArguments(rule, SCOPE, MATCH, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportPoint().addTransformer((Function<ReportPoint, ReportPoint>)((Object)new ReportPointForceLowercaseTransformer(scope, PreprocessorUtil.getString(rule, MATCH), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", POINT_ALTER);
                                        break;
                                    }
                                    case "addTag": {
                                        this.allowArguments(rule, TAG, VALUE, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportPoint().addTransformer((Function<ReportPoint, ReportPoint>)((Object)new ReportPointAddTagTransformer(PreprocessorUtil.getString(rule, TAG), PreprocessorUtil.getString(rule, VALUE), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", POINT_ALTER);
                                        break;
                                    }
                                    case "addTagIfNotExists": {
                                        this.allowArguments(rule, TAG, VALUE, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportPoint().addTransformer((Function<ReportPoint, ReportPoint>)((Object)new ReportPointAddTagIfNotExistsTransformer(PreprocessorUtil.getString(rule, TAG), PreprocessorUtil.getString(rule, VALUE), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", POINT_ALTER);
                                        break;
                                    }
                                    case "dropTag": {
                                        this.allowArguments(rule, TAG, MATCH, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportPoint().addTransformer((Function<ReportPoint, ReportPoint>)((Object)new ReportPointDropTagTransformer(PreprocessorUtil.getString(rule, TAG), PreprocessorUtil.getString(rule, MATCH), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", POINT_ALTER);
                                        break;
                                    }
                                    case "extractTag": {
                                        this.allowArguments(rule, TAG, SOURCE, SEARCH, REPLACE, REPLACE_SOURCE, REPLACE_INPUT, MATCH, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportPoint().addTransformer((Function<ReportPoint, ReportPoint>)((Object)new ReportPointExtractTagTransformer(PreprocessorUtil.getString(rule, TAG), PreprocessorUtil.getString(rule, SOURCE), PreprocessorUtil.getString(rule, SEARCH), PreprocessorUtil.getString(rule, REPLACE), (String)rule.getOrDefault(REPLACE_INPUT, rule.get(REPLACE_SOURCE)), PreprocessorUtil.getString(rule, MATCH), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", POINT_ALTER);
                                        break;
                                    }
                                    case "extractTagIfNotExists": {
                                        this.allowArguments(rule, TAG, SOURCE, SEARCH, REPLACE, REPLACE_SOURCE, REPLACE_INPUT, MATCH, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportPoint().addTransformer((Function<ReportPoint, ReportPoint>)((Object)new ReportPointExtractTagIfNotExistsTransformer(PreprocessorUtil.getString(rule, TAG), PreprocessorUtil.getString(rule, SOURCE), PreprocessorUtil.getString(rule, SEARCH), PreprocessorUtil.getString(rule, REPLACE), (String)rule.getOrDefault(REPLACE_INPUT, rule.get(REPLACE_SOURCE)), PreprocessorUtil.getString(rule, MATCH), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", POINT_ALTER);
                                        break;
                                    }
                                    case "renameTag": {
                                        this.allowArguments(rule, TAG, NEWTAG, MATCH, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportPoint().addTransformer((Function<ReportPoint, ReportPoint>)((Object)new ReportPointRenameTagTransformer(PreprocessorUtil.getString(rule, TAG), PreprocessorUtil.getString(rule, NEWTAG), PreprocessorUtil.getString(rule, MATCH), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", POINT_ALTER);
                                        break;
                                    }
                                    case "limitLength": {
                                        this.allowArguments(rule, SCOPE, ACTION_SUBTYPE, MAX_LENGTH, MATCH, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportPoint().addTransformer((Function<ReportPoint, ReportPoint>)((Object)new ReportPointLimitLengthTransformer(Objects.requireNonNull(scope), PreprocessorUtil.getInteger(rule, MAX_LENGTH, 0), LengthLimitActionType.fromString(PreprocessorUtil.getString(rule, ACTION_SUBTYPE)), PreprocessorUtil.getString(rule, MATCH), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", POINT_ALTER);
                                        break;
                                    }
                                    case "count": {
                                        this.allowArguments(rule, SCOPE, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportPoint().addTransformer((Function<ReportPoint, ReportPoint>)((Object)new CountTransformer(Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", POINT_COUNT);
                                        break;
                                    }
                                    case "blacklistRegex": {
                                        logger.warning("Preprocessor rule using deprecated syntax (action: " + action + "), use 'action: block' instead!");
                                    }
                                    case "block": {
                                        this.allowArguments(rule, SCOPE, MATCH, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportPoint().addFilter(new ReportPointBlockFilter(scope, PreprocessorUtil.getString(rule, MATCH), Predicates.getPredicate(rule), ruleMetrics));
                                        saveRule.put("type", POINT_FILTER);
                                        break;
                                    }
                                    case "whitelistRegex": {
                                        logger.warning("Preprocessor rule using deprecated syntax (action: " + action + "), use 'action: allow' instead!");
                                    }
                                    case "allow": {
                                        this.allowArguments(rule, SCOPE, MATCH, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportPoint().addFilter(new ReportPointAllowFilter(scope, PreprocessorUtil.getString(rule, MATCH), Predicates.getPredicate(rule), ruleMetrics));
                                        saveRule.put("type", POINT_FILTER);
                                        break;
                                    }
                                    case "spanReplaceRegex": {
                                        this.allowArguments(rule, SCOPE, SEARCH, REPLACE, MATCH, ITERATIONS, FIRST_MATCH_ONLY, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forSpan().addTransformer((Function<Span, Span>)((Object)new SpanReplaceRegexTransformer(scope, PreprocessorUtil.getString(rule, SEARCH), PreprocessorUtil.getString(rule, REPLACE), PreprocessorUtil.getString(rule, MATCH), PreprocessorUtil.getInteger(rule, ITERATIONS, 1), PreprocessorUtil.getBoolean(rule, FIRST_MATCH_ONLY, false), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", SPAN_ALTER);
                                        break;
                                    }
                                    case "spanForceLowercase": {
                                        this.allowArguments(rule, SCOPE, MATCH, FIRST_MATCH_ONLY, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forSpan().addTransformer((Function<Span, Span>)((Object)new SpanForceLowercaseTransformer(scope, PreprocessorUtil.getString(rule, MATCH), PreprocessorUtil.getBoolean(rule, FIRST_MATCH_ONLY, false), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", SPAN_ALTER);
                                        break;
                                    }
                                    case "spanAddAnnotation": 
                                    case "spanAddTag": {
                                        this.allowArguments(rule, KEY, VALUE, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forSpan().addTransformer((Function<Span, Span>)((Object)new SpanAddAnnotationTransformer(PreprocessorUtil.getString(rule, KEY), PreprocessorUtil.getString(rule, VALUE), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", SPAN_ALTER);
                                        break;
                                    }
                                    case "spanAddAnnotationIfNotExists": 
                                    case "spanAddTagIfNotExists": {
                                        this.allowArguments(rule, KEY, VALUE, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forSpan().addTransformer((Function<Span, Span>)((Object)new SpanAddAnnotationIfNotExistsTransformer(PreprocessorUtil.getString(rule, KEY), PreprocessorUtil.getString(rule, VALUE), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", SPAN_ALTER);
                                        break;
                                    }
                                    case "spanDropAnnotation": 
                                    case "spanDropTag": {
                                        this.allowArguments(rule, KEY, MATCH, FIRST_MATCH_ONLY, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forSpan().addTransformer((Function<Span, Span>)((Object)new SpanDropAnnotationTransformer(PreprocessorUtil.getString(rule, KEY), PreprocessorUtil.getString(rule, MATCH), PreprocessorUtil.getBoolean(rule, FIRST_MATCH_ONLY, false), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", SPAN_ALTER);
                                        break;
                                    }
                                    case "spanWhitelistAnnotation": 
                                    case "spanWhitelistTag": {
                                        logger.warning("Preprocessor rule using deprecated syntax (action: " + action + "), use 'action: spanAllowAnnotation' instead!");
                                    }
                                    case "spanAllowAnnotation": 
                                    case "spanAllowTag": {
                                        this.allowArguments(rule, ALLOW, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forSpan().addTransformer((Function<Span, Span>)((Object)SpanAllowAnnotationTransformer.create(rule, Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", SPAN_FILTER);
                                        break;
                                    }
                                    case "spanExtractAnnotation": 
                                    case "spanExtractTag": {
                                        this.allowArguments(rule, KEY, INPUT, SEARCH, REPLACE, REPLACE_INPUT, MATCH, FIRST_MATCH_ONLY, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forSpan().addTransformer((Function<Span, Span>)((Object)new SpanExtractAnnotationTransformer(PreprocessorUtil.getString(rule, KEY), PreprocessorUtil.getString(rule, INPUT), PreprocessorUtil.getString(rule, SEARCH), PreprocessorUtil.getString(rule, REPLACE), PreprocessorUtil.getString(rule, REPLACE_INPUT), PreprocessorUtil.getString(rule, MATCH), PreprocessorUtil.getBoolean(rule, FIRST_MATCH_ONLY, false), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", SPAN_ALTER);
                                        break;
                                    }
                                    case "spanExtractAnnotationIfNotExists": 
                                    case "spanExtractTagIfNotExists": {
                                        this.allowArguments(rule, KEY, INPUT, SEARCH, REPLACE, REPLACE_INPUT, MATCH, FIRST_MATCH_ONLY, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forSpan().addTransformer((Function<Span, Span>)((Object)new SpanExtractAnnotationIfNotExistsTransformer(PreprocessorUtil.getString(rule, KEY), PreprocessorUtil.getString(rule, INPUT), PreprocessorUtil.getString(rule, SEARCH), PreprocessorUtil.getString(rule, REPLACE), PreprocessorUtil.getString(rule, REPLACE_INPUT), PreprocessorUtil.getString(rule, MATCH), PreprocessorUtil.getBoolean(rule, FIRST_MATCH_ONLY, false), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", SPAN_ALTER);
                                        break;
                                    }
                                    case "spanRenameAnnotation": 
                                    case "spanRenameTag": {
                                        this.allowArguments(rule, KEY, NEWKEY, MATCH, FIRST_MATCH_ONLY, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forSpan().addTransformer((Function<Span, Span>)((Object)new SpanRenameAnnotationTransformer(PreprocessorUtil.getString(rule, KEY), PreprocessorUtil.getString(rule, NEWKEY), PreprocessorUtil.getString(rule, MATCH), PreprocessorUtil.getBoolean(rule, FIRST_MATCH_ONLY, false), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", SPAN_ALTER);
                                        break;
                                    }
                                    case "spanLimitLength": {
                                        this.allowArguments(rule, SCOPE, ACTION_SUBTYPE, MAX_LENGTH, MATCH, FIRST_MATCH_ONLY, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forSpan().addTransformer((Function<Span, Span>)((Object)new SpanLimitLengthTransformer(Objects.requireNonNull(scope), PreprocessorUtil.getInteger(rule, MAX_LENGTH, 0), LengthLimitActionType.fromString(PreprocessorUtil.getString(rule, ACTION_SUBTYPE)), PreprocessorUtil.getString(rule, MATCH), PreprocessorUtil.getBoolean(rule, FIRST_MATCH_ONLY, false), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", SPAN_ALTER);
                                        break;
                                    }
                                    case "spanCount": {
                                        this.allowArguments(rule, SCOPE, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forSpan().addTransformer((Function<Span, Span>)((Object)new CountTransformer(Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", SPAN_COUNT);
                                        break;
                                    }
                                    case "spanBlacklistRegex": {
                                        logger.warning("Preprocessor rule using deprecated syntax (action: " + action + "), use 'action: spanBlock' instead!");
                                    }
                                    case "spanBlock": {
                                        this.allowArguments(rule, SCOPE, MATCH, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forSpan().addFilter(new SpanBlockFilter(scope, PreprocessorUtil.getString(rule, MATCH), Predicates.getPredicate(rule), ruleMetrics));
                                        saveRule.put("type", SPAN_FILTER);
                                        break;
                                    }
                                    case "spanWhitelistRegex": {
                                        logger.warning("Preprocessor rule using deprecated syntax (action: " + action + "), use 'action: spanAllow' instead!");
                                    }
                                    case "spanAllow": {
                                        this.allowArguments(rule, SCOPE, MATCH, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forSpan().addFilter(new SpanAllowFilter(scope, PreprocessorUtil.getString(rule, MATCH), Predicates.getPredicate(rule), ruleMetrics));
                                        saveRule.put("type", SPAN_FILTER);
                                        break;
                                    }
                                    case "logReplaceRegex": {
                                        this.allowArguments(rule, SCOPE, SEARCH, REPLACE, MATCH, ITERATIONS, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportLog().addTransformer((Function<ReportLog, ReportLog>)((Object)new ReportLogReplaceRegexTransformer(scope, PreprocessorUtil.getString(rule, SEARCH), PreprocessorUtil.getString(rule, REPLACE), PreprocessorUtil.getString(rule, MATCH), PreprocessorUtil.getInteger(rule, ITERATIONS, 1), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", LOG_ALTER);
                                        break;
                                    }
                                    case "logForceLowercase": {
                                        this.allowArguments(rule, SCOPE, MATCH, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportLog().addTransformer((Function<ReportLog, ReportLog>)((Object)new ReportLogForceLowercaseTransformer(scope, PreprocessorUtil.getString(rule, MATCH), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", LOG_ALTER);
                                        break;
                                    }
                                    case "logAddAnnotation": 
                                    case "logAddTag": {
                                        this.allowArguments(rule, KEY, VALUE, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportLog().addTransformer((Function<ReportLog, ReportLog>)((Object)new ReportLogAddTagTransformer(PreprocessorUtil.getString(rule, KEY), PreprocessorUtil.getString(rule, VALUE), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", LOG_ALTER);
                                        break;
                                    }
                                    case "logAddAnnotationIfNotExists": 
                                    case "logAddTagIfNotExists": {
                                        this.allowArguments(rule, KEY, VALUE, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportLog().addTransformer((Function<ReportLog, ReportLog>)((Object)new ReportLogAddTagIfNotExistsTransformer(PreprocessorUtil.getString(rule, KEY), PreprocessorUtil.getString(rule, VALUE), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", LOG_ALTER);
                                        break;
                                    }
                                    case "logDropAnnotation": 
                                    case "logDropTag": {
                                        this.allowArguments(rule, KEY, MATCH, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportLog().addTransformer((Function<ReportLog, ReportLog>)((Object)new ReportLogDropTagTransformer(PreprocessorUtil.getString(rule, KEY), PreprocessorUtil.getString(rule, MATCH), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", LOG_ALTER);
                                        break;
                                    }
                                    case "logAllowAnnotation": 
                                    case "logAllowTag": {
                                        this.allowArguments(rule, ALLOW, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportLog().addTransformer((Function<ReportLog, ReportLog>)((Object)ReportLogAllowTagTransformer.create(rule, Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", LOG_FILTER);
                                        break;
                                    }
                                    case "logExtractAnnotation": 
                                    case "logExtractTag": {
                                        this.allowArguments(rule, KEY, INPUT, SEARCH, REPLACE, REPLACE_INPUT, MATCH, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportLog().addTransformer((Function<ReportLog, ReportLog>)((Object)new ReportLogExtractTagTransformer(PreprocessorUtil.getString(rule, KEY), PreprocessorUtil.getString(rule, INPUT), PreprocessorUtil.getString(rule, SEARCH), PreprocessorUtil.getString(rule, REPLACE), PreprocessorUtil.getString(rule, REPLACE_INPUT), PreprocessorUtil.getString(rule, MATCH), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", LOG_ALTER);
                                        break;
                                    }
                                    case "logExtractAnnotationIfNotExists": 
                                    case "logExtractTagIfNotExists": {
                                        this.allowArguments(rule, KEY, INPUT, SEARCH, REPLACE, REPLACE_INPUT, MATCH, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportLog().addTransformer((Function<ReportLog, ReportLog>)((Object)new ReportLogExtractTagIfNotExistsTransformer(PreprocessorUtil.getString(rule, KEY), PreprocessorUtil.getString(rule, INPUT), PreprocessorUtil.getString(rule, SEARCH), PreprocessorUtil.getString(rule, REPLACE), PreprocessorUtil.getString(rule, REPLACE_INPUT), PreprocessorUtil.getString(rule, MATCH), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", LOG_ALTER);
                                        break;
                                    }
                                    case "logRenameAnnotation": 
                                    case "logRenameTag": {
                                        this.allowArguments(rule, KEY, NEWKEY, MATCH, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportLog().addTransformer((Function<ReportLog, ReportLog>)((Object)new ReportLogRenameTagTransformer(PreprocessorUtil.getString(rule, KEY), PreprocessorUtil.getString(rule, NEWKEY), PreprocessorUtil.getString(rule, MATCH), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", LOG_ALTER);
                                        break;
                                    }
                                    case "logLimitLength": {
                                        this.allowArguments(rule, SCOPE, ACTION_SUBTYPE, MAX_LENGTH, MATCH, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportLog().addTransformer((Function<ReportLog, ReportLog>)((Object)new ReportLogLimitLengthTransformer(Objects.requireNonNull(scope), PreprocessorUtil.getInteger(rule, MAX_LENGTH, 0), LengthLimitActionType.fromString(PreprocessorUtil.getString(rule, ACTION_SUBTYPE)), PreprocessorUtil.getString(rule, MATCH), Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", LOG_ALTER);
                                        break;
                                    }
                                    case "logCount": {
                                        this.allowArguments(rule, SCOPE, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportLog().addTransformer((Function<ReportLog, ReportLog>)((Object)new CountTransformer(Predicates.getPredicate(rule), ruleMetrics)));
                                        saveRule.put("type", LOG_COUNT);
                                        break;
                                    }
                                    case "logBlacklistRegex": {
                                        logger.warning("Preprocessor rule using deprecated syntax (action: " + action + "), use 'action: logBlock' instead!");
                                    }
                                    case "logBlock": {
                                        this.allowArguments(rule, SCOPE, MATCH, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportLog().addFilter(new ReportLogBlockFilter(scope, PreprocessorUtil.getString(rule, MATCH), Predicates.getPredicate(rule), ruleMetrics));
                                        saveRule.put("type", LOG_FILTER);
                                        break;
                                    }
                                    case "logWhitelistRegex": {
                                        logger.warning("Preprocessor rule using deprecated syntax (action: " + action + "), use 'action: spanAllow' instead!");
                                    }
                                    case "logAllow": {
                                        this.allowArguments(rule, SCOPE, MATCH, IF);
                                        ((ReportableEntityPreprocessor)portMap.get(string)).forReportLog().addFilter(new ReportLogAllowFilter(scope, PreprocessorUtil.getString(rule, MATCH), Predicates.getPredicate(rule), ruleMetrics));
                                        saveRule.put("type", LOG_FILTER);
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Action '" + PreprocessorUtil.getString(rule, ACTION) + "' is not valid");
                                    }
                                }
                            }
                            ++validRules;
                            saveRule.putAll(rule);
                            validRulesList.add(saveRule);
                        }
                        catch (IllegalArgumentException | NullPointerException ex) {
                            logger.warning("Invalid rule " + (rule == null ? "" : rule.getOrDefault(RULE, "")) + " (port " + string + "): " + ex);
                            ++this.totalInvalidRules;
                        }
                    }
                    logger.info("Loaded " + validRules + " rules for port :: " + string);
                    this.totalValidRules += validRules;
                }
                logger.info("Loaded Preprocessor rules for port key :: \"" + strPortKey + "\"");
            }
            ruleNode.put("rules", validRulesList);
            logger.info("Total Preprocessor rules loaded :: " + this.totalValidRules);
            ProxyCheckInScheduler.preprocessorRulesNeedUpdate.set(true);
            if (this.totalInvalidRules > 0) {
                throw new RuntimeException("Total Invalid Preprocessor rules detected :: " + this.totalInvalidRules);
            }
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Can't parse preprocessor configuration", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        PreprocessorConfigManager preprocessorConfigManager = this;
        synchronized (preprocessorConfigManager) {
            this.userPreprocessorsTs = this.timeSupplier.get();
            this.userPreprocessors = portMap;
        }
    }

    public static JsonNode getJsonRules() {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.valueToTree(ruleNode);
        return node;
    }
}

