/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.preprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import wavefront.report.ReportLog;

public class ReportLogAllowTagTransformer
implements Function<ReportLog, ReportLog> {
    private final Map<String, Pattern> allowedTags;
    private final PreprocessorRuleMetrics ruleMetrics;
    private final Predicate<ReportLog> v2Predicate;

    ReportLogAllowTagTransformer(Map<String, String> tags, @Nullable Predicate<ReportLog> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        this.allowedTags = new HashMap<String, Pattern>(tags.size());
        tags.forEach((k, v) -> this.allowedTags.put((String)k, v == null ? null : Pattern.compile(v)));
        Preconditions.checkNotNull((Object)ruleMetrics, (Object)"PreprocessorRuleMetrics can't be null");
        this.ruleMetrics = ruleMetrics;
        this.v2Predicate = v2Predicate != null ? v2Predicate : x -> true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ReportLog apply(@Nullable ReportLog reportLog) {
        if (reportLog == null) {
            return null;
        }
        long startNanos = this.ruleMetrics.ruleStart();
        try {
            if (!this.v2Predicate.test(reportLog)) {
                ReportLog reportLog2 = reportLog;
                return reportLog2;
            }
            List annotations = reportLog.getAnnotations().stream().filter(x -> this.allowedTags.containsKey(x.getKey())).filter(x -> ReportLogAllowTagTransformer.isPatternNullOrMatches(this.allowedTags.get(x.getKey()), x.getValue())).collect(Collectors.toList());
            if (annotations.size() < reportLog.getAnnotations().size()) {
                reportLog.setAnnotations(annotations);
                this.ruleMetrics.incrementRuleAppliedCounter();
            }
            ReportLog reportLog3 = reportLog;
            return reportLog3;
        }
        finally {
            this.ruleMetrics.ruleEnd(startNanos);
        }
    }

    private static boolean isPatternNullOrMatches(@Nullable Pattern pattern, String string) {
        return pattern == null || pattern.matcher(string).matches();
    }

    public static ReportLogAllowTagTransformer create(Map<String, Object> ruleMap, @Nullable Predicate<ReportLog> v2Predicate, PreprocessorRuleMetrics ruleMetrics) {
        Object tags = ruleMap.get("allow");
        if (tags instanceof Map) {
            return new ReportLogAllowTagTransformer((Map)tags, v2Predicate, ruleMetrics);
        }
        if (tags instanceof List) {
            HashMap<String, String> map = new HashMap<String, String>();
            ((List)tags).forEach(x -> map.put((String)x, (String)null));
            return new ReportLogAllowTagTransformer(map, null, ruleMetrics);
        }
        throw new IllegalArgumentException("[allow] is not a list or a map");
    }
}

